@extends('layouts.master')

@section('title', trans('messages.promissory_note'))

@section('content')
@php
    $isRTL = app()->getLocale() === 'ar';
@endphp
<div class="page-header">
    <h2>{{ trans('messages.promissory_note') }} #{{ $promissoryNote->note_number }}</h2>
    <div>
        @if(!$promissoryNote->isPaid())
            <a href="{{ route('promissory-notes.edit', $promissoryNote) }}" class="btn btn-warning"><i class="bi bi-pencil"></i> {{ trans('messages.edit') }}</a>
        @endif
        <a href="{{ route('promissory-notes.index') }}" class="btn btn-secondary">{{ trans('messages.back') }}</a>
    </div>
</div>

<div class="row">
    <div class="col-md-8">
        <div class="card mb-3">
            <div class="card-header">
                <h5 class="mb-0">{{ trans('messages.promissory_note_details') }}</h5>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-6">
                        <p><strong>{{ trans('messages.note_number') }}:</strong> {{ $promissoryNote->note_number }}</p>
                        <p><strong>{{ trans('messages.type') }}:</strong> 
                            <span class="badge bg-{{ $promissoryNote->type === 'customer' ? 'info' : 'warning' }}">
                                {{ $promissoryNote->type === 'customer' ? trans('messages.customers') : trans('messages.suppliers') }}
                            </span>
                        </p>
                        <p><strong>{{ $promissoryNote->type === 'customer' ? trans('messages.customer') : trans('messages.supplier') }}:</strong> 
                            @if($promissoryNote->type === 'customer')
                                <a href="{{ route('customers.show', $promissoryNote->customer_id) }}">{{ $promissoryNote->customer->name ?? 'N/A' }}</a>
                            @else
                                <a href="{{ route('suppliers.edit', $promissoryNote->supplier_id) }}">{{ $promissoryNote->supplier->name ?? 'N/A' }}</a>
                            @endif
                        </p>
                    </div>
                    <div class="col-md-6">
                        <p><strong>{{ trans('messages.amount') }}:</strong> <span class="badge bg-primary">{{ format_currency($promissoryNote->amount) }}</span></p>
                        <p><strong>{{ trans('messages.issue_date') }}:</strong> {{ $promissoryNote->issue_date->format('Y-m-d') }}</p>
                        <p><strong>{{ trans('messages.due_date') }}:</strong> 
                            <span class="{{ $promissoryNote->due_date < now() && !$promissoryNote->isPaid() ? 'text-danger' : '' }}">
                                {{ $promissoryNote->due_date->format('Y-m-d') }}
                            </span>
                        </p>
                        <p><strong>{{ trans('messages.status') }}:</strong> 
                            @php
                                $badgeClass = match($promissoryNote->status) {
                                    'paid' => 'success',
                                    'due' => 'warning',
                                    'cancelled' => 'secondary',
                                    default => 'info'
                                };
                            @endphp
                            <span class="badge bg-{{ $badgeClass }}">{{ trans('messages.' . $promissoryNote->status) }}</span>
                        </p>
                        @if($promissoryNote->invoice)
                        <p><strong>{{ trans('messages.invoice') }}:</strong> 
                            <a href="{{ route('invoices.show', $promissoryNote->invoice_id) }}">{{ $promissoryNote->invoice->invoice_number }}</a>
                        </p>
                        @endif
                        @if($promissoryNote->purchaseInvoice)
                        <p><strong>{{ trans('messages.purchase_invoice') }}:</strong> 
                            <a href="{{ route('purchase-invoices.show', $promissoryNote->purchase_invoice_id) }}">{{ $promissoryNote->purchaseInvoice->invoice_number }}</a>
                        </p>
                        @endif
                    </div>
                </div>
                @if($promissoryNote->notes)
                <div class="mt-3">
                    <strong>{{ trans('messages.notes') }}:</strong>
                    <p>{{ $promissoryNote->notes }}</p>
                </div>
                @endif
                @if($promissoryNote->isPaid() && $promissoryNote->paid_date)
                <div class="mt-3 alert alert-success">
                    <strong>{{ trans('messages.paid_date') }}:</strong> {{ $promissoryNote->paid_date->format('Y-m-d') }}
                </div>
                @endif
            </div>
        </div>
    </div>
    <div class="col-md-4">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0">{{ trans('messages.actions') }}</h5>
            </div>
            <div class="card-body">
                @if(!$promissoryNote->isPaid() && !$promissoryNote->isCancelled())
                    <form action="{{ route('promissory-notes.mark-as-paid', $promissoryNote) }}" method="POST" class="mb-2">
                        @csrf
                        <div class="mb-2">
                            <label for="paid_date" class="form-label">{{ trans('messages.paid_date') }}</label>
                            <input type="date" class="form-control" name="paid_date" value="{{ date('Y-m-d') }}" required>
                        </div>
                        <button type="submit" class="btn btn-success w-100"><i class="bi bi-check-circle"></i> {{ trans('messages.mark_as_paid') }}</button>
                    </form>
                @endif
                @if(!$promissoryNote->isPaid())
                    <form action="{{ route('promissory-notes.cancel', $promissoryNote) }}" method="POST" class="mb-2">
                        @csrf
                        <button type="submit" class="btn btn-secondary w-100" onclick="event.preventDefault(); confirmAction('{{ trans('messages.confirm') }}', '{{ trans('messages.confirm') }}', () => this.closest('form').submit()); return false;">
                            <i class="bi bi-x-circle"></i> {{ trans('messages.cancel') }}
                        </button>
                    </form>
                @endif
                @if(!$promissoryNote->isPaid())
                    <form action="{{ route('promissory-notes.destroy', $promissoryNote) }}" method="POST">
                        @csrf
                        @method('DELETE')
                        <button type="submit" class="btn btn-danger w-100" onclick="event.preventDefault(); confirmAction('{{ trans('messages.confirm') }}', '{{ trans('messages.confirm') }}', () => this.closest('form').submit()); return false;">
                            <i class="bi bi-trash"></i> {{ trans('messages.delete') }}
                        </button>
                    </form>
                @endif
            </div>
        </div>
    </div>
</div>
@endsection

