@php
    $storeName = \App\Models\Setting::get('store_name', 'Gestock Pro');
    $storeLogo = \App\Models\Setting::get('store_logo');
    $currency = currency_symbol();
    $footerText = \App\Models\Setting::get('invoice_footer_text', '');
    $locale = app()->getLocale();
    $isRTL = $locale === 'ar';
    $dir = $isRTL ? 'rtl' : 'ltr';
    $showLogo = \App\Models\Setting::get('purchase_invoice_show_logo', '1') === '1';
@endphp
<!DOCTYPE html>
<html lang="{{ $locale }}" dir="{{ $dir }}">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>{{ trans('messages.purchase_order') }} {{ $purchaseInvoice->invoice_number }}</title>
    <link rel="stylesheet" href="{{ asset('lib/fonts/google-fonts.css') }}">
    <link href="{{ asset('lib/css/bootstrap.min.css') }}" rel="stylesheet">
    <style>
        @charset "UTF-8";
        
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        @media print {
            .no-print {
                display: none !important;
            }
            body {
                padding: 0;
            }
        }
        
        body {
            font-family: {{ $isRTL ? "'Cairo', 'DejaVu Sans', sans-serif" : "'Cabin', 'DejaVu Sans', sans-serif" }};
            direction: {{ $dir }};
            padding: 20px;
            unicode-bidi: embed;
            font-size: 14px;
            color: #333;
        }
        
        @if($isRTL)
        * {
            font-family: 'Cairo', 'DejaVu Sans', sans-serif !important;
        }
        @else
        * {
            font-family: 'Cabin', 'DejaVu Sans', sans-serif !important;
        }
        @endif
        .header {
            border-bottom: 3px solid #0d6efd;
            padding-bottom: 20px;
            margin-bottom: 30px;
        }
        .document-title h1 {
            color: #0d6efd;
            font-weight: bold;
        }
        .buyer-info, .supplier-info {
            border: 1px solid #ddd;
            padding: 15px;
            border-radius: 5px;
        }
        .buyer-info h3, .supplier-info h3 {
            color: #0d6efd;
            border-bottom: 1px solid #ddd;
            padding-bottom: 5px;
        }
        table th {
            background-color: #0d6efd;
            color: white;
        }
        .total-table .total-row td {
            background-color: #0d6efd;
            color: white;
            font-weight: bold;
        }
        .signature-section {
            margin-top: 50px;
        }
        .signature-box {
            border-top: 2px solid #333;
            padding-top: 10px;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="text-center mb-3 no-print">
            <button onclick="window.print()" class="btn btn-primary">
                <i class="bi bi-printer"></i> {{ $isRTL ? 'طباعة' : 'Imprimer' }}
            </button>
            <button onclick="window.close()" class="btn btn-secondary ms-2">
                <i class="bi bi-x-circle"></i> {{ trans('messages.close') }}
            </button>
        </div>
        
        <div class="header">
            <div class="row align-items-center">
                <div class="col-md-6">
                    @if($showLogo && $storeLogo)
                        <img src="{{ storage_url( $storeLogo) }}" alt="{{ $storeName }}" style="max-height: 80px;">
                    @else
                        <h3>{{ $storeName }}</h3>
                    @endif
                </div>
                <div class="col-md-6 text-{{ $isRTL ? 'start' : 'end' }}">
                    <h1 class="document-title">{{ strtoupper(trans('messages.purchase_order')) }}</h1>
                    <p><strong>N°:</strong> {{ $purchaseInvoice->invoice_number }}</p>
                </div>
            </div>
        </div>

        <div class="row mb-4">
            <div class="col-md-6">
                <div class="buyer-info">
                    <h3>{{ $isRTL ? 'المشتري' : 'Acheteur' }} / {{ trans('messages.store') }}</h3>
                    <p><strong>{{ trans('messages.name') }}:</strong> {{ $storeName }}</p>
                    @php
                        $storeAddress = \App\Models\Setting::get('store_address');
                        $storePhone = \App\Models\Setting::get('store_phone');
                        $storeEmail = \App\Models\Setting::get('store_email');
                    @endphp
                    @if($storeAddress)
                        <p><strong>{{ trans('messages.address') }}:</strong> {{ $storeAddress }}</p>
                    @endif
                    @if($storePhone)
                        <p><strong>{{ trans('messages.phone') }}:</strong> {{ $storePhone }}</p>
                    @endif
                    @if($storeEmail)
                        <p><strong>{{ trans('messages.email') }}:</strong> {{ $storeEmail }}</p>
                    @endif
                </div>
            </div>
            <div class="col-md-6">
                <div class="supplier-info">
                    <h3>{{ $isRTL ? 'المورد' : 'Fournisseur' }} / {{ trans('messages.suppliers') }}</h3>
                    <p><strong>{{ trans('messages.name') }}:</strong> {{ $purchaseInvoice->supplier->name }}</p>
                    @if($purchaseInvoice->supplier->email)
                        <p><strong>{{ trans('messages.email') }}:</strong> {{ $purchaseInvoice->supplier->email }}</p>
                    @endif
                    @if($purchaseInvoice->supplier->phone)
                        <p><strong>{{ trans('messages.phone') }}:</strong> {{ $purchaseInvoice->supplier->phone }}</p>
                    @endif
                    @if($purchaseInvoice->supplier->address)
                        <p><strong>{{ trans('messages.address') }}:</strong> {{ $purchaseInvoice->supplier->address }}</p>
                    @endif
                </div>
            </div>
        </div>

        <div class="card mb-4">
            <div class="card-body bg-light">
                <div class="row">
                    <div class="col-md-4">
                        <strong>{{ trans('messages.date') }}:</strong> {{ $purchaseInvoice->purchase_date->format('d/m/Y') }}
                    </div>
                    <div class="col-md-4">
                        <strong>{{ trans('messages.created_by') }}:</strong> {{ $purchaseInvoice->user->name }}
                    </div>
                    @if($purchaseInvoice->status === 'draft')
                    <div class="col-md-4">
                        <strong>{{ $isRTL ? 'الحالة' : 'Statut' }}:</strong> 
                        <span class="badge bg-warning">{{ $isRTL ? 'مسودة' : 'Brouillon' }}</span>
                    </div>
                    @endif
                </div>
            </div>
        </div>

        <table class="table table-bordered">
            <thead>
                <tr>
                    <th style="width: 5%;">#</th>
                    <th style="width: 35%;">{{ trans('messages.products') }}</th>
                    <th style="width: 15%;">{{ trans('messages.quantity') }}</th>
                    <th style="width: 15%;">{{ trans('messages.purchase_price') }}</th>
                    <th style="width: 15%;">{{ trans('messages.tax') }}</th>
                    <th style="width: 15%;">{{ trans('messages.total') }}</th>
                </tr>
            </thead>
            <tbody>
                @foreach($purchaseInvoice->items as $index => $item)
                <tr>
                    <td>{{ $index + 1 }}</td>
                    <td>
                        <strong>{{ $item->product->name }}</strong>
                        @if($item->product->sku)
                            <br><small class="text-muted">SKU: {{ $item->product->sku }}</small>
                        @endif
                    </td>
                    <td>{{ $item->quantity }} {{ $item->product->unit ?? '' }}</td>
                    <td>{{ number_format($item->purchase_price, 2) }} {{ $currency }}</td>
                    <td>{{ number_format($item->tax, 2) }} {{ $currency }}</td>
                    <td><strong>{{ number_format($item->total, 2) }} {{ $currency }}</strong></td>
                </tr>
                @endforeach
            </tbody>
        </table>

        <div class="row">
            <div class="col-md-6"></div>
            <div class="col-md-6">
                <table class="table table-bordered total-table">
                    <tr>
                        <td><strong>{{ trans('messages.subtotal') }}</strong></td>
                        <td class="text-{{ $isRTL ? 'start' : 'end' }}">{{ number_format($purchaseInvoice->subtotal, 2) }} {{ $currency }}</td>
                    </tr>
                    @if($purchaseInvoice->discount > 0)
                    <tr>
                        <td><strong>{{ trans('messages.discount') }}</strong></td>
                        <td class="text-{{ $isRTL ? 'start' : 'end' }}">-{{ number_format($purchaseInvoice->discount, 2) }} {{ $currency }}</td>
                    </tr>
                    @endif
                    <tr>
                        <td><strong>{{ trans('messages.tax') }}</strong></td>
                        <td class="text-{{ $isRTL ? 'start' : 'end' }}">{{ number_format($purchaseInvoice->tax, 2) }} {{ $currency }}</td>
                    </tr>
                    <tr class="total-row">
                        <td><strong>{{ $isRTL ? 'المجموع الكلي' : 'Total TTC' }}</strong></td>
                        <td class="text-{{ $isRTL ? 'start' : 'end' }}"><strong>{{ number_format($purchaseInvoice->total_amount, 2) }} {{ $currency }}</strong></td>
                    </tr>
                </table>
            </div>
        </div>

        @if($purchaseInvoice->notes)
        <div class="card mt-4">
            <div class="card-body" style="border-left: 4px solid #0d6efd;">
                <h5 class="card-title" style="color: #0d6efd;">{{ $isRTL ? 'ملاحظات' : 'Notes' }} / {{ trans('messages.notes') }}:</h5>
                <p class="card-text">{{ $purchaseInvoice->notes }}</p>
            </div>
        </div>
        @endif

        <div class="row signature-section">
            <div class="col-md-6">
                <div class="signature-box">
                    <p><strong>{{ $isRTL ? 'توقيع المشتري' : 'Signature Acheteur' }}</strong></p>
                    <p style="margin-top: 40px;">_________________________</p>
                    <p style="margin-top: 5px;">{{ $purchaseInvoice->user->name }}</p>
                    <p style="margin-top: 5px;">{{ $purchaseInvoice->purchase_date->format('d/m/Y') }}</p>
                </div>
            </div>
            <div class="col-md-6">
                <div class="signature-box">
                    <p><strong>{{ $isRTL ? 'توقيع المورد' : 'Signature Fournisseur' }}</strong></p>
                    <p style="margin-top: 40px;">_________________________</p>
                    <p style="margin-top: 5px;">{{ $purchaseInvoice->supplier->name }}</p>
                    <p style="margin-top: 5px;">{{ $isRTL ? 'التاريخ' : 'Date' }}: _______________</p>
                </div>
            </div>
        </div>

        @if($footerText)
        <div class="mt-4 pt-3 border-top">
            <p class="text-muted small">{{ $footerText }}</p>
        </div>
        @endif
    </div>
</body>
</html>

