@extends('layouts.master')

@section('title', trans('messages.edit_purchase_invoice'))

@section('content')
<div class="page-header">
    <h2>{{ trans('messages.edit_purchase_invoice') }}</h2>
    <a href="{{ route('purchase-invoices.index') }}" class="btn btn-secondary">{{ trans('messages.back') }}</a>
</div>

<div class="card">
    <div class="card-body">
        <form method="POST" action="{{ route('purchase-invoices.update', $purchaseInvoice) }}" enctype="multipart/form-data" id="purchase-invoice-form">
            @csrf
            @method('PUT')
            <div class="row mb-3">
                <div class="col-md-4">
                    <label for="supplier_id" class="form-label">{{ trans('messages.suppliers') }} *</label>
                    <select class="form-select" id="supplier_id" name="supplier_id" required>
                        <option value="">{{ trans('messages.select_supplier') }}</option>
                        @foreach($suppliers as $supplier)
                            <option value="{{ $supplier->id }}" {{ $purchaseInvoice->supplier_id == $supplier->id ? 'selected' : '' }}>{{ $supplier->name }}</option>
                        @endforeach
                    </select>
                </div>
                <div class="col-md-4">
                    <label for="invoice_number" class="form-label">{{ trans('messages.invoice_number') }}</label>
                    <input type="text" class="form-control" id="invoice_number" name="invoice_number" value="{{ $purchaseInvoice->invoice_number }}">
                </div>
                <div class="col-md-4">
                    <label for="purchase_date" class="form-label">{{ trans('messages.purchase_date') }} *</label>
                    <input type="date" class="form-control" id="purchase_date" name="purchase_date" value="{{ $purchaseInvoice->purchase_date->format('Y-m-d') }}" required>
                </div>
            </div>

            @if(\App\Services\StockManager::isMultipleWarehouses() && $warehouses->count() > 1)
            <div class="row mb-3">
                <div class="col-md-4">
                    <label for="warehouse_id" class="form-label">{{ trans('messages.warehouse') }} *</label>
                    <select class="form-select" id="warehouse_id" name="warehouse_id" required>
                        <option value="">{{ trans('messages.select_warehouse') }}</option>
                        @foreach($warehouses as $warehouse)
                            <option value="{{ $warehouse->id }}" {{ $purchaseInvoice->warehouse_id == $warehouse->id ? 'selected' : '' }}>
                                {{ app()->getLocale() === 'ar' && $warehouse->name_ar ? $warehouse->name_ar : $warehouse->name }}
                            </option>
                        @endforeach
                    </select>
                </div>
            </div>
            @endif

            <div class="row mb-3">
                <div class="col-md-4">
                    <label for="status" class="form-label">{{ trans('messages.status') }} *</label>
                    <select class="form-select" id="status" name="status" required>
                        <option value="draft" {{ $purchaseInvoice->status == 'draft' ? 'selected' : '' }}>{{ trans('messages.draft') }}</option>
                        <option value="confirmed" {{ $purchaseInvoice->status == 'confirmed' ? 'selected' : '' }}>{{ trans('messages.confirmed') }}</option>
                        <option value="paid" {{ $purchaseInvoice->status == 'paid' ? 'selected' : '' }}>{{ trans('messages.paid') }}</option>
                        <option value="partially_paid" {{ $purchaseInvoice->status == 'partially_paid' ? 'selected' : '' }}>{{ trans('messages.partially_paid') }}</option>
                    </select>
                </div>
                <div class="col-md-4">
                    <label for="discount" class="form-label">{{ trans('messages.discount') }}</label>
                    <input type="number" step="0.01" class="form-control" id="discount" name="discount" value="{{ $purchaseInvoice->discount }}">
                </div>
                <div class="col-md-4">
                    <label for="supplier_invoice_file" class="form-label">{{ trans('messages.supplier_invoice_file') }}</label>
                    @if($purchaseInvoice->supplier_invoice_file)
                        <div class="mb-2">
                            <a href="{{ storage_url( $purchaseInvoice->supplier_invoice_file) }}" target="_blank" class="btn btn-sm btn-info"><i class="bi bi-file-earmark-pdf"></i> {{ trans('messages.view') }}</a>
                        </div>
                    @endif
                    <input type="file" class="form-control" id="supplier_invoice_file" name="supplier_invoice_file" accept=".pdf,.jpg,.jpeg,.png">
                </div>
            </div>

            <hr>

            <h5>{{ trans('messages.items') }}</h5>
            <div class="table-responsive mb-3">
                <table class="table" id="items-table">
                    <thead>
                        <tr>
                            <th>{{ trans('messages.products') }}</th>
                            <th>{{ trans('messages.quantity') }}</th>
                            <th>{{ trans('messages.purchase_price') }}</th>
                            <th>{{ trans('messages.batch_number') }}</th>
                            <th>{{ trans('messages.expiry_date') }}</th>
                            <th>{{ trans('messages.tax') }}</th>
                            <th>{{ trans('messages.total') }}</th>
                            <th>{{ trans('messages.actions') }}</th>
                        </tr>
                    </thead>
                    <tbody id="items-tbody">
                        @foreach($purchaseInvoice->items as $index => $item)
                        <tr class="item-row">
                            <td>
                                <select class="form-select product-select" name="items[{{ $index }}][product_id]" required>
                                    <option value="">{{ trans('messages.select_product') }}</option>
                                    @foreach($products as $product)
                                        <option value="{{ $product->id }}" data-price="{{ $product->purchase_price }}" {{ $item->product_id == $product->id ? 'selected' : '' }}>{{ $product->name }}</option>
                                    @endforeach
                                </select>
                            </td>
                            <td><input type="number" class="form-control quantity" name="items[{{ $index }}][quantity]" min="1" value="{{ $item->quantity }}" required></td>
                            <td><input type="number" step="0.01" class="form-control purchase-price" name="items[{{ $index }}][purchase_price]" value="{{ $item->purchase_price }}" required></td>
                            <td><input type="text" class="form-control batch-number" name="items[{{ $index }}][batch_number]" value="{{ $item->batch_number }}" placeholder="{{ trans('messages.optional') }}"></td>
                            <td><input type="date" class="form-control expiry-date" name="items[{{ $index }}][expiry_date]" value="{{ $item->expiry_date ? $item->expiry_date->format('Y-m-d') : '' }}"></td>
                            <td><input type="number" step="0.01" class="form-control tax" name="items[{{ $index }}][tax]" value="{{ $item->tax }}"></td>
                            <td><span class="item-total">{{ number_format($item->total, 2) }}</span> {{ currency_symbol() }}</td>
                            <td><button type="button" class="btn btn-sm btn-danger remove-item"><i class="bi bi-trash"></i></button></td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
            <button type="button" class="btn btn-sm btn-primary mb-3" id="add-item"><i class="bi bi-plus"></i> {{ trans('messages.add_item') }}</button>

            <div class="mb-3">
                <label for="notes" class="form-label">{{ trans('messages.notes') }}</label>
                <textarea class="form-control" id="notes" name="notes" rows="3">{{ $purchaseInvoice->notes }}</textarea>
            </div>

            <div class="text-end">
                <h4>{{ trans('messages.total') }}: <span id="grand-total">{{ number_format($purchaseInvoice->total_amount, 2) }}</span> {{ currency_symbol() }}</h4>
                <button type="submit" class="btn btn-primary btn-lg">{{ trans('messages.update') }}</button>
            </div>
        </form>
    </div>
</div>

@push('scripts')
<script>
let itemIndex = {{ $purchaseInvoice->items->count() }};
const currency = '{{ currency_symbol() }}';

$('#add-item').click(function() {
    const newRow = `
        <tr class="item-row">
            <td>
                <select class="form-select product-select" name="items[${itemIndex}][product_id]" required>
                    <option value="">{{ trans('messages.select_product') }}</option>
                    @foreach($products as $product)
                        <option value="{{ $product->id }}" data-price="{{ $product->purchase_price }}">{{ $product->name }}</option>
                    @endforeach
                </select>
            </td>
            <td><input type="number" class="form-control quantity" name="items[${itemIndex}][quantity]" min="1" value="1" required></td>
            <td><input type="number" step="0.01" class="form-control purchase-price" name="items[${itemIndex}][purchase_price]" required></td>
            <td><input type="text" class="form-control batch-number" name="items[${itemIndex}][batch_number]" placeholder="{{ trans('messages.optional') }}"></td>
            <td><input type="date" class="form-control expiry-date" name="items[${itemIndex}][expiry_date]"></td>
            <td><input type="number" step="0.01" class="form-control tax" name="items[${itemIndex}][tax]" value="0"></td>
            <td><span class="item-total">0.00</span> ${currency}</td>
            <td><button type="button" class="btn btn-sm btn-danger remove-item"><i class="bi bi-trash"></i></button></td>
        </tr>
    `;
    $('#items-tbody').append(newRow);
    itemIndex++;
});

// Remove item handler - using both jQuery and vanilla JS for compatibility
$(document).on('click', '.remove-item', function(e) {
    e.preventDefault();
    e.stopPropagation();
    
    const tbody = $('#items-tbody');
    const rows = tbody.find('tr.item-row');
    
    // Prevent removing the last row - must have at least one item
    if (rows.length > 1) {
        $(this).closest('tr.item-row').remove();
        calculateTotal();
    } else {
        alert('{{ trans("messages.at_least_one_item_required") }}');
    }
});

// Fallback using vanilla JavaScript if jQuery fails
document.addEventListener('click', function(e) {
    if (e.target.closest('.remove-item')) {
        e.preventDefault();
        e.stopPropagation();
        
        const row = e.target.closest('tr.item-row');
        const tbody = document.getElementById('items-tbody');
        const rows = tbody.querySelectorAll('tr.item-row');
        
        if (rows.length > 1 && row) {
            row.remove();
            if (typeof calculateTotal === 'function') {
                calculateTotal();
            }
        } else {
            alert('{{ trans("messages.at_least_one_item_required") }}');
        }
    }
});

$(document).on('change', '.product-select', function() {
    const option = $(this).find('option:selected');
    const row = $(this).closest('tr');
    row.find('.purchase-price').val(option.data('price') || 0);
    calculateRowTotal(row);
});

$(document).on('input', '.quantity, .purchase-price, .tax, #discount', function() {
    const row = $(this).closest('tr');
    if (row.hasClass('item-row')) {
        calculateRowTotal(row);
    } else {
        calculateTotal();
    }
});

function calculateRowTotal(row) {
    const quantity = parseFloat(row.find('.quantity').val()) || 0;
    const purchasePrice = parseFloat(row.find('.purchase-price').val()) || 0;
    const tax = parseFloat(row.find('.tax').val()) || 0;
    
    const total = (quantity * purchasePrice) + tax;
    
    row.find('.item-total').text(total.toFixed(2));
    calculateTotal();
}

function calculateTotal() {
    let subtotal = 0;
    $('.item-row').each(function() {
        subtotal += parseFloat($(this).find('.item-total').text()) || 0;
    });
    
    const discount = parseFloat($('#discount').val()) || 0;
    const total = subtotal - discount;
    
    $('#grand-total').text(total.toFixed(2));
}
</script>
@endpush
@endsection

