@extends('layouts.master')

@section('title', trans('messages.import_purchase_invoices'))

@section('content')
<div class="page-header">
    <h2>{{ trans('messages.import_purchase_invoices') }}</h2>
    <a href="{{ route('purchase-invoices.index') }}" class="btn btn-secondary"><i class="bi bi-arrow-left"></i> {{ trans('messages.back') }}</a>
</div>

<div class="row">
    <div class="col-md-8">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0">{{ trans('messages.upload_excel_file') }}</h5>
            </div>
            <div class="card-body">
                @if(session('success'))
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        {{ session('success') }}
                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                @endif

                @if(session('warning'))
                    <div class="alert alert-warning alert-dismissible fade show" role="alert">
                        {{ session('warning') }}
                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                @endif

                @if(session('error'))
                    <div class="alert alert-danger alert-dismissible fade show" role="alert">
                        {{ session('error') }}
                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                @endif

                <form method="POST" action="{{ route('purchase-invoices.import.post') }}" enctype="multipart/form-data">
                    @csrf
                    <div class="mb-3">
                        <label for="file" class="form-label">{{ trans('messages.select_excel_file') }} *</label>
                        <input type="file" class="form-control @error('file') is-invalid @enderror" id="file" name="file" accept=".xlsx,.xls" required>
                        <small class="form-text text-muted">{{ trans('messages.excel_file_instructions') }}</small>
                        @error('file')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    <button type="submit" class="btn btn-primary"><i class="bi bi-upload"></i> {{ trans('messages.import') }}</button>
                </form>
            </div>
        </div>

        @if(session('import_errors') && count(session('import_errors')) > 0)
        <div class="card mt-3">
            <div class="card-header bg-danger text-white">
                <h5 class="mb-0">{{ trans('messages.import_errors') }} ({{ count(session('import_errors')) }})</h5>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-sm table-bordered">
                        <thead>
                            <tr>
                                <th>{{ trans('messages.row') }}</th>
                                <th>{{ trans('messages.invoice_number') }}</th>
                                <th>{{ trans('messages.error') }}</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach(session('import_errors') as $error)
                            <tr>
                                <td>{{ $error['row'] }}</td>
                                <td>{{ $error['name'] }}</td>
                                <td class="text-danger">{{ $error['error'] }}</td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
        @endif
    </div>

    <div class="col-md-4">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0">{{ trans('messages.required_columns') }}</h5>
            </div>
            <div class="card-body">
                <h6>{{ trans('messages.required') }}:</h6>
                <ul>
                    <li><strong>invoice_number</strong> - {{ trans('messages.invoice_number') }}</li>
                    <li><strong>supplier_id</strong> - {{ trans('messages.supplier') }} (must exist in database)</li>
                </ul>

                <h6 class="mt-3">{{ trans('messages.optional') }}:</h6>
                <ul>
                    <li><strong>purchase_date</strong> - {{ trans('messages.purchase_date') }} (defaults to today)</li>
                    <li><strong>status</strong> - {{ trans('messages.status') }} (defaults to 'draft')</li>
                    <li><strong>subtotal</strong> - {{ trans('messages.subtotal') }} (defaults to 0)</li>
                    <li><strong>tax</strong> - {{ trans('messages.tax') }} (defaults to 0)</li>
                    <li><strong>discount</strong> - {{ trans('messages.discount') }} (defaults to 0)</li>
                    <li><strong>total_amount</strong> - {{ trans('messages.total') }} (auto-calculated if empty)</li>
                    <li><strong>amount_paid</strong> - {{ trans('messages.amount_paid') }} (defaults to 0)</li>
                    <li><strong>notes</strong> - {{ trans('messages.notes') }}</li>
                </ul>

                <div class="alert alert-info mt-3 mb-0">
                    <small>
                        <i class="bi bi-info-circle"></i> <strong>{{ trans('messages.note') }}:</strong><br>
                        • {{ trans('messages.invoice_number') }} must be unique.<br>
                        • <strong>supplier_id</strong> must exist in the database.<br>
                        • <strong>amount_remaining</strong> is automatically calculated as (total_amount - amount_paid).
                    </small>
                </div>

                <hr>

                <a href="{{ route('purchase-invoices.import.template') }}" class="btn btn-success w-100">
                    <i class="bi bi-download"></i> {{ trans('messages.download_template') }}
                </a>
            </div>
        </div>
    </div>
</div>
@endsection

