@extends('layouts.master')

@section('title', trans('messages.purchase_invoices'))

@section('content')
@php
    $sort = request()->get('sort', 'created_at');
    $direction = request()->get('direction', 'desc');
@endphp
<div class="page-header">
    <h2>{{ trans('messages.purchase_invoices') }}</h2>
    <div class="d-flex gap-2">
        @can('purchase-invoices.create')
            <a href="{{ route('purchase-invoices.create') }}" class="btn btn-primary"><i class="bi bi-plus-circle"></i> {{ trans('messages.add_purchase_invoice') }}</a>
        @endcan
        @can('purchase-invoices.export')
            <a href="{{ route('purchase-invoices.export', request()->query()) }}" class="btn btn-success"><i class="bi bi-file-earmark-excel"></i> {{ trans('messages.export_excel') }}</a>
        @endcan
        @can('purchase-invoices.import')
            <a href="{{ route('purchase-invoices.import') }}" class="btn btn-info"><i class="bi bi-upload"></i> {{ trans('messages.import_purchase_invoices') }}</a>
        @endcan
    </div>
</div>

<div class="card">
    <div class="card-body">
        <form method="GET" action="{{ route('purchase-invoices.index') }}" class="mb-3">
            <div class="row g-3">
                <div class="col-md-3">
                    <input type="text" name="search" class="form-control" placeholder="{{ trans('messages.search') }}..." value="{{ request('search') }}">
                </div>
                <div class="col-md-2">
                    <select name="status" class="form-select">
                        <option value="">{{ trans('messages.all_status') }}</option>
                        <option value="draft" {{ request('status') == 'draft' ? 'selected' : '' }}>{{ trans('messages.draft') }}</option>
                        <option value="confirmed" {{ request('status') == 'confirmed' ? 'selected' : '' }}>{{ trans('messages.confirmed') }}</option>
                        <option value="paid" {{ request('status') == 'paid' ? 'selected' : '' }}>{{ trans('messages.paid') }}</option>
                        <option value="partially_paid" {{ request('status') == 'partially_paid' ? 'selected' : '' }}>{{ trans('messages.partially_paid') }}</option>
                        <option value="returned" {{ request('status') == 'returned' ? 'selected' : '' }}>{{ trans('messages.returned') }}</option>
                    </select>
                </div>
                <div class="col-md-2">
                    <select name="supplier_id" class="form-select">
                        <option value="">{{ trans('messages.all_suppliers') ?? 'All Suppliers' }}</option>
                        @foreach($suppliers as $supplier)
                            <option value="{{ $supplier->id }}" {{ request('supplier_id') == $supplier->id ? 'selected' : '' }}>{{ $supplier->name }}</option>
                        @endforeach
                    </select>
                </div>
                <div class="col-md-2">
                    <input type="date" name="date_from" class="form-control" value="{{ request('date_from') }}" placeholder="{{ trans('messages.from_date') }}">
                </div>
                <div class="col-md-2">
                    <input type="date" name="date_to" class="form-control" value="{{ request('date_to') }}" placeholder="{{ trans('messages.to_date') }}">
                </div>
                <div class="col-md-1">
                    <button type="submit" class="btn btn-secondary w-100">{{ trans('messages.filter') }}</button>
                </div>
            </div>
        </form>

        @if(isset($supplierBalance) && $supplierBalance !== null && request('supplier_id'))
            @php
                $selectedSupplier = \App\Models\Supplier::find(request('supplier_id'));
            @endphp
            @if($selectedSupplier)
            <div class="alert alert-info mb-3">
                <strong>{{ trans('messages.supplier') }}:</strong> {{ $selectedSupplier->name }}<br>
                <strong>{{ trans('messages.current_balance') }}:</strong> 
                <span class="badge {{ $supplierBalance > 0 ? 'text-danger bg-light' : 'text-success bg-light' }}">
                    {{ format_currency($supplierBalance) }}
                </span>
            </div>
            @endif
        @endif

        @can('purchase-invoices.bulk_delete')
        <div class="mb-3">
            <button type="button" id="delete-selected-btn" class="btn btn-danger" disabled data-bs-toggle="modal" data-bs-target="#bulkDeleteModal">
                <i class="bi bi-trash"></i> {{ trans('messages.delete_selected') }}
            </button>
        </div>
        @endcan

        <form id="bulk-delete-form" method="POST" action="{{ route('purchase-invoices.bulk_delete') }}">
            @csrf
            <div class="table-responsive">
                <table class="table table-hover">
                    <thead>
                        <tr>
                            @if(auth()->user()->hasAnyRole(['Admin', 'Super Admin']))
                            <th style="width: 40px;">
                                <input type="checkbox" id="select-all" title="{{ trans('messages.select_all') }}">
                            </th>
                            @endif
                            <th>
                            <a href="{{ request()->fullUrlWithQuery(['sort' => 'invoice_number', 'direction' => ($sort === 'invoice_number' && $direction === 'asc') ? 'desc' : 'asc']) }}" class="text-decoration-none text-dark">
                                {{ trans('messages.invoice_number') }}
                                @if($sort === 'invoice_number')
                                    <i class="bi bi-arrow-{{ $direction === 'asc' ? 'up' : 'down' }}"></i>
                                @else
                                    <i class="bi bi-arrow-down-up text-muted"></i>
                                @endif
                            </a>
                        </th>
                        <th>{{ trans('messages.suppliers') }}</th>
                        <th>
                            <a href="{{ request()->fullUrlWithQuery(['sort' => 'purchase_date', 'direction' => ($sort === 'purchase_date' && $direction === 'asc') ? 'desc' : 'asc']) }}" class="text-decoration-none text-dark">
                                {{ trans('messages.purchase_date') }}
                                @if($sort === 'purchase_date')
                                    <i class="bi bi-arrow-{{ $direction === 'asc' ? 'up' : 'down' }}"></i>
                                @else
                                    <i class="bi bi-arrow-down-up text-muted"></i>
                                @endif
                            </a>
                        </th>
                        <th>
                            <a href="{{ request()->fullUrlWithQuery(['sort' => 'total_amount', 'direction' => ($sort === 'total_amount' && $direction === 'asc') ? 'desc' : 'asc']) }}" class="text-decoration-none text-dark">
                                {{ trans('messages.total_amount') }}
                                @if($sort === 'total_amount')
                                    <i class="bi bi-arrow-{{ $direction === 'asc' ? 'up' : 'down' }}"></i>
                                @else
                                    <i class="bi bi-arrow-down-up text-muted"></i>
                                @endif
                            </a>
                        </th>
                        <th>
                            <a href="{{ request()->fullUrlWithQuery(['sort' => 'amount_paid', 'direction' => ($sort === 'amount_paid' && $direction === 'asc') ? 'desc' : 'asc']) }}" class="text-decoration-none text-dark">
                                {{ trans('messages.amount_paid') }}
                                @if($sort === 'amount_paid')
                                    <i class="bi bi-arrow-{{ $direction === 'asc' ? 'up' : 'down' }}"></i>
                                @else
                                    <i class="bi bi-arrow-down-up text-muted"></i>
                                @endif
                            </a>
                        </th>
                        <th>
                            <a href="{{ request()->fullUrlWithQuery(['sort' => 'amount_remaining', 'direction' => ($sort === 'amount_remaining' && $direction === 'asc') ? 'desc' : 'asc']) }}" class="text-decoration-none text-dark">
                                {{ trans('messages.amount_remaining') }}
                                @if($sort === 'amount_remaining')
                                    <i class="bi bi-arrow-{{ $direction === 'asc' ? 'up' : 'down' }}"></i>
                                @else
                                    <i class="bi bi-arrow-down-up text-muted"></i>
                                @endif
                            </a>
                        </th>
                        <th>
                            <a href="{{ request()->fullUrlWithQuery(['sort' => 'status', 'direction' => ($sort === 'status' && $direction === 'asc') ? 'desc' : 'asc']) }}" class="text-decoration-none text-dark">
                                {{ trans('messages.status') }}
                                @if($sort === 'status')
                                    <i class="bi bi-arrow-{{ $direction === 'asc' ? 'up' : 'down' }}"></i>
                                @else
                                    <i class="bi bi-arrow-down-up text-muted"></i>
                                @endif
                            </a>
                        </th>
                        <th>{{ trans('messages.actions') }}</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($invoices as $invoice)
                    <tr>
                        @can('purchase-invoices.bulk_delete')
                        <td>
                            <input type="checkbox" class="item-checkbox" value="{{ $invoice->id }}">
                        </td>
                        @endcan
                        <td><a href="{{ route('purchase-invoices.show', $invoice) }}">{{ $invoice->invoice_number }}</a></td>
                        <td>{{ $invoice->supplier->name }}</td>
                        <td>{{ $invoice->purchase_date->format('Y-m-d') }}</td>
                        <td>{{ format_currency($invoice->total_amount) }}</td>
                        <td>{{ format_currency($invoice->amount_paid) }}</td>
                        <td><span class="badge bg-{{ $invoice->amount_remaining > 0 ? 'warning' : 'success' }}">{{ format_currency($invoice->amount_remaining) }}</span></td>
                        <td>
                            @php
                                $badgeClass = match($invoice->status) {
                                    'paid' => 'success',
                                    'partially_paid' => 'warning',
                                    'draft' => 'secondary',
                                    'returned' => 'danger',
                                    'confirmed' => 'info',
                                    default => 'warning'
                                };
                            @endphp
                            <span class="badge bg-{{ $badgeClass }}">{{ trans('messages.' . $invoice->status) }}</span>
                        </td>
                        <td>
                            @can('purchase-invoices.view')
                                <a href="{{ route('purchase-invoices.show', $invoice) }}" class="btn btn-sm btn-info" title="{{ trans('messages.view') }}"><i class="bi bi-eye"></i></a>
                            @endcan
                            @can('purchase-invoices.update')
                                @if($invoice->isDraft())
                                    <a href="{{ route('purchase-invoices.edit', $invoice) }}" class="btn btn-sm btn-warning" title="{{ trans('messages.edit') }}"><i class="bi bi-pencil"></i></a>
                                @endif
                            @endcan
                            @can('purchase-invoices.delete')
                                <button type="button" class="btn btn-sm btn-danger" data-bs-toggle="modal" data-bs-target="#deletePurchaseInvoiceModal{{ $invoice->id }}" title="{{ trans('messages.delete') }}">
                                    <i class="bi bi-trash"></i>
                                </button>
                            @endcan
                        </td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="{{ auth()->user()->can('purchase-invoices.bulk_delete') ? '9' : '8' }}" class="text-center">{{ trans('messages.no_purchase_invoices_found') }}</td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
        </form>

        {{ $invoices->links() }}
    </div>
</div>

@include('partials.bulk-delete-modal')

@if(auth()->user()->hasAnyRole(['Admin', 'Super Admin']))
@foreach($invoices as $invoice)
<!-- Delete Confirmation Modal for Invoice {{ $invoice->id }} -->
<div class="modal fade" id="deletePurchaseInvoiceModal{{ $invoice->id }}" tabindex="-1" aria-labelledby="deletePurchaseInvoiceModalLabel{{ $invoice->id }}" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="deletePurchaseInvoiceModalLabel{{ $invoice->id }}">{{ trans('messages.confirm_delete') }}</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <p>{{ trans('messages.confirm_delete_purchase_invoice') }}</p>
                <p><strong>{{ trans('messages.invoice_number') }}:</strong> {{ $invoice->invoice_number }}</p>
                @if(!$invoice->isReturned() && ($invoice->isConfirmed() || $invoice->status === 'paid' || $invoice->status === 'partially_paid'))
                    <div class="alert alert-warning">
                        <i class="bi bi-exclamation-triangle"></i> {{ trans('messages.stock_will_be_reversed') }}
                    </div>
                @endif
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">{{ trans('messages.cancel') }}</button>
                <form action="{{ route('purchase-invoices.destroy', $invoice) }}" method="POST" class="d-inline">
                    @csrf
                    @method('DELETE')
                    <button type="submit" class="btn btn-danger">{{ trans('messages.delete') }}</button>
                </form>
            </div>
        </div>
    </div>
</div>
@endforeach
@endif
@endsection

