@extends('layouts.master')

@section('title', trans('messages.add_complaint'))

@section('content')
<div class="page-header">
    <h2>{{ trans('messages.add_complaint') }}</h2>
    <a href="{{ route('quality.complaints.index') }}" class="btn btn-secondary">{{ trans('messages.back') }}</a>
</div>

<div class="card">
    <div class="card-body">
        <form method="POST" action="{{ route('quality.complaints.store') }}" enctype="multipart/form-data">
            @csrf
            <div class="row mb-3">
                <div class="col-md-6">
                    <label for="complaint_type" class="form-label">{{ trans('messages.complaint_type') }} *</label>
                    <select class="form-select" id="complaint_type" name="complaint_type" required>
                        <option value="customer" {{ old('complaint_type') == 'customer' ? 'selected' : '' }}>{{ trans('messages.complaint_type_customer') }}</option>
                        <option value="supplier" {{ old('complaint_type') == 'supplier' ? 'selected' : '' }}>{{ trans('messages.complaint_type_supplier') }}</option>
                        <option value="internal" {{ old('complaint_type') == 'internal' ? 'selected' : '' }}>{{ trans('messages.complaint_type_internal') }}</option>
                        <option value="other" {{ old('complaint_type') == 'other' ? 'selected' : '' }}>{{ trans('messages.complaint_type_other') }}</option>
                    </select>
                </div>
                <div class="col-md-6">
                    <label for="severity" class="form-label">{{ trans('messages.severity') }} *</label>
                    <select class="form-select" id="severity" name="severity" required>
                        <option value="low" {{ old('severity') == 'low' ? 'selected' : '' }}>{{ trans('messages.severity_low') }}</option>
                        <option value="medium" {{ old('severity', 'medium') == 'medium' ? 'selected' : '' }}>{{ trans('messages.severity_medium') }}</option>
                        <option value="high" {{ old('severity') == 'high' ? 'selected' : '' }}>{{ trans('messages.severity_high') }}</option>
                        <option value="critical" {{ old('severity') == 'critical' ? 'selected' : '' }}>{{ trans('messages.severity_critical') }}</option>
                    </select>
                </div>
            </div>

            <div class="row mb-3">
                <div class="col-md-6">
                    <label for="product_id" class="form-label">{{ trans('messages.product') }}</label>
                    <select class="form-select" id="product_id" name="product_id">
                        <option value="">{{ trans('messages.select_product') }}</option>
                        @foreach($products as $product)
                            <option value="{{ $product->id }}" {{ old('product_id', $productId) == $product->id ? 'selected' : '' }}>{{ $product->name }}</option>
                        @endforeach
                    </select>
                </div>
                <div class="col-md-6">
                    <label for="reported_date" class="form-label">{{ trans('messages.reported_date') }} *</label>
                    <input type="date" class="form-control" id="reported_date" name="reported_date" value="{{ old('reported_date', date('Y-m-d')) }}" required>
                </div>
            </div>

            <div class="row mb-3" id="customer_fields" style="display: none;">
                <div class="col-md-6">
                    <label for="customer_id" class="form-label">{{ trans('messages.customer') }}</label>
                    <select class="form-select" id="customer_id" name="customer_id">
                        <option value="">{{ trans('messages.select_customer') }}</option>
                        @foreach($customers as $customer)
                            <option value="{{ $customer->id }}" {{ old('customer_id', $customerId) == $customer->id ? 'selected' : '' }}>{{ $customer->name }}</option>
                        @endforeach
                    </select>
                </div>
                <div class="col-md-6">
                    <label for="invoice_id" class="form-label">{{ trans('messages.invoice') }}</label>
                    <select class="form-select" id="invoice_id" name="invoice_id">
                        <option value="">{{ trans('messages.select_invoice') }}</option>
                        @foreach($invoices as $invoice)
                            <option value="{{ $invoice->id }}" {{ old('invoice_id', $invoiceId) == $invoice->id ? 'selected' : '' }}>{{ $invoice->invoice_number }}</option>
                        @endforeach
                    </select>
                </div>
            </div>

            <div class="row mb-3" id="supplier_fields" style="display: none;">
                <div class="col-md-6">
                    <label for="supplier_id" class="form-label">{{ trans('messages.supplier') }}</label>
                    <select class="form-select" id="supplier_id" name="supplier_id">
                        <option value="">{{ trans('messages.select_supplier') }}</option>
                        @foreach($suppliers as $supplier)
                            <option value="{{ $supplier->id }}" {{ old('supplier_id') == $supplier->id ? 'selected' : '' }}>{{ $supplier->name }}</option>
                        @endforeach
                    </select>
                </div>
                <div class="col-md-6">
                    <label for="purchase_invoice_id" class="form-label">{{ trans('messages.purchase_invoice') }}</label>
                    <select class="form-select" id="purchase_invoice_id" name="purchase_invoice_id">
                        <option value="">{{ trans('messages.select_purchase_invoice') }}</option>
                        @foreach($purchaseInvoices as $invoice)
                            <option value="{{ $invoice->id }}" {{ old('purchase_invoice_id') == $invoice->id ? 'selected' : '' }}>{{ $invoice->invoice_number }}</option>
                        @endforeach
                    </select>
                </div>
            </div>

            <div class="row mb-3" id="other_fields">
                <div class="col-md-4">
                    <label for="complainant_name" class="form-label">{{ trans('messages.complainant_name') }}</label>
                    <input type="text" class="form-control" id="complainant_name" name="complainant_name" value="{{ old('complainant_name') }}">
                </div>
                <div class="col-md-4">
                    <label for="complainant_email" class="form-label">{{ trans('messages.complainant_email') }}</label>
                    <input type="email" class="form-control" id="complainant_email" name="complainant_email" value="{{ old('complainant_email') }}">
                </div>
                <div class="col-md-4">
                    <label for="complainant_phone" class="form-label">{{ trans('messages.complainant_phone') }}</label>
                    <input type="text" class="form-control" id="complainant_phone" name="complainant_phone" value="{{ old('complainant_phone') }}">
                </div>
            </div>

            <div class="row mb-3">
                <div class="col-md-6">
                    <label for="status" class="form-label">{{ trans('messages.status') }} *</label>
                    <select class="form-select" id="status" name="status" required>
                        <option value="new" {{ old('status', 'new') == 'new' ? 'selected' : '' }}>{{ trans('messages.status_new') }}</option>
                        <option value="in_progress" {{ old('status') == 'in_progress' ? 'selected' : '' }}>{{ trans('messages.status_in_progress') }}</option>
                        <option value="resolved" {{ old('status') == 'resolved' ? 'selected' : '' }}>{{ trans('messages.status_resolved') }}</option>
                        <option value="closed" {{ old('status') == 'closed' ? 'selected' : '' }}>{{ trans('messages.status_closed') }}</option>
                        <option value="rejected" {{ old('status') == 'rejected' ? 'selected' : '' }}>{{ trans('messages.status_rejected') }}</option>
                    </select>
                </div>
                <div class="col-md-6">
                    <label for="assigned_to" class="form-label">{{ trans('messages.assigned_to') }}</label>
                    <select class="form-select" id="assigned_to" name="assigned_to">
                        <option value="">{{ trans('messages.select_user') }}</option>
                        @foreach($users as $user)
                            <option value="{{ $user->id }}" {{ old('assigned_to') == $user->id ? 'selected' : '' }}>{{ $user->name }}</option>
                        @endforeach
                    </select>
                </div>
            </div>

            <div class="mb-3">
                <label for="description" class="form-label">{{ trans('messages.description') }} *</label>
                <textarea class="form-control" id="description" name="description" rows="4" required>{{ old('description') }}</textarea>
            </div>

            <div class="mb-3">
                <label for="description_ar" class="form-label">{{ trans('messages.description_ar') }}</label>
                <textarea class="form-control" id="description_ar" name="description_ar" rows="4">{{ old('description_ar') }}</textarea>
            </div>

            <div class="mb-3">
                <label for="images" class="form-label">{{ trans('messages.images') }}</label>
                <input type="file" class="form-control" id="images" name="images[]" multiple accept="image/*">
                <small class="form-text text-muted">{{ trans('messages.images_help') }}</small>
            </div>

            <div class="text-end">
                <button type="submit" class="btn btn-primary btn-lg">{{ trans('messages.create') }}</button>
            </div>
        </form>
    </div>
</div>

@push('scripts')
<script>
document.getElementById('complaint_type')?.addEventListener('change', function() {
    const type = this.value;
    const customerFields = document.getElementById('customer_fields');
    const supplierFields = document.getElementById('supplier_fields');
    const otherFields = document.getElementById('other_fields');
    
    customerFields.style.display = type === 'customer' ? 'block' : 'none';
    supplierFields.style.display = type === 'supplier' ? 'block' : 'none';
    otherFields.style.display = type === 'other' ? 'block' : 'block';
});
// Trigger on load
document.getElementById('complaint_type')?.dispatchEvent(new Event('change'));
</script>
@endpush
@endsection

