@extends('layouts.master')

@section('title', trans('messages.quality_complaints'))

@section('content')
@php
    $sort = request()->get('sort', 'created_at');
    $direction = request()->get('direction', 'desc');
@endphp
<div class="page-header">
    <h2>{{ trans('messages.quality_complaints') }}</h2>
    <div>
        @can('quality.complaints.create')
            <a href="{{ route('quality.complaints.create') }}" class="btn btn-primary"><i class="bi bi-plus-circle"></i> {{ trans('messages.add_complaint') }}</a>
        @endcan
    </div>
</div>

<div class="card">
    <div class="card-body">
        <form method="GET" action="{{ route('quality.complaints.index') }}" class="mb-3">
            <div class="row g-3">
                <div class="col-md-3">
                    <input type="text" name="search" class="form-control" placeholder="{{ trans('messages.search') }}..." value="{{ request('search') }}">
                </div>
                <div class="col-md-2">
                    <select name="status" class="form-select">
                        <option value="">{{ trans('messages.all_statuses') }}</option>
                        <option value="new" {{ request('status') == 'new' ? 'selected' : '' }}>{{ trans('messages.new') }}</option>
                        <option value="in_progress" {{ request('status') == 'in_progress' ? 'selected' : '' }}>{{ trans('messages.in_progress') }}</option>
                        <option value="resolved" {{ request('status') == 'resolved' ? 'selected' : '' }}>{{ trans('messages.resolved') }}</option>
                        <option value="closed" {{ request('status') == 'closed' ? 'selected' : '' }}>{{ trans('messages.closed') }}</option>
                        <option value="rejected" {{ request('status') == 'rejected' ? 'selected' : '' }}>{{ trans('messages.rejected') }}</option>
                    </select>
                </div>
                <div class="col-md-2">
                    <select name="severity" class="form-select">
                        <option value="">{{ trans('messages.all_severities') }}</option>
                        <option value="low" {{ request('severity') == 'low' ? 'selected' : '' }}>{{ trans('messages.low') }}</option>
                        <option value="medium" {{ request('severity') == 'medium' ? 'selected' : '' }}>{{ trans('messages.medium') }}</option>
                        <option value="high" {{ request('severity') == 'high' ? 'selected' : '' }}>{{ trans('messages.high') }}</option>
                        <option value="critical" {{ request('severity') == 'critical' ? 'selected' : '' }}>{{ trans('messages.critical') }}</option>
                    </select>
                </div>
                <div class="col-md-2">
                    <select name="complaint_type" class="form-select">
                        <option value="">{{ trans('messages.all_types') }}</option>
                        <option value="customer" {{ request('complaint_type') == 'customer' ? 'selected' : '' }}>{{ trans('messages.customer') }}</option>
                        <option value="supplier" {{ request('complaint_type') == 'supplier' ? 'selected' : '' }}>{{ trans('messages.supplier') }}</option>
                        <option value="internal" {{ request('complaint_type') == 'internal' ? 'selected' : '' }}>{{ trans('messages.internal') }}</option>
                        <option value="other" {{ request('complaint_type') == 'other' ? 'selected' : '' }}>{{ trans('messages.other') }}</option>
                    </select>
                </div>
                <div class="col-md-3">
                    <button type="submit" class="btn btn-secondary w-100">{{ trans('messages.filter') }}</button>
                </div>
            </div>
        </form>

        <div class="table-responsive">
            <table class="table table-hover">
                <thead>
                    <tr>
                        <th>
                            <a href="{{ route('quality.complaints.index', array_merge(request()->all(), ['sort' => 'complaint_number', 'direction' => $sort === 'complaint_number' && $direction === 'asc' ? 'desc' : 'asc'])) }}" class="text-decoration-none text-dark">
                                {{ trans('messages.complaint_number') }}
                                @if($sort === 'complaint_number')
                                    <i class="bi bi-arrow-{{ $direction === 'asc' ? 'up' : 'down' }}"></i>
                                @endif
                            </a>
                        </th>
                        <th>{{ trans('messages.complaint_type') }}</th>
                        <th>{{ trans('messages.product') }}</th>
                        <th>{{ trans('messages.complainant') }}</th>
                        <th>{{ trans('messages.severity') }}</th>
                        <th>
                            <a href="{{ route('quality.complaints.index', array_merge(request()->all(), ['sort' => 'reported_date', 'direction' => $sort === 'reported_date' && $direction === 'asc' ? 'desc' : 'asc'])) }}" class="text-decoration-none text-dark">
                                {{ trans('messages.reported_date') }}
                                @if($sort === 'reported_date')
                                    <i class="bi bi-arrow-{{ $direction === 'asc' ? 'up' : 'down' }}"></i>
                                @endif
                            </a>
                        </th>
                        <th>
                            <a href="{{ route('quality.complaints.index', array_merge(request()->all(), ['sort' => 'status', 'direction' => $sort === 'status' && $direction === 'asc' ? 'desc' : 'asc'])) }}" class="text-decoration-none text-dark">
                                {{ trans('messages.status') }}
                                @if($sort === 'status')
                                    <i class="bi bi-arrow-{{ $direction === 'asc' ? 'up' : 'down' }}"></i>
                                @endif
                            </a>
                        </th>
                        <th>{{ trans('messages.actions') }}</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($complaints as $complaint)
                    <tr>
                        <td><strong>{{ $complaint->complaint_number }}</strong></td>
                        <td>{{ trans('messages.complaint_type_' . $complaint->complaint_type) }}</td>
                        <td>
                            @if($complaint->product)
                                <a href="{{ route('products.show', $complaint->product) }}">{{ $complaint->product->name }}</a>
                            @else
                                -
                            @endif
                        </td>
                        <td>
                            @if($complaint->customer)
                                <a href="{{ route('customers.show', $complaint->customer) }}">{{ $complaint->customer->name }}</a>
                            @elseif($complaint->supplier)
                                <a href="{{ route('suppliers.show', $complaint->supplier) }}">{{ $complaint->supplier->name }}</a>
                            @elseif($complaint->complainant_name)
                                {{ $complaint->complainant_name }}
                            @else
                                -
                            @endif
                        </td>
                        <td>
                            <span class="badge bg-{{ $complaint->getSeverityBadgeClass() }}">
                                {{ trans('messages.severity_' . $complaint->severity) }}
                            </span>
                        </td>
                        <td>{{ $complaint->reported_date->format('Y-m-d') }}</td>
                        <td>
                            <span class="badge bg-{{ $complaint->getStatusBadgeClass() }}">
                                {{ trans('messages.status_' . $complaint->status) }}
                            </span>
                        </td>
                        <td>
                            <a href="{{ route('quality.complaints.show', $complaint) }}" class="btn btn-sm btn-info">
                                <i class="bi bi-eye"></i>
                            </a>
                            @can('quality.complaints.update')
                                <a href="{{ route('quality.complaints.edit', $complaint) }}" class="btn btn-sm btn-warning">
                                    <i class="bi bi-pencil"></i>
                                </a>
                            @endcan
                            @can('quality.complaints.delete')
                                <form action="{{ route('quality.complaints.destroy', $complaint) }}" method="POST" class="d-inline" onsubmit="return confirm('{{ trans('messages.confirm_delete_complaint') }}')">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="btn btn-sm btn-danger">
                                        <i class="bi bi-trash"></i>
                                    </button>
                                </form>
                            @endcan
                        </td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="8" class="text-center">{{ trans('messages.no_complaints_found') }}</td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
        </div>

        <div class="card-footer">
            {{ $complaints->links() }}
        </div>
    </div>
</div>
@endsection

