@extends('layouts.master')

@section('title', trans('messages.add_defect'))

@section('content')
<div class="page-header">
    <h2>{{ trans('messages.add_defect') }}</h2>
    <a href="{{ route('quality.defects.index') }}" class="btn btn-secondary">{{ trans('messages.back') }}</a>
</div>

<div class="card">
    <div class="card-body">
        <form method="POST" action="{{ route('quality.defects.store') }}" enctype="multipart/form-data">
            @csrf
            <div class="row mb-3">
                <div class="col-md-6">
                    <label for="product_id" class="form-label">{{ trans('messages.product') }} *</label>
                    <select class="form-select" id="product_id" name="product_id" required>
                        <option value="">{{ trans('messages.select_product') }}</option>
                        @foreach($products as $product)
                            <option value="{{ $product->id }}" {{ old('product_id', $productId) == $product->id ? 'selected' : '' }}>{{ $product->name }}</option>
                        @endforeach
                    </select>
                </div>
                @if(\App\Services\StockManager::isMultipleWarehouses() && $warehouses->count() > 0)
                <div class="col-md-6">
                    <label for="warehouse_id" class="form-label">{{ trans('messages.warehouse') }}</label>
                    <select class="form-select" id="warehouse_id" name="warehouse_id">
                        <option value="">{{ trans('messages.select_warehouse') }}</option>
                        @foreach($warehouses as $warehouse)
                            <option value="{{ $warehouse->id }}" {{ old('warehouse_id') == $warehouse->id ? 'selected' : '' }}>
                                {{ app()->getLocale() === 'ar' && $warehouse->name_ar ? $warehouse->name_ar : $warehouse->name }}
                            </option>
                        @endforeach
                    </select>
                </div>
                @endif
            </div>

            <div class="row mb-3">
                <div class="col-md-4">
                    <label for="purchase_invoice_id" class="form-label">{{ trans('messages.purchase_invoice') }}</label>
                    <select class="form-select" id="purchase_invoice_id" name="purchase_invoice_id">
                        <option value="">{{ trans('messages.select_purchase_invoice') }}</option>
                        @foreach($purchaseInvoices as $invoice)
                            <option value="{{ $invoice->id }}" {{ old('purchase_invoice_id', $purchaseInvoiceId) == $invoice->id ? 'selected' : '' }}>{{ $invoice->invoice_number }}</option>
                        @endforeach
                    </select>
                </div>
                <div class="col-md-4">
                    <label for="batch_id" class="form-label">{{ trans('messages.batch_number') }}</label>
                    <select class="form-select" id="batch_id" name="batch_id">
                        <option value="">{{ trans('messages.select_batch') }}</option>
                    </select>
                </div>
                <div class="col-md-4">
                    <label for="defect_type" class="form-label">{{ trans('messages.defect_type') }} *</label>
                    <select class="form-select" id="defect_type" name="defect_type" required>
                        <option value="manufacturing" {{ old('defect_type') == 'manufacturing' ? 'selected' : '' }}>{{ trans('messages.defect_type_manufacturing') }}</option>
                        <option value="transport" {{ old('defect_type') == 'transport' ? 'selected' : '' }}>{{ trans('messages.defect_type_transport') }}</option>
                        <option value="storage" {{ old('defect_type') == 'storage' ? 'selected' : '' }}>{{ trans('messages.defect_type_storage') }}</option>
                        <option value="other" {{ old('defect_type') == 'other' ? 'selected' : '' }}>{{ trans('messages.defect_type_other') }}</option>
                    </select>
                </div>
            </div>

            <div class="row mb-3">
                <div class="col-md-4">
                    <label for="severity" class="form-label">{{ trans('messages.severity') }} *</label>
                    <select class="form-select" id="severity" name="severity" required>
                        <option value="low" {{ old('severity') == 'low' ? 'selected' : '' }}>{{ trans('messages.severity_low') }}</option>
                        <option value="medium" {{ old('severity', 'medium') == 'medium' ? 'selected' : '' }}>{{ trans('messages.severity_medium') }}</option>
                        <option value="high" {{ old('severity') == 'high' ? 'selected' : '' }}>{{ trans('messages.severity_high') }}</option>
                        <option value="critical" {{ old('severity') == 'critical' ? 'selected' : '' }}>{{ trans('messages.severity_critical') }}</option>
                    </select>
                </div>
                <div class="col-md-4">
                    <label for="quantity" class="form-label">{{ trans('messages.quantity') }} *</label>
                    <input type="number" class="form-control" id="quantity" name="quantity" value="{{ old('quantity', 1) }}" min="1" required>
                </div>
                <div class="col-md-4">
                    <label for="reported_date" class="form-label">{{ trans('messages.reported_date') }} *</label>
                    <input type="date" class="form-control" id="reported_date" name="reported_date" value="{{ old('reported_date', date('Y-m-d')) }}" required>
                </div>
            </div>

            <div class="row mb-3">
                <div class="col-md-6">
                    <label for="status" class="form-label">{{ trans('messages.status') }} *</label>
                    <select class="form-select" id="status" name="status" required>
                        <option value="reported" {{ old('status', 'reported') == 'reported' ? 'selected' : '' }}>{{ trans('messages.status_reported') }}</option>
                        <option value="under_review" {{ old('status') == 'under_review' ? 'selected' : '' }}>{{ trans('messages.status_under_review') }}</option>
                        <option value="resolved" {{ old('status') == 'resolved' ? 'selected' : '' }}>{{ trans('messages.status_resolved') }}</option>
                        <option value="rejected" {{ old('status') == 'rejected' ? 'selected' : '' }}>{{ trans('messages.status_rejected') }}</option>
                    </select>
                </div>
                <div class="col-md-6">
                    <label for="assigned_to" class="form-label">{{ trans('messages.assigned_to') }}</label>
                    <select class="form-select" id="assigned_to" name="assigned_to">
                        <option value="">{{ trans('messages.select_user') }}</option>
                        @foreach($users as $user)
                            <option value="{{ $user->id }}" {{ old('assigned_to') == $user->id ? 'selected' : '' }}>{{ $user->name }}</option>
                        @endforeach
                    </select>
                </div>
            </div>

            <div class="mb-3">
                <label for="description" class="form-label">{{ trans('messages.description') }} *</label>
                <textarea class="form-control" id="description" name="description" rows="4" required>{{ old('description') }}</textarea>
            </div>

            <div class="mb-3">
                <label for="description_ar" class="form-label">{{ trans('messages.description_ar') }}</label>
                <textarea class="form-control" id="description_ar" name="description_ar" rows="4">{{ old('description_ar') }}</textarea>
            </div>

            <div class="mb-3">
                <label for="images" class="form-label">{{ trans('messages.images') }}</label>
                <input type="file" class="form-control" id="images" name="images[]" multiple accept="image/*">
                <small class="form-text text-muted">{{ trans('messages.images_help') }}</small>
            </div>

            <div class="text-end">
                <button type="submit" class="btn btn-primary btn-lg">{{ trans('messages.create') }}</button>
            </div>
        </form>
    </div>
</div>

@push('scripts')
<script>
// Load batches when purchase invoice is selected
document.getElementById('purchase_invoice_id')?.addEventListener('change', function() {
    const invoiceId = this.value;
    const batchSelect = document.getElementById('batch_id');
    
    if (!invoiceId) {
        batchSelect.innerHTML = '<option value="">{{ trans('messages.select_batch') }}</option>';
        return;
    }

    fetch(`/api/purchase-invoices/${invoiceId}/batches`)
        .then(response => response.json())
        .then(data => {
            batchSelect.innerHTML = '<option value="">{{ trans('messages.select_batch') }}</option>';
            data.forEach(batch => {
                const option = document.createElement('option');
                option.value = batch.id;
                option.textContent = batch.batch_number + (batch.expiry_date ? ' - ' + batch.expiry_date : '');
                batchSelect.appendChild(option);
            });
        })
        .catch(error => {
            console.error('Error loading batches:', error);
        });
});
</script>
@endpush
@endsection

