@extends('layouts.master')

@section('title', trans('messages.product_defects'))

@section('content')
@php
    $sort = request()->get('sort', 'created_at');
    $direction = request()->get('direction', 'desc');
@endphp
<div class="page-header">
    <h2>{{ trans('messages.product_defects') }}</h2>
    <div>
        @can('quality.defects.create')
            <a href="{{ route('quality.defects.create') }}" class="btn btn-primary"><i class="bi bi-plus-circle"></i> {{ trans('messages.add_defect') }}</a>
        @endcan
    </div>
</div>

<div class="card">
    <div class="card-body">
        <form method="GET" action="{{ route('quality.defects.index') }}" class="mb-3">
            <div class="row g-3">
                <div class="col-md-3">
                    <input type="text" name="search" class="form-control" placeholder="{{ trans('messages.search') }}..." value="{{ request('search') }}">
                </div>
                <div class="col-md-2">
                    <select name="status" class="form-select">
                        <option value="">{{ trans('messages.all_statuses') }}</option>
                        <option value="reported" {{ request('status') == 'reported' ? 'selected' : '' }}>{{ trans('messages.reported') }}</option>
                        <option value="under_review" {{ request('status') == 'under_review' ? 'selected' : '' }}>{{ trans('messages.under_review') }}</option>
                        <option value="resolved" {{ request('status') == 'resolved' ? 'selected' : '' }}>{{ trans('messages.resolved') }}</option>
                        <option value="rejected" {{ request('status') == 'rejected' ? 'selected' : '' }}>{{ trans('messages.rejected') }}</option>
                    </select>
                </div>
                <div class="col-md-2">
                    <select name="severity" class="form-select">
                        <option value="">{{ trans('messages.all_severities') }}</option>
                        <option value="low" {{ request('severity') == 'low' ? 'selected' : '' }}>{{ trans('messages.low') }}</option>
                        <option value="medium" {{ request('severity') == 'medium' ? 'selected' : '' }}>{{ trans('messages.medium') }}</option>
                        <option value="high" {{ request('severity') == 'high' ? 'selected' : '' }}>{{ trans('messages.high') }}</option>
                        <option value="critical" {{ request('severity') == 'critical' ? 'selected' : '' }}>{{ trans('messages.critical') }}</option>
                    </select>
                </div>
                <div class="col-md-2">
                    <select name="product_id" class="form-select">
                        <option value="">{{ trans('messages.all_products') }}</option>
                        @foreach($products as $product)
                            <option value="{{ $product->id }}" {{ request('product_id') == $product->id ? 'selected' : '' }}>{{ $product->name }}</option>
                        @endforeach
                    </select>
                </div>
                <div class="col-md-3">
                    <button type="submit" class="btn btn-secondary w-100">{{ trans('messages.filter') }}</button>
                </div>
            </div>
        </form>

        <div class="table-responsive">
            <table class="table table-hover">
                <thead>
                    <tr>
                        <th>
                            <a href="{{ route('quality.defects.index', array_merge(request()->all(), ['sort' => 'defect_number', 'direction' => $sort === 'defect_number' && $direction === 'asc' ? 'desc' : 'asc'])) }}" class="text-decoration-none text-dark">
                                {{ trans('messages.defect_number') }}
                                @if($sort === 'defect_number')
                                    <i class="bi bi-arrow-{{ $direction === 'asc' ? 'up' : 'down' }}"></i>
                                @endif
                            </a>
                        </th>
                        <th>{{ trans('messages.product') }}</th>
                        <th>{{ trans('messages.defect_type') }}</th>
                        <th>{{ trans('messages.severity') }}</th>
                        <th>{{ trans('messages.quantity') }}</th>
                        <th>
                            <a href="{{ route('quality.defects.index', array_merge(request()->all(), ['sort' => 'reported_date', 'direction' => $sort === 'reported_date' && $direction === 'asc' ? 'desc' : 'asc'])) }}" class="text-decoration-none text-dark">
                                {{ trans('messages.reported_date') }}
                                @if($sort === 'reported_date')
                                    <i class="bi bi-arrow-{{ $direction === 'asc' ? 'up' : 'down' }}"></i>
                                @endif
                            </a>
                        </th>
                        <th>
                            <a href="{{ route('quality.defects.index', array_merge(request()->all(), ['sort' => 'status', 'direction' => $sort === 'status' && $direction === 'asc' ? 'desc' : 'asc'])) }}" class="text-decoration-none text-dark">
                                {{ trans('messages.status') }}
                                @if($sort === 'status')
                                    <i class="bi bi-arrow-{{ $direction === 'asc' ? 'up' : 'down' }}"></i>
                                @endif
                            </a>
                        </th>
                        <th>{{ trans('messages.assigned_to') }}</th>
                        <th>{{ trans('messages.actions') }}</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($defects as $defect)
                    <tr>
                        <td><strong>{{ $defect->defect_number }}</strong></td>
                        <td>
                            <a href="{{ route('products.show', $defect->product) }}">{{ $defect->product->name }}</a>
                        </td>
                        <td>{{ trans('messages.defect_type_' . $defect->defect_type) }}</td>
                        <td>
                            <span class="badge bg-{{ $defect->getSeverityBadgeClass() }}">
                                {{ trans('messages.severity_' . $defect->severity) }}
                            </span>
                        </td>
                        <td>{{ number_format($defect->quantity) }}</td>
                        <td>{{ $defect->reported_date->format('Y-m-d') }}</td>
                        <td>
                            <span class="badge bg-{{ $defect->getStatusBadgeClass() }}">
                                {{ trans('messages.status_' . $defect->status) }}
                            </span>
                        </td>
                        <td>{{ $defect->assignedTo?->name ?? '-' }}</td>
                        <td>
                            <a href="{{ route('quality.defects.show', $defect) }}" class="btn btn-sm btn-info">
                                <i class="bi bi-eye"></i>
                            </a>
                            @can('quality.defects.update')
                                <a href="{{ route('quality.defects.edit', $defect) }}" class="btn btn-sm btn-warning">
                                    <i class="bi bi-pencil"></i>
                                </a>
                            @endcan
                            @can('quality.defects.delete')
                                <form action="{{ route('quality.defects.destroy', $defect) }}" method="POST" class="d-inline" onsubmit="return confirm('{{ trans('messages.confirm_delete_defect') }}')">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="btn btn-sm btn-danger">
                                        <i class="bi bi-trash"></i>
                                    </button>
                                </form>
                            @endcan
                        </td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="9" class="text-center">{{ trans('messages.no_defects_found') }}</td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
        </div>

        <div class="card-footer">
            {{ $defects->links() }}
        </div>
    </div>
</div>
@endsection

