@extends('layouts.master')

@section('title', trans('messages.edit_quotation'))

@section('content')
<div class="page-header">
    <h2>{{ trans('messages.edit_quotation') }} #{{ $invoice->invoice_number }}</h2>
    <a href="{{ route('quotations.show', $invoice) }}" class="btn btn-secondary">{{ trans('messages.back') }}</a>
</div>

<div class="card">
    <div class="card-body">
        <form method="POST" action="{{ route('quotations.update', $invoice) }}" id="quotation-form">
            @csrf
            @method('PUT')
            <div class="row mb-3">
                <div class="col-md-6">
                    <label for="customer_id" class="form-label">{{ trans('messages.customer') }}</label>
                    <select class="form-select" id="customer_id" name="customer_id">
                        <option value="">{{ trans('messages.walk_in_customer') }}</option>
                        @foreach($customers as $customer)
                            <option value="{{ $customer->id }}" {{ $invoice->customer_id == $customer->id ? 'selected' : '' }}>{{ $customer->name }}</option>
                        @endforeach
                    </select>
                </div>
                <div class="col-md-6">
                    <label for="customer_name" class="form-label">{{ trans('messages.customer_name') }} ({{ trans('messages.walk_in_customer') }})</label>
                    <input type="text" class="form-control" id="customer_name" name="customer_name" value="{{ $invoice->customer_name }}" placeholder="{{ trans('messages.walk_in_customer') }}">
                </div>
            </div>

            <div class="mb-3">
                <label class="form-label">{{ trans('messages.items') }}</label>
                <div class="table-responsive">
                    <table class="table table-bordered" id="items-table">
                        <thead>
                            <tr>
                                <th>{{ trans('messages.product') }}</th>
                                <th>{{ trans('messages.quantity') }}</th>
                                <th>{{ trans('messages.unit_price') }}</th>
                                <th>{{ trans('messages.tax_rate') }} (%)</th>
                                <th>{{ trans('messages.discount') }}</th>
                                <th>{{ trans('messages.total') }}</th>
                                <th>{{ trans('messages.actions') }}</th>
                            </tr>
                        </thead>
                        <tbody id="items-tbody">
                            @foreach($invoice->items as $index => $item)
                            <tr data-index="{{ $index }}">
                                <td>
                                    <select class="form-select product-select" name="items[{{ $index }}][product_id]" required>
                                        <option value="">{{ trans('messages.select_product') }}</option>
                                        @foreach($products as $product)
                                            <option value="{{ $product->id }}" 
                                                {{ $item->product_id == $product->id ? 'selected' : '' }}
                                                data-price="{{ $product->selling_price }}"
                                                data-tax="{{ $product->tax_rate ?? 0 }}">
                                                {{ $product->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                </td>
                                <td><input type="number" class="form-control quantity" name="items[{{ $index }}][quantity]" value="{{ $item->quantity }}" min="1" required></td>
                                <td><input type="number" class="form-control unit-price" name="items[{{ $index }}][unit_price]" value="{{ $item->unit_price }}" step="0.01" min="0" required></td>
                                <td><input type="number" class="form-control tax-rate" name="items[{{ $index }}][tax_rate]" value="{{ $item->tax_rate }}" step="0.01" min="0" max="100"></td>
                                <td><input type="number" class="form-control discount" name="items[{{ $index }}][discount]" value="{{ $item->discount }}" step="0.01" min="0"></td>
                                <td><span class="item-total">{{ format_currency($item->total) }}</span></td>
                                <td><button type="button" class="btn btn-sm btn-danger remove-item"><i class="bi bi-trash"></i></button></td>
                            </tr>
                            @endforeach
                        </tbody>
                        <tfoot>
                            <tr>
                                <td colspan="5" class="text-end"><strong>{{ trans('messages.subtotal') }}:</strong></td>
                                <td><strong id="subtotal">{{ format_currency($invoice->subtotal) }}</strong></td>
                                <td></td>
                            </tr>
                            <tr>
                                <td colspan="5" class="text-end"><strong>{{ trans('messages.discount') }}:</strong></td>
                                <td><input type="number" class="form-control" id="discount" name="discount" value="{{ $invoice->discount }}" step="0.01" min="0"></td>
                                <td></td>
                            </tr>
                            <tr>
                                <td colspan="5" class="text-end"><strong>{{ trans('messages.tax') }}:</strong></td>
                                <td><strong id="tax">{{ format_currency($invoice->tax) }}</strong></td>
                                <td></td>
                            </tr>
                            <tr>
                                <td colspan="5" class="text-end"><strong>{{ trans('messages.total') }}:</strong></td>
                                <td><strong id="total">{{ format_currency($invoice->total) }}</strong></td>
                                <td></td>
                            </tr>
                        </tfoot>
                    </table>
                </div>
                <button type="button" class="btn btn-sm btn-primary" id="add-item-btn">
                    <i class="bi bi-plus-circle"></i> {{ trans('messages.add_item') }}
                </button>
            </div>

            <div class="mb-3">
                <label for="notes" class="form-label">{{ trans('messages.notes') }}</label>
                <textarea class="form-control" id="notes" name="notes" rows="3">{{ $invoice->notes }}</textarea>
            </div>

            <div class="d-flex gap-2">
                <button type="submit" class="btn btn-primary">{{ trans('messages.save') }}</button>
                <a href="{{ route('quotations.show', $invoice) }}" class="btn btn-secondary">{{ trans('messages.cancel') }}</a>
            </div>
        </form>
    </div>
</div>

@push('scripts')
<script>
@php
    $productsArray = [];
    foreach ($products as $product) {
        $productsArray[] = [
            'id' => $product->id,
            'name' => $product->name,
            'selling_price' => $product->selling_price,
            'tax_rate' => $product->tax_rate ?? 0,
            'stock_quantity' => $product->stock_quantity,
        ];
    }
@endphp
let itemIndex = {{ count($invoice->items) }};
const products = @json($productsArray);

document.getElementById('add-item-btn')?.addEventListener('click', function() {
    const tbody = document.getElementById('items-tbody');
    const row = document.createElement('tr');
    row.className = 'item-row';
    row.dataset.index = itemIndex;
    
    const productSelect = document.createElement('select');
    productSelect.className = 'form-select product-select';
    productSelect.name = `items[${itemIndex}][product_id]`;
    productSelect.required = true;
    productSelect.innerHTML = '<option value="">{{ trans("messages.select_product") }}</option>';
    products.forEach(product => {
        const option = document.createElement('option');
        option.value = product.id;
        option.textContent = product.name;
        option.dataset.price = product.selling_price;
        option.dataset.tax = product.tax_rate;
        productSelect.appendChild(option);
    });

    row.innerHTML = `
        <td>${productSelect.outerHTML}</td>
        <td><input type="number" class="form-control quantity" name="items[${itemIndex}][quantity]" value="1" min="1" required></td>
        <td><input type="number" class="form-control unit-price" name="items[${itemIndex}][unit_price]" step="0.01" min="0" required></td>
        <td><input type="number" class="form-control tax-rate" name="items[${itemIndex}][tax_rate]" step="0.01" min="0" max="100" value="0"></td>
        <td><input type="number" class="form-control discount" name="items[${itemIndex}][discount]" step="0.01" min="0" value="0"></td>
        <td><span class="item-total">0.00</span></td>
        <td><button type="button" class="btn btn-sm btn-danger remove-item"><i class="bi bi-trash"></i></button></td>
    `;
    
    tbody.appendChild(row);
    
    // Add event listeners
    const select = row.querySelector('.product-select');
    select.addEventListener('change', function() {
        const option = this.options[this.selectedIndex];
        if (option.value) {
            row.querySelector('.unit-price').value = option.dataset.price;
            row.querySelector('.tax-rate').value = option.dataset.tax;
            calculateItemTotal(row);
        }
    });
    
    row.querySelectorAll('.quantity, .unit-price, .tax-rate, .discount').forEach(input => {
        input.addEventListener('input', () => calculateItemTotal(row));
    });
    
    row.querySelector('.remove-item').addEventListener('click', function() {
        row.remove();
        calculateTotals();
    });
    
    itemIndex++;
});

document.querySelectorAll('.remove-item').forEach(btn => {
    btn.addEventListener('click', function() {
        const row = this.closest('tr');
        const tbody = document.getElementById('items-tbody');
        if (tbody.querySelectorAll('tr').length > 1) {
            row.remove();
            calculateTotals();
        } else {
            alert('{{ trans("messages.at_least_one_item_required") }}');
        }
    });
});

document.querySelectorAll('.product-select').forEach(select => {
    select.addEventListener('change', function() {
        const row = this.closest('tr');
        const option = this.options[this.selectedIndex];
        if (option.value) {
            row.querySelector('.unit-price').value = option.dataset.price || 0;
            row.querySelector('.tax-rate').value = option.dataset.tax || 0;
            calculateItemTotal(row);
        }
    });
});

document.querySelectorAll('.quantity, .unit-price, .tax-rate, .discount').forEach(input => {
    input.addEventListener('input', function() {
        const row = this.closest('tr');
        if (row) {
            calculateItemTotal(row);
        }
    });
});

document.getElementById('discount')?.addEventListener('input', calculateTotals);

function calculateItemTotal(row) {
    const quantity = parseFloat(row.querySelector('.quantity').value) || 0;
    const unitPrice = parseFloat(row.querySelector('.unit-price').value) || 0;
    const taxRate = parseFloat(row.querySelector('.tax-rate').value) || 0;
    const discount = parseFloat(row.querySelector('.discount').value) || 0;
    
    const subtotal = quantity * unitPrice;
    const afterDiscount = subtotal - discount;
    const tax = afterDiscount * (taxRate / 100);
    const total = afterDiscount + tax;
    
    row.querySelector('.item-total').textContent = total.toFixed(2);
    calculateTotals();
}

function calculateTotals() {
    let subtotal = 0;
    let tax = 0;
    
    document.querySelectorAll('#items-tbody tr').forEach(row => {
        const quantity = parseFloat(row.querySelector('.quantity').value) || 0;
        const unitPrice = parseFloat(row.querySelector('.unit-price').value) || 0;
        const taxRate = parseFloat(row.querySelector('.tax-rate').value) || 0;
        const discount = parseFloat(row.querySelector('.discount').value) || 0;
        
        const itemSubtotal = quantity * unitPrice;
        const afterDiscount = itemSubtotal - discount;
        const itemTax = afterDiscount * (taxRate / 100);
        
        subtotal += afterDiscount;
        tax += itemTax;
    });
    
    const discount = parseFloat(document.getElementById('discount').value) || 0;
    const total = subtotal + tax - discount;
    
    document.getElementById('subtotal').textContent = subtotal.toFixed(2);
    document.getElementById('tax').textContent = tax.toFixed(2);
    document.getElementById('total').textContent = total.toFixed(2);
}

// Calculate initial totals
document.querySelectorAll('#items-tbody tr').forEach(row => {
    calculateItemTotal(row);
});
</script>
@endpush
@endsection

