@extends('layouts.master')

@section('title', trans('messages.quotations'))

@section('content')
@php
    $sort = request()->get('sort', 'created_at');
    $direction = request()->get('direction', 'desc');
@endphp
<div class="page-header">
    <h2>{{ trans('messages.quotations') }}</h2>
    <div class="d-flex gap-2">
        @can('invoices.create')
            <a href="{{ route('quotations.create') }}" class="btn btn-primary">
                <i class="bi bi-file-earmark-text"></i> {{ trans('messages.create_quotation') }}
            </a>
        @endcan
    </div>
</div>

<div class="card">
    <div class="card-body">
        @can('invoices.bulk_delete')
        <div class="mb-3">
            <button type="button" id="delete-selected-btn" class="btn btn-danger" disabled onclick="bulkDeleteQuotations()">
                <i class="bi bi-trash"></i> {{ trans('messages.delete_selected') }}
            </button>
        </div>
        @endcan

        <form method="GET" action="{{ route('quotations.index') }}" class="mb-3">
            <div class="row g-3">
                <div class="col-md-3">
                    <input type="text" name="search" class="form-control" placeholder="{{ trans('messages.search') }}..." value="{{ request('search') }}">
                </div>
                <div class="col-md-2">
                    <input type="date" name="date_from" class="form-control" placeholder="{{ trans('messages.from_date') }}" value="{{ request('date_from') }}">
                </div>
                <div class="col-md-2">
                    <input type="date" name="date_to" class="form-control" placeholder="{{ trans('messages.to_date') }}" value="{{ request('date_to') }}">
                </div>
                <div class="col-md-2">
                    <button type="submit" class="btn btn-secondary w-100">{{ trans('messages.filter') }}</button>
                </div>
            </div>
        </form>

        <div class="table-responsive">
            <table class="table table-hover">
                <thead>
                    <tr>
                        @can('invoices.bulk_delete')
                        <th style="width: 40px;">
                            <input type="checkbox" id="select-all-quotations" title="{{ trans('messages.select_all') }}">
                        </th>
                        @endcan
                        <th>
                            <a href="{{ request()->fullUrlWithQuery(['sort' => 'invoice_number', 'direction' => ($sort === 'invoice_number' && $direction === 'asc') ? 'desc' : 'asc']) }}" class="text-decoration-none text-dark">
                                {{ trans('messages.quotation_number') }}
                                @if($sort === 'invoice_number')
                                    <i class="bi bi-arrow-{{ $direction === 'asc' ? 'up' : 'down' }}"></i>
                                @else
                                    <i class="bi bi-arrow-down-up text-muted"></i>
                                @endif
                            </a>
                        </th>
                        <th>{{ trans('messages.customer') }}</th>
                        <th>
                            <a href="{{ request()->fullUrlWithQuery(['sort' => 'created_at', 'direction' => ($sort === 'created_at' && $direction === 'asc') ? 'desc' : 'asc']) }}" class="text-decoration-none text-dark">
                                {{ trans('messages.date') }}
                                @if($sort === 'created_at')
                                    <i class="bi bi-arrow-{{ $direction === 'asc' ? 'up' : 'down' }}"></i>
                                @else
                                    <i class="bi bi-arrow-down-up text-muted"></i>
                                @endif
                            </a>
                        </th>
                        <th>
                            <a href="{{ request()->fullUrlWithQuery(['sort' => 'total', 'direction' => ($sort === 'total' && $direction === 'asc') ? 'desc' : 'asc']) }}" class="text-decoration-none text-dark">
                                {{ trans('messages.total') }}
                                @if($sort === 'total')
                                    <i class="bi bi-arrow-{{ $direction === 'asc' ? 'up' : 'down' }}"></i>
                                @else
                                    <i class="bi bi-arrow-down-up text-muted"></i>
                                @endif
                            </a>
                        </th>
                        <th>{{ trans('messages.actions') }}</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($quotations as $quotation)
                    <tr>
                        @can('invoices.bulk_delete')
                        <td>
                            <input type="checkbox" class="quotation-checkbox" value="{{ $quotation->id }}">
                        </td>
                        @endcan
                                    <td><a href="{{ route('quotations.show', $quotation) }}">{{ $quotation->invoice_number }}</a></td>
                        <td>{{ $quotation->customer?->name ?? $quotation->customer_name }}</td>
                        <td>{{ $quotation->created_at->format('Y-m-d') }}</td>
                        <td>{{ format_currency($quotation->total) }}</td>
                        <td>
                            <a href="{{ route('quotations.show', $quotation) }}" class="btn btn-sm btn-info">{{ trans('messages.view') }}</a>
                            <a href="{{ route('invoices.devis', $quotation) }}" class="btn btn-sm btn-primary" target="_blank">
                                <i class="bi bi-printer"></i> {{ trans('messages.print_quotation') }}
                            </a>
                            @can('invoices.finalize')
                            <form action="{{ route('invoices.convert-quotation-to-invoice', $quotation) }}" method="POST" class="d-inline">
                                @csrf
                                <button type="submit" class="btn btn-sm btn-success" onclick="return confirm('{{ trans('messages.confirm_convert_quotation_to_invoice') }}')">
                                    <i class="bi bi-receipt"></i> {{ trans('messages.convert_to_invoice') }}
                                </button>
                            </form>
                            @endcan
                            @can('invoices.delete')
                            <form action="{{ route('quotations.destroy', $quotation) }}" method="POST" class="d-inline" onsubmit="return confirm('{{ trans('messages.confirm_delete') }}')">
                                @csrf
                                @method('DELETE')
                                <button type="submit" class="btn btn-sm btn-danger">{{ trans('messages.delete') }}</button>
                            </form>
                            @endcan
                        </td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="{{ auth()->user()->can('invoices.bulk_delete') ? '6' : '5' }}" class="text-center">{{ trans('messages.no_quotations_found') }}</td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
        </div>

        <div class="mt-3">
            {{ $quotations->links() }}
        </div>
    </div>
</div>

@can('invoices.bulk_delete')
@push('scripts')
<script>
document.getElementById('select-all-quotations')?.addEventListener('change', function() {
    const checkboxes = document.querySelectorAll('.quotation-checkbox');
    checkboxes.forEach(cb => cb.checked = this.checked);
    updateDeleteButton();
});

document.querySelectorAll('.quotation-checkbox').forEach(checkbox => {
    checkbox.addEventListener('change', updateDeleteButton);
});

function updateDeleteButton() {
    const checked = document.querySelectorAll('.quotation-checkbox:checked').length;
    const btn = document.getElementById('delete-selected-btn');
    if (btn) {
        btn.disabled = checked === 0;
    }
}

function bulkDeleteQuotations() {
    const selected = Array.from(document.querySelectorAll('.quotation-checkbox:checked')).map(cb => cb.value);
    if (selected.length === 0) return;
    
    if (confirm('{{ trans('messages.confirm_delete_selected') }}: ' + selected.length + ' {{ trans('messages.items') }}?')) {
        const form = document.createElement('form');
        form.method = 'POST';
        form.action = '{{ route('quotations.bulk-delete') }}';
        form.innerHTML = `
            @csrf
            @method('POST')
            ${selected.map(id => `<input type="hidden" name="selected_ids[]" value="${id}">`).join('')}
        `;
        document.body.appendChild(form);
        form.submit();
    }
}
</script>
@endpush
@endcan
@endsection

