@extends('layouts.master')

@section('title', trans('messages.balance_sheet_report'))

@section('content')
<div class="page-header">
    <h2>{{ trans('messages.balance_sheet_report') }}</h2>
    <div>
        <a href="{{ route('reports.balance-sheet.print', request()->all()) }}" target="_blank" class="btn btn-primary">
            <i class="bi bi-printer"></i> {{ trans('messages.print_report') }}
        </a>
        <a href="{{ route('reports.index') }}" class="btn btn-secondary">
            <i class="bi bi-arrow-left"></i> {{ trans('messages.back') }}
        </a>
    </div>
</div>

<div class="card mb-3">
    <div class="card-body">
        <form method="GET" action="{{ route('reports.balance-sheet') }}">
            <div class="row g-3">
                <div class="col-md-4">
                    <label for="as_of_date" class="form-label">{{ trans('messages.as_of_date') }}</label>
                    <input type="date" name="as_of_date" class="form-control" value="{{ $asOfDate }}">
                </div>
                <div class="col-md-4">
                    <label class="form-label">&nbsp;</label>
                    <button type="submit" class="btn btn-primary w-100 d-block">{{ trans('messages.filter') }}</button>
                </div>
            </div>
        </form>
    </div>
</div>

<div class="row g-3 mb-4">
    <!-- Assets -->
    <div class="col-md-6">
        <div class="card border-success">
            <div class="card-header bg-success text-white">
                <h5 class="mb-0"><i class="bi bi-wallet2"></i> {{ trans('messages.assets') }}</h5>
            </div>
            <div class="card-body">
                <table class="table table-sm">
                    <tr>
                        <td>{{ trans('messages.cash') }}:</td>
                        <td class="text-end"><strong>{{ format_currency($assetsBreakdown['cash']) }}</strong></td>
                    </tr>
                    <tr>
                        <td>{{ trans('messages.inventory') }}:</td>
                        <td class="text-end"><strong>{{ format_currency($assetsBreakdown['inventory']) }}</strong></td>
                    </tr>
                    <tr>
                        <td>{{ trans('messages.accounts_receivable') }}:</td>
                        <td class="text-end"><strong>{{ format_currency($assetsBreakdown['accounts_receivable']) }}</strong></td>
                    </tr>
                    <tr class="table-success">
                        <td><strong>{{ trans('messages.total_assets') }}:</strong></td>
                        <td class="text-end"><strong>{{ format_currency($totalAssets) }}</strong></td>
                    </tr>
                </table>
            </div>
        </div>
    </div>

    <!-- Liabilities & Equity -->
    <div class="col-md-6">
        <div class="card border-danger">
            <div class="card-header bg-danger text-white">
                <h5 class="mb-0"><i class="bi bi-exclamation-triangle"></i> {{ trans('messages.liabilities') }}</h5>
            </div>
            <div class="card-body">
                <table class="table table-sm">
                    <tr>
                        <td>{{ trans('messages.accounts_payable') }}:</td>
                        <td class="text-end"><strong>{{ format_currency($liabilitiesBreakdown['accounts_payable']) }}</strong></td>
                    </tr>
                    <tr class="table-danger">
                        <td><strong>{{ trans('messages.total_liabilities') }}:</strong></td>
                        <td class="text-end"><strong>{{ format_currency($totalLiabilities) }}</strong></td>
                    </tr>
                </table>
            </div>
        </div>

        <div class="card border-primary mt-3">
            <div class="card-header bg-primary text-white">
                <h5 class="mb-0"><i class="bi bi-graph-up"></i> {{ trans('messages.equity') }}</h5>
            </div>
            <div class="card-body">
                <h3 class="text-center {{ $equity >= 0 ? 'text-success' : 'text-danger' }}">
                    {{ format_currency($equity) }}
                </h3>
                <p class="text-center text-muted mb-0">
                    {{ trans('messages.total_assets') }} - {{ trans('messages.total_liabilities') }}
                </p>
            </div>
        </div>
    </div>
</div>

<div class="card">
    <div class="card-header">
        <h5 class="mb-0">{{ trans('messages.balance_sheet_summary') }}</h5>
    </div>
    <div class="card-body">
        <div class="row">
            <div class="col-md-4">
                <div class="text-center p-3 bg-light rounded">
                    <h6 class="text-muted">{{ trans('messages.total_assets') }}</h6>
                    <h4 class="text-success mb-0">{{ format_currency($totalAssets) }}</h4>
                </div>
            </div>
            <div class="col-md-4">
                <div class="text-center p-3 bg-light rounded">
                    <h6 class="text-muted">{{ trans('messages.total_liabilities') }}</h6>
                    <h4 class="text-danger mb-0">{{ format_currency($totalLiabilities) }}</h4>
                </div>
            </div>
            <div class="col-md-4">
                <div class="text-center p-3 bg-light rounded">
                    <h6 class="text-muted">{{ trans('messages.equity') }}</h6>
                    <h4 class="{{ $equity >= 0 ? 'text-success' : 'text-danger' }} mb-0">
                        {{ format_currency($equity) }}
                    </h4>
                </div>
            </div>
        </div>
    </div>
</div>

@include('reports.partials.print-styles', ['reportTitle' => trans('messages.balance_sheet_report')])
@endsection

