@php
    $storeName = \App\Models\Setting::get('store_name', 'Gestock Pro');
    $storeLogo = \App\Models\Setting::get('store_logo');
    $currency = currency_symbol();
    $locale = app()->getLocale();
    $isRTL = $locale === 'ar';
    $dir = $isRTL ? 'rtl' : 'ltr';
@endphp
<!DOCTYPE html>
<html lang="{{ $locale }}" dir="{{ $dir }}">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>{{ trans('messages.balance_sheet_report') }}</title>
    <link rel="stylesheet" href="{{ asset('lib/fonts/google-fonts.css') }}">
    <style>
        @charset "UTF-8";
        
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: {{ $isRTL ? "'Cairo', 'DejaVu Sans', sans-serif" : "'Cabin', 'DejaVu Sans', sans-serif" }};
            direction: {{ $dir }};
            font-size: 14px;
            color: #333;
            padding: 20px;
            background-color: #fff;
            unicode-bidi: embed;
        }
        
        @if($isRTL)
        * {
            font-family: 'Cairo', 'DejaVu Sans', sans-serif !important;
        }
        @else
        * {
            font-family: 'Cabin', 'DejaVu Sans', sans-serif !important;
        }
        @endif
        
        .header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 30px;
            border-bottom: 2px solid #333;
            padding-bottom: 20px;
        }
        
        .logo-container {
            {{ $isRTL ? 'text-align: right;' : 'text-align: left;' }}
        }
        
        .logo-container img {
            max-height: 80px;
            max-width: 200px;
        }
        
        .report-info {
            {{ $isRTL ? 'text-align: left;' : 'text-align: right;' }}
        }
        
        .report-info h2 {
            margin-bottom: 10px;
            color: #333;
            font-size: 24px;
        }
        
        .report-info p {
            margin: 5px 0;
            font-size: 14px;
            color: #666;
        }
        
        .balance-sheet {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 30px;
            margin-bottom: 30px;
        }
        
        .section {
            border: 2px solid #dee2e6;
            border-radius: 5px;
            overflow: hidden;
        }
        
        .section-header {
            padding: 15px;
            font-weight: bold;
            font-size: 18px;
            color: white;
        }
        
        .section.assets .section-header {
            background-color: #28a745;
        }
        
        .section.liabilities .section-header {
            background-color: #dc3545;
        }
        
        .section.equity .section-header {
            background-color: #0d6efd;
        }
        
        .section-body {
            padding: 20px;
        }
        
        table {
            width: 100%;
            border-collapse: collapse;
        }
        
        table td {
            padding: 10px;
            border-bottom: 1px solid #dee2e6;
        }
        
        table tr:last-child td {
            border-bottom: none;
        }
        
        .total-row {
            font-weight: bold;
            background-color: #f8f9fa;
            font-size: 16px;
        }
        
        .summary {
            display: grid;
            grid-template-columns: repeat(3, 1fr);
            gap: 20px;
            margin-top: 30px;
        }
        
        .summary-item {
            text-align: center;
            padding: 20px;
            border-radius: 5px;
            background-color: #f8f9fa;
        }
        
        .summary-item h4 {
            font-size: 14px;
            color: #666;
            margin-bottom: 10px;
        }
        
        .summary-item .value {
            font-size: 24px;
            font-weight: bold;
        }
        
        .summary-item.assets .value {
            color: #28a745;
        }
        
        .summary-item.liabilities .value {
            color: #dc3545;
        }
        
        .summary-item.equity .value {
            color: #0d6efd;
        }
        
        .text-right {
            text-align: {{ $isRTL ? 'left' : 'right' }} !important;
        }
        
        .print-actions {
            margin-bottom: 20px;
            text-align: center;
        }
        
        .print-actions button {
            padding: 10px 20px;
            font-size: 16px;
            background-color: #0d6efd;
            color: white;
            border: none;
            border-radius: 5px;
            cursor: pointer;
            margin: 0 10px;
        }
        
        .print-actions button:hover {
            background-color: #0b5ed7;
        }
        
        @media print {
            .print-actions {
                display: none;
            }
            
            @page {
                size: A4;
                margin: 10mm;
            }
            
            body {
                padding: 0;
            }
        }
    </style>
</head>
<body>
    <div class="print-actions">
        <button onclick="window.print()" class="btn btn-primary">
            <i class="bi bi-printer"></i> {{ trans('messages.print') }}
        </button>
        <button onclick="window.close()" class="btn btn-secondary" style="margin-{{ $isRTL ? 'right' : 'left' }}: 10px;">
            <i class="bi bi-x-circle"></i> {{ trans('messages.close') }}
        </button>
    </div>

    <div class="header">
        <div class="logo-container">
            @if($storeLogo)
                <img src="{{ storage_url( $storeLogo) }}" alt="{{ $storeName }}">
            @else
                <h2>{{ $storeName }}</h2>
            @endif
        </div>
        <div class="report-info">
            <h2>{{ trans('messages.balance_sheet_report') }}</h2>
            <p>{{ trans('messages.as_of_date') }}: {{ $asOfDate }}</p>
            <p>{{ trans('messages.date') }}: {{ now()->format('Y-m-d H:i') }}</p>
        </div>
    </div>

    <div class="balance-sheet">
        <div class="section assets">
            <div class="section-header">
                {{ trans('messages.assets') }}
            </div>
            <div class="section-body">
                <table>
                    <tr>
                        <td>{{ trans('messages.cash') }}</td>
                        <td class="text-right">{{ format_currency($assetsBreakdown['cash']) }}</td>
                    </tr>
                    <tr>
                        <td>{{ trans('messages.inventory') }}</td>
                        <td class="text-right">{{ format_currency($assetsBreakdown['inventory']) }}</td>
                    </tr>
                    <tr>
                        <td>{{ trans('messages.accounts_receivable') }}</td>
                        <td class="text-right">{{ format_currency($assetsBreakdown['accounts_receivable']) }}</td>
                    </tr>
                    <tr class="total-row">
                        <td><strong>{{ trans('messages.total_assets') }}</strong></td>
                        <td class="text-right"><strong>{{ format_currency($totalAssets) }}</strong></td>
                    </tr>
                </table>
            </div>
        </div>

        <div>
            <div class="section liabilities">
                <div class="section-header">
                    {{ trans('messages.liabilities') }}
                </div>
                <div class="section-body">
                    <table>
                        <tr>
                            <td>{{ trans('messages.accounts_payable') }}</td>
                            <td class="text-right">{{ format_currency($liabilitiesBreakdown['accounts_payable']) }}</td>
                        </tr>
                        <tr class="total-row">
                            <td><strong>{{ trans('messages.total_liabilities') }}</strong></td>
                            <td class="text-right"><strong>{{ format_currency($totalLiabilities) }}</strong></td>
                        </tr>
                    </table>
                </div>
            </div>

            <div class="section equity" style="margin-top: 20px;">
                <div class="section-header">
                    {{ trans('messages.equity') }}
                </div>
                <div class="section-body">
                    <div style="text-align: center; padding: 20px;">
                        <div style="font-size: 32px; font-weight: bold; color: {{ $equity >= 0 ? '#28a745' : '#dc3545' }};">
                            {{ format_currency($equity) }}
                        </div>
                        <div style="font-size: 12px; color: #666; margin-top: 10px;">
                            {{ trans('messages.total_assets') }} - {{ trans('messages.total_liabilities') }}
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="summary">
        <div class="summary-item assets">
            <h4>{{ trans('messages.total_assets') }}</h4>
            <div class="value">{{ format_currency($totalAssets) }}</div>
        </div>
        <div class="summary-item liabilities">
            <h4>{{ trans('messages.total_liabilities') }}</h4>
            <div class="value">{{ format_currency($totalLiabilities) }}</div>
        </div>
        <div class="summary-item equity">
            <h4>{{ trans('messages.equity') }}</h4>
            <div class="value" style="color: {{ $equity >= 0 ? '#28a745' : '#dc3545' }};">
                {{ format_currency($equity) }}
            </div>
        </div>
    </div>
</body>
</html>

