@php
    $storeName = \App\Models\Setting::get('store_name', 'Gestock Pro');
    $storeLogo = \App\Models\Setting::get('store_logo');
    $currency = currency_symbol();
    $locale = app()->getLocale();
    $isRTL = $locale === 'ar';
    $dir = $isRTL ? 'rtl' : 'ltr';
@endphp
<!DOCTYPE html>
<html lang="{{ $locale }}" dir="{{ $dir }}">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>{{ trans('messages.cash_flow_report') }}</title>
    <link rel="stylesheet" href="{{ asset('lib/fonts/google-fonts.css') }}">
    <style>
        @charset "UTF-8";
        
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: {{ $isRTL ? "'Cairo', 'DejaVu Sans', sans-serif" : "'Cabin', 'DejaVu Sans', sans-serif" }};
            direction: {{ $dir }};
            font-size: 14px;
            color: #333;
            padding: 20px;
            background-color: #fff;
            unicode-bidi: embed;
        }
        
        @if($isRTL)
        * {
            font-family: 'Cairo', 'DejaVu Sans', sans-serif !important;
        }
        @else
        * {
            font-family: 'Cabin', 'DejaVu Sans', sans-serif !important;
        }
        @endif
        
        .header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 30px;
            border-bottom: 2px solid #333;
            padding-bottom: 20px;
        }
        
        .logo-container {
            {{ $isRTL ? 'text-align: right;' : 'text-align: left;' }}
        }
        
        .logo-container img {
            max-height: 80px;
            max-width: 200px;
        }
        
        .report-info {
            {{ $isRTL ? 'text-align: left;' : 'text-align: right;' }}
        }
        
        .report-info h2 {
            margin-bottom: 10px;
            color: #333;
            font-size: 24px;
        }
        
        .report-info p {
            margin: 5px 0;
            font-size: 14px;
            color: #666;
        }
        
        .summary {
            display: flex;
            justify-content: space-around;
            margin-bottom: 30px;
            padding: 20px;
            background-color: #f8f9fa;
            border-radius: 5px;
        }
        
        .summary-item {
            text-align: center;
        }
        
        .summary-item h4 {
            font-size: 14px;
            color: #666;
            margin-bottom: 10px;
        }
        
        .summary-item .value {
            font-size: 20px;
            font-weight: bold;
            color: #333;
        }
        
        .summary-item.success .value {
            color: #28a745;
        }
        
        .summary-item.danger .value {
            color: #dc3545;
        }
        
        .summary-item.primary .value {
            color: #0d6efd;
        }
        
        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 30px;
        }
        
        thead {
            background-color: #343a40;
            color: white;
        }
        
        th, td {
            padding: 12px;
            text-align: {{ $isRTL ? 'right' : 'left' }};
            border: 1px solid #dee2e6;
        }
        
        th {
            font-weight: bold;
            font-size: 14px;
        }
        
        td {
            font-size: 13px;
        }
        
        tbody tr:nth-child(even) {
            background-color: #f8f9fa;
        }
        
        .text-right {
            text-align: {{ $isRTL ? 'left' : 'right' }} !important;
        }
        
        .text-center {
            text-align: center;
        }
        
        .text-success {
            color: #28a745;
        }
        
        .text-danger {
            color: #dc3545;
        }
        
        .print-actions {
            margin-bottom: 20px;
            text-align: center;
        }
        
        .print-actions button {
            padding: 10px 20px;
            font-size: 16px;
            background-color: #0d6efd;
            color: white;
            border: none;
            border-radius: 5px;
            cursor: pointer;
            margin: 0 10px;
        }
        
        .print-actions button:hover {
            background-color: #0b5ed7;
        }
        
        @media print {
            .print-actions {
                display: none;
            }
            
            @page {
                size: landscape;
                margin: 10mm;
            }
            
            body {
                padding: 0;
            }
        }
    </style>
</head>
<body>
    <div class="print-actions">
        <button onclick="window.print()" class="btn btn-primary">
            <i class="bi bi-printer"></i> {{ trans('messages.print') }}
        </button>
        <button onclick="window.close()" class="btn btn-secondary" style="margin-{{ $isRTL ? 'right' : 'left' }}: 10px;">
            <i class="bi bi-x-circle"></i> {{ trans('messages.close') }}
        </button>
    </div>

    <div class="header">
        <div class="logo-container">
            @if($storeLogo)
                <img src="{{ storage_url( $storeLogo) }}" alt="{{ $storeName }}">
            @else
                <h2>{{ $storeName }}</h2>
            @endif
        </div>
        <div class="report-info">
            <h2>{{ trans('messages.cash_flow_report') }}</h2>
            <p>{{ trans('messages.from_date') }}: {{ $dateFrom }}</p>
            <p>{{ trans('messages.to_date') }}: {{ $dateTo }}</p>
            <p>{{ trans('messages.date') }}: {{ now()->format('Y-m-d H:i') }}</p>
        </div>
    </div>

    <div class="summary">
        <div class="summary-item success">
            <h4>{{ trans('messages.cash_inflow') }}</h4>
            <div class="value">{{ format_currency($totalInflow) }}</div>
        </div>
        <div class="summary-item danger">
            <h4>{{ trans('messages.cash_outflow') }}</h4>
            <div class="value">{{ format_currency($totalOutflow) }}</div>
        </div>
        <div class="summary-item primary">
            <h4>{{ trans('messages.net_cash_flow') }}</h4>
            <div class="value">{{ format_currency($netCashFlow) }}</div>
        </div>
    </div>

    <table>
        <thead>
            <tr>
                <th>{{ trans('messages.date') }}</th>
                <th class="text-right">{{ trans('messages.cash_inflow') }}</th>
                <th class="text-right">{{ trans('messages.cash_outflow') }}</th>
                <th class="text-right">{{ trans('messages.net_cash_flow') }}</th>
            </tr>
        </thead>
        <tbody>
            @forelse($cashFlow as $flow)
            <tr>
                <td>{{ \Carbon\Carbon::parse($flow['date'])->format('Y-m-d') }}</td>
                <td class="text-right text-success">{{ format_currency($flow['inflow']) }}</td>
                <td class="text-right text-danger">{{ format_currency($flow['outflow']) }}</td>
                <td class="text-right {{ $flow['net'] >= 0 ? 'text-success' : 'text-danger' }}">
                    {{ format_currency($flow['net']) }}
                </td>
            </tr>
            @empty
            <tr>
                <td colspan="4" class="text-center">{{ trans('messages.no_data') }}</td>
            </tr>
            @endforelse
        </tbody>
        <tfoot>
            <tr style="background-color: #f8f9fa; font-weight: bold;">
                <td>{{ trans('messages.total') }}</td>
                <td class="text-right text-success">{{ format_currency($totalInflow) }}</td>
                <td class="text-right text-danger">{{ format_currency($totalOutflow) }}</td>
                <td class="text-right {{ $netCashFlow >= 0 ? 'text-success' : 'text-danger' }}">
                    {{ format_currency($netCashFlow) }}
                </td>
            </tr>
        </tfoot>
    </table>
</body>
</html>

