@extends('layouts.master')

@section('title', trans('messages.cost_analysis_report'))

@section('content')
<div class="page-header">
    <h2>{{ trans('messages.cost_analysis_report') }}</h2>
    <div>
        <a href="{{ route('reports.cost-analysis.print', request()->all()) }}" target="_blank" class="btn btn-primary">
            <i class="bi bi-printer"></i> {{ trans('messages.print_report') }}
        </a>
        <a href="{{ route('reports.index') }}" class="btn btn-secondary">
            <i class="bi bi-arrow-left"></i> {{ trans('messages.back') }}
        </a>
    </div>
</div>

<div class="card mb-3">
    <div class="card-body">
        <form method="GET" action="{{ route('reports.cost-analysis') }}">
            <div class="row g-3">
                <div class="col-md-3">
                    <label for="date_from" class="form-label">{{ trans('messages.from_date') }}</label>
                    <input type="date" name="date_from" class="form-control" value="{{ $dateFrom }}">
                </div>
                <div class="col-md-3">
                    <label for="date_to" class="form-label">{{ trans('messages.to_date') }}</label>
                    <input type="date" name="date_to" class="form-control" value="{{ $dateTo }}">
                </div>
                <div class="col-md-3">
                    <label for="group_by" class="form-label">{{ trans('messages.group_by') }}</label>
                    <select name="group_by" class="form-select">
                        <option value="product" {{ $groupBy === 'product' ? 'selected' : '' }}>{{ trans('messages.product') }}</option>
                        <option value="category" {{ $groupBy === 'category' ? 'selected' : '' }}>{{ trans('messages.category') }}</option>
                        <option value="supplier" {{ $groupBy === 'supplier' ? 'selected' : '' }}>{{ trans('messages.supplier') }}</option>
                    </select>
                </div>
                <div class="col-md-3">
                    <label class="form-label">&nbsp;</label>
                    <button type="submit" class="btn btn-primary w-100 d-block">{{ trans('messages.filter') }}</button>
                </div>
            </div>
        </form>
    </div>
</div>

<div class="row g-3 mb-4">
    <div class="col-md-3">
        <div class="card text-white bg-primary">
            <div class="card-body">
                <h5>{{ trans('messages.total_revenue') }}</h5>
                <h3>{{ format_currency($totalRevenue) }}</h3>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card text-white bg-danger">
            <div class="card-body">
                <h5>{{ trans('messages.total_cost') }}</h5>
                <h3>{{ format_currency($totalCost) }}</h3>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card text-white {{ $totalProfit >= 0 ? 'bg-success' : 'bg-warning' }}">
            <div class="card-body">
                <h5>{{ trans('messages.total_profit') }}</h5>
                <h3>{{ format_currency($totalProfit) }}</h3>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card text-white bg-info">
            <div class="card-body">
                <h5>{{ trans('messages.profit_margin') }}</h5>
                <h3>{{ number_format($profitMargin, 2) }}%</h3>
            </div>
        </div>
    </div>
</div>

<div class="card">
    <div class="card-header">
        <h5 class="mb-0">
            {{ trans('messages.cost_breakdown') }} - 
            @if($groupBy === 'product')
                {{ trans('messages.by_product') }}
            @elseif($groupBy === 'category')
                {{ trans('messages.by_category') }}
            @else
                {{ trans('messages.by_supplier') }}
            @endif
        </h5>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-striped">
                <thead>
                    <tr>
                        @if($groupBy === 'product')
                            <th>{{ trans('messages.product') }}</th>
                            <th class="text-end">{{ trans('messages.quantity') }}</th>
                            <th class="text-end">{{ trans('messages.average_cost') }}</th>
                        @elseif($groupBy === 'category')
                            <th>{{ trans('messages.category') }}</th>
                            <th class="text-end">{{ trans('messages.items_count') }}</th>
                            <th class="text-end">{{ trans('messages.quantity') }}</th>
                        @else
                            <th>{{ trans('messages.supplier') }}</th>
                            <th class="text-end">{{ trans('messages.invoice_count') }}</th>
                            <th class="text-end">{{ trans('messages.quantity') }}</th>
                        @endif
                        <th class="text-end">{{ trans('messages.total_cost') }}</th>
                        <th class="text-end">{{ trans('messages.percentage') }}</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($costBreakdownPaginator as $item)
                    <tr>
                        @if($groupBy === 'product')
                            <td>
                                <strong>{{ $item['product']->name ?? $item['product']->name_ar ?? trans('messages.unknown') }}</strong>
                                @if($item['product']->category)
                                    <br><small class="text-muted">{{ $item['product']->category->name }}</small>
                                @endif
                            </td>
                            <td class="text-end">{{ number_format($item['quantity']) }}</td>
                            <td class="text-end">{{ format_currency($item['average_cost']) }}</td>
                        @elseif($groupBy === 'category')
                            <td><strong>{{ $item['category'] }}</strong></td>
                            <td class="text-end">{{ number_format($item['item_count']) }}</td>
                            <td class="text-end">{{ number_format($item['quantity']) }}</td>
                        @else
                            <td><strong>{{ $item['supplier'] }}</strong></td>
                            <td class="text-end">{{ number_format($item['invoice_count']) }}</td>
                            <td class="text-end">{{ number_format($item['quantity']) }}</td>
                        @endif
                        <td class="text-end"><strong>{{ format_currency($item['total_cost']) }}</strong></td>
                        <td class="text-end">
                            {{ $totalCost > 0 ? number_format(($item['total_cost'] / $totalCost) * 100, 2) : 0 }}%
                        </td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="5" class="text-center">{{ trans('messages.no_data') }}</td>
                    </tr>
                    @endforelse
                </tbody>
                <tfoot>
                    <tr class="table-primary">
                        <th colspan="{{ $groupBy === 'product' ? '3' : '3' }}">{{ trans('messages.total') }}</th>
                        <th class="text-end">{{ format_currency($totalCost) }}</th>
                        <th class="text-end">100%</th>
                    </tr>
                </tfoot>
            </table>
        </div>
        
        <div class="mt-3">
            {{ $costBreakdownPaginator->links() }}
        </div>
    </div>
</div>

@include('reports.partials.print-styles', ['reportTitle' => trans('messages.cost_analysis_report')])
@endsection

