@push('styles')
<link rel="stylesheet" href="{{ asset('css/print-reports.css') }}">
<style>
    .report-header {
        text-align: center;
        margin-bottom: 30px;
        padding-bottom: 15px;
        border-bottom: 2px solid #dee2e6;
    }
    .report-header h2 {
        margin: 0;
        font-size: 28px;
        font-weight: bold;
    }
    .report-meta {
        margin-top: 10px;
        color: #6c757d;
        font-size: 14px;
    }
</style>
@endpush

@push('scripts')
<script>
    window.addEventListener('beforeprint', function() {
        const reportTitle = document.querySelector('.page-header h2')?.textContent || '{{ $reportTitle ?? trans('messages.report') }}';
        const storeName = '{{ \App\Models\Setting::get("store_name", "Gestock Pro") }}';
        const printDate = new Date().toLocaleDateString('{{ app()->getLocale() }}', {
            year: 'numeric',
            month: 'long',
            day: 'numeric'
        });
        
        // Get filter dates if available
        const dateFromInput = document.querySelector('input[name="date_from"]');
        const dateToInput = document.querySelector('input[name="date_to"]');
        const dateFrom = dateFromInput ? dateFromInput.value : '';
        const dateTo = dateToInput ? dateToInput.value : '';
        
        let reportHeader = document.querySelector('.print-report-header');
        if (!reportHeader) {
            reportHeader = document.createElement('div');
            reportHeader.className = 'report-header print-report-header';
            let dateRange = '';
            if (dateFrom && dateTo) {
                dateRange = `${dateFrom} - ${dateTo}`;
            } else if (dateFrom) {
                dateRange = `{{ trans('messages.from_date') }}: ${dateFrom}`;
            } else if (dateTo) {
                dateRange = `{{ trans('messages.to_date') }}: ${dateTo}`;
            }
            
            reportHeader.innerHTML = `
                <h2 style="font-size: 24px; font-weight: bold; margin-bottom: 10px;">${storeName}</h2>
                <h3 style="font-size: 20px; font-weight: 600; margin-bottom: 15px;">${reportTitle}</h3>
                <div class="report-meta" style="font-size: 12px; color: #666;">
                    ${dateRange ? `<div style="margin-bottom: 5px;"><strong>{{ trans('messages.period') }}:</strong> ${dateRange}</div>` : ''}
                    <div><strong>{{ trans('messages.generated_on') }}:</strong> ${printDate}</div>
                </div>
            `;
            const container = document.querySelector('.container-fluid');
            if (container) {
                container.insertBefore(reportHeader, container.firstChild);
            }
        }
    });
    
    window.addEventListener('afterprint', function() {
        const reportHeader = document.querySelector('.print-report-header');
        if (reportHeader) {
            reportHeader.remove();
        }
    });
</script>
@endpush

