@extends('layouts.master')

@section('title', trans('messages.product_movement_report'))

@section('content')
<div class="page-header">
    <h2>{{ trans('messages.product_movement_report') }}</h2>
    <div>
        <button onclick="window.print()" class="btn btn-primary">
            <i class="bi bi-printer"></i> {{ trans('messages.print_report') }}
        </button>
        <a href="{{ route('reports.index') }}" class="btn btn-secondary">
            <i class="bi bi-arrow-left"></i> {{ trans('messages.back') }}
        </a>
    </div>
</div>

<div class="card mb-3">
    <div class="card-body">
        <form method="GET" action="{{ route('reports.product-movement') }}">
            <div class="row g-3">
                <div class="col-md-3">
                    <label for="product_id" class="form-label">{{ trans('messages.product') }}</label>
                    <select name="product_id" class="form-select">
                        <option value="">{{ trans('messages.all_products') }}</option>
                        @foreach($products as $product)
                        <option value="{{ $product->id }}" {{ $productId == $product->id ? 'selected' : '' }}>
                            {{ $product->name }}
                        </option>
                        @endforeach
                    </select>
                </div>
                <div class="col-md-2">
                    <label for="type" class="form-label">{{ trans('messages.movement_type') }}</label>
                    <select name="type" class="form-select">
                        <option value="all" {{ $type == 'all' ? 'selected' : '' }}>{{ trans('messages.all_types') }}</option>
                        <option value="in" {{ $type == 'in' ? 'selected' : '' }}>{{ trans('messages.in') }}</option>
                        <option value="out" {{ $type == 'out' ? 'selected' : '' }}>{{ trans('messages.out') }}</option>
                    </select>
                </div>
                <div class="col-md-2">
                    <label for="date_from" class="form-label">{{ trans('messages.from_date') }}</label>
                    <input type="date" name="date_from" class="form-control" value="{{ $dateFrom }}">
                </div>
                <div class="col-md-2">
                    <label for="date_to" class="form-label">{{ trans('messages.to_date') }}</label>
                    <input type="date" name="date_to" class="form-control" value="{{ $dateTo }}">
                </div>
                <div class="col-md-3">
                    <label class="form-label">&nbsp;</label>
                    <button type="submit" class="btn btn-primary w-100 d-block">{{ trans('messages.filter') }}</button>
                </div>
            </div>
        </form>
    </div>
</div>

<div class="card">
    <div class="card-header">
        <h5 class="mb-0">{{ trans('messages.product_movement_report') }}</h5>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-striped">
                <thead>
                    <tr>
                        <th>{{ trans('messages.date') }}</th>
                        <th>{{ trans('messages.product') }}</th>
                        <th>{{ trans('messages.movement_type') }}</th>
                        <th class="text-end">{{ trans('messages.quantity') }}</th>
                        <th class="text-end">{{ trans('messages.quantity_before') }}</th>
                        <th class="text-end">{{ trans('messages.quantity_after') }}</th>
                        <th>{{ trans('messages.user') }}</th>
                        <th>{{ trans('messages.notes') }}</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($movements as $movement)
                    <tr>
                        <td>{{ $movement->created_at->format('Y-m-d H:i') }}</td>
                        <td>
                            <a href="{{ route('products.show', $movement->product_id) }}">
                                {{ $movement->product->name }}
                            </a>
                        </td>
                        <td>
                            <span class="badge {{ $movement->type == 'IN' ? 'bg-success' : 'bg-danger' }}">
                                {{ $movement->type == 'IN' ? trans('messages.in') : trans('messages.out') }}
                            </span>
                        </td>
                        <td class="text-end">{{ $movement->quantity }}</td>
                        <td class="text-end">{{ $movement->quantity_before }}</td>
                        <td class="text-end">{{ $movement->quantity_after }}</td>
                        <td>{{ $movement->user->name ?? '-' }}</td>
                        <td>{{ $movement->notes ?? '-' }}</td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="8" class="text-center">{{ trans('messages.no_data') }}</td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
        <div class="mt-3">
            {{ $movements->links() }}
        </div>
    </div>
</div>

@include('reports.partials.print-styles', ['reportTitle' => trans('messages.product_movement_report')])
@endsection

