@php
    $storeName = \App\Models\Setting::get('store_name', 'Gestock Pro');
    $storeLogo = \App\Models\Setting::get('store_logo');
    $currency = currency_symbol();
    $locale = app()->getLocale();
    $isRTL = $locale === 'ar';
    $dir = $isRTL ? 'rtl' : 'ltr';
@endphp
<!DOCTYPE html>
<html lang="{{ $locale }}" dir="{{ $dir }}">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>{{ trans('messages.profit_loss_report') }}</title>
    <link rel="stylesheet" href="{{ asset('lib/fonts/google-fonts.css') }}">
    <style>
        @charset "UTF-8";
        
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: {{ $isRTL ? "'Cairo', 'DejaVu Sans', sans-serif" : "'Cabin', 'DejaVu Sans', sans-serif" }};
            direction: {{ $dir }};
            font-size: 14px;
            color: #333;
            padding: 20px;
            background-color: #fff;
            unicode-bidi: embed;
        }
        
        @if($isRTL)
        * {
            font-family: 'Cairo', 'DejaVu Sans', sans-serif !important;
        }
        @else
        * {
            font-family: 'Cabin', 'DejaVu Sans', sans-serif !important;
        }
        @endif
        
        .header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 30px;
            border-bottom: 2px solid #333;
            padding-bottom: 20px;
        }
        
        .logo-container {
            {{ $isRTL ? 'text-align: right;' : 'text-align: left;' }}
        }
        
        .logo-container img {
            max-height: 80px;
            max-width: 200px;
        }
        
        .report-info {
            {{ $isRTL ? 'text-align: left;' : 'text-align: right;' }}
        }
        
        .report-info h2 {
            margin-bottom: 10px;
            color: #333;
            font-size: 24px;
        }
        
        .report-info p {
            margin: 5px 0;
            font-size: 14px;
            color: #666;
        }
        
        .summary {
            display: grid;
            grid-template-columns: repeat(2, 1fr);
            gap: 20px;
            margin-bottom: 30px;
        }
        
        .summary-card {
            padding: 20px;
            border-radius: 5px;
            border: 2px solid #dee2e6;
        }
        
        .summary-card.primary {
            border-color: #0d6efd;
            background-color: #e7f1ff;
        }
        
        .summary-card.danger {
            border-color: #dc3545;
            background-color: #f8d7da;
        }
        
        .summary-card.success {
            border-color: #28a745;
            background-color: #d4edda;
        }
        
        .summary-card.warning {
            border-color: #ffc107;
            background-color: #fff3cd;
        }
        
        .summary-card h4 {
            font-size: 14px;
            color: #666;
            margin-bottom: 10px;
        }
        
        .summary-card .value {
            font-size: 24px;
            font-weight: bold;
            color: #333;
        }
        
        .summary-card .margin {
            font-size: 12px;
            color: #666;
            margin-top: 5px;
        }
        
        .net-profit {
            grid-column: 1 / -1;
            padding: 30px;
            text-align: center;
            border: 3px solid {{ $netProfit >= 0 ? '#28a745' : '#dc3545' }};
            background-color: {{ $netProfit >= 0 ? '#d4edda' : '#f8d7da' }};
        }
        
        .net-profit h3 {
            font-size: 16px;
            color: #666;
            margin-bottom: 10px;
        }
        
        .net-profit .value {
            font-size: 36px;
            font-weight: bold;
            color: {{ $netProfit >= 0 ? '#28a745' : '#dc3545' }};
        }
        
        .print-actions {
            margin-bottom: 20px;
            text-align: center;
        }
        
        .print-actions button {
            padding: 10px 20px;
            font-size: 16px;
            background-color: #0d6efd;
            color: white;
            border: none;
            border-radius: 5px;
            cursor: pointer;
            margin: 0 10px;
        }
        
        .print-actions button:hover {
            background-color: #0b5ed7;
        }
        
        @media print {
            .print-actions {
                display: none;
            }
            
            @page {
                size: A4;
                margin: 10mm;
            }
            
            body {
                padding: 0;
            }
        }
    </style>
</head>
<body>
    <div class="print-actions">
        <button onclick="window.print()" class="btn btn-primary">
            <i class="bi bi-printer"></i> {{ trans('messages.print') }}
        </button>
        <button onclick="window.close()" class="btn btn-secondary" style="margin-{{ $isRTL ? 'right' : 'left' }}: 10px;">
            <i class="bi bi-x-circle"></i> {{ trans('messages.close') }}
        </button>
    </div>

    <div class="header">
        <div class="logo-container">
            @if($storeLogo)
                <img src="{{ storage_url( $storeLogo) }}" alt="{{ $storeName }}">
            @else
                <h2>{{ $storeName }}</h2>
            @endif
        </div>
        <div class="report-info">
            <h2>{{ trans('messages.profit_loss_report') }}</h2>
            <p>{{ trans('messages.from_date') }}: {{ $dateFrom }}</p>
            <p>{{ trans('messages.to_date') }}: {{ $dateTo }}</p>
            <p>{{ trans('messages.date') }}: {{ now()->format('Y-m-d H:i') }}</p>
        </div>
    </div>

    <div class="summary">
        <div class="summary-card primary">
            <h4>{{ trans('messages.revenue') }}</h4>
            <div class="value">{{ format_currency($revenue) }}</div>
        </div>
        <div class="summary-card danger">
            <h4>{{ trans('messages.cost_of_goods_sold') }}</h4>
            <div class="value">{{ format_currency($cogs) }}</div>
        </div>
        <div class="summary-card success">
            <h4>{{ trans('messages.gross_profit') }}</h4>
            <div class="value">{{ format_currency($grossProfit) }}</div>
            <div class="margin">{{ number_format($grossProfitMargin, 2) }}% {{ trans('messages.gross_profit_margin') }}</div>
        </div>
        <div class="summary-card warning">
            <h4>{{ trans('messages.operating_expenses') }}</h4>
            <div class="value">{{ format_currency($operatingExpenses) }}</div>
        </div>
        <div class="net-profit">
            <h3>{{ trans('messages.net_profit') }}</h3>
            <div class="value">{{ format_currency($netProfit) }}</div>
            <div class="margin">{{ number_format($netProfitMargin, 2) }}% {{ trans('messages.net_profit_margin') }}</div>
        </div>
    </div>
</body>
</html>

