@extends('layouts.master')

@section('title', trans('messages.profit_report'))

@section('content')
<div class="page-header">
    <h2>{{ trans('messages.profit_report') }}</h2>
    <div>
        <button onclick="window.print()" class="btn btn-primary">
            <i class="bi bi-printer"></i> {{ trans('messages.print_report') }}
        </button>
        <a href="{{ route('reports.index') }}" class="btn btn-secondary">
            <i class="bi bi-arrow-left"></i> {{ trans('messages.back') }}
        </a>
    </div>
</div>

<div class="card mb-3">
    <div class="card-body">
        <form method="GET" action="{{ route('reports.profit') }}">
            <div class="row g-3">
                <div class="col-md-4">
                    <label for="date_from" class="form-label">{{ trans('messages.from_date') }}</label>
                    <input type="date" name="date_from" class="form-control" value="{{ request('date_from') }}">
                </div>
                <div class="col-md-4">
                    <label for="date_to" class="form-label">{{ trans('messages.to_date') }}</label>
                    <input type="date" name="date_to" class="form-control" value="{{ request('date_to') }}">
                </div>
                <div class="col-md-4">
                    <label class="form-label">&nbsp;</label>
                    <button type="submit" class="btn btn-primary w-100 d-block">{{ trans('messages.filter') }}</button>
                </div>
            </div>
        </form>
    </div>
</div>

<div class="row g-3 mb-4">
    <div class="col-md-3">
        <div class="card text-white bg-primary">
            <div class="card-body">
                <h5>{{ trans('messages.total_revenue') }}</h5>
                <h3>{{ format_currency($totalRevenue) }}</h3>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card text-white bg-danger">
            <div class="card-body">
                <h5>{{ trans('messages.total_cost') }}</h5>
                <h3>{{ format_currency($totalCost) }}</h3>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card text-white bg-success">
            <div class="card-body">
                <h5>{{ trans('messages.total_profit') }}</h5>
                <h3>{{ format_currency($totalProfit) }}</h3>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card text-white bg-info">
            <div class="card-body">
                <h5>{{ trans('messages.profit_margin') }}</h5>
                <h3>{{ number_format($profitMargin, 2) }}%</h3>
            </div>
        </div>
    </div>
</div>

<div class="card">
    <div class="card-body">
        <div class="table-responsive">
            <table class="table">
                <thead>
                    <tr>
                        <th>{{ trans('messages.product') }}</th>
                        <th class="text-end">{{ trans('messages.quantity_sold') }}</th>
                        <th class="text-end">{{ trans('messages.total_revenue') }}</th>
                        <th class="text-end">{{ trans('messages.total_cost') }}</th>
                        <th class="text-end">{{ trans('messages.profit') }}</th>
                        <th class="text-end">{{ trans('messages.profit_margin') }} %</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($productProfitsPaginator as $profit)
                    <tr>
                        <td>
                            <a href="{{ route('products.show', $profit['product']->id) }}">
                                {{ $profit['product']->name }}
                            </a>
                        </td>
                        <td class="text-end">{{ $profit['quantity_sold'] }}</td>
                        <td class="text-end">{{ format_currency($profit['revenue']) }}</td>
                        <td class="text-end">{{ format_currency($profit['cost']) }}</td>
                        <td class="text-end"><strong>{{ format_currency($profit['profit']) }}</strong></td>
                        <td class="text-end">{{ number_format($profit['margin'], 2) }}%</td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="6" class="text-center">{{ trans('messages.no_data') }}</td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
        @if(method_exists($productProfitsPaginator, 'links'))
            <div class="card-footer">
                {{ $productProfitsPaginator->links() }}
            </div>
        @endif
    </div>
</div>

@include('reports.partials.print-styles', ['reportTitle' => trans('messages.profit_report')])
@endsection

