@extends('layouts.master')

@section('title', trans('messages.periodic_sales_report'))

@section('content')
<div class="page-header">
    <h2>{{ trans('messages.periodic_sales_report') }}</h2>
    <div>
        <button onclick="window.print()" class="btn btn-primary">
            <i class="bi bi-printer"></i> {{ trans('messages.print_report') }}
        </button>
        <a href="{{ route('reports.index') }}" class="btn btn-secondary">
            <i class="bi bi-arrow-left"></i> {{ trans('messages.back') }}
        </a>
    </div>
</div>

<div class="card mb-3">
    <div class="card-body">
        <form method="GET" action="{{ route('reports.sales.periodic') }}">
            <div class="row g-3">
                <div class="col-md-3">
                    <label for="period" class="form-label">{{ trans('messages.period') }}</label>
                    <select name="period" class="form-select">
                        <option value="daily" {{ $period == 'daily' ? 'selected' : '' }}>{{ trans('messages.daily') }}</option>
                        <option value="weekly" {{ $period == 'weekly' ? 'selected' : '' }}>{{ trans('messages.weekly') }}</option>
                        <option value="monthly" {{ $period == 'monthly' ? 'selected' : '' }}>{{ trans('messages.monthly') }}</option>
                        <option value="yearly" {{ $period == 'yearly' ? 'selected' : '' }}>{{ trans('messages.yearly') }}</option>
                    </select>
                </div>
                <div class="col-md-3">
                    <label for="date_from" class="form-label">{{ trans('messages.from_date') }}</label>
                    <input type="date" name="date_from" class="form-control" value="{{ $dateFrom }}">
                </div>
                <div class="col-md-3">
                    <label for="date_to" class="form-label">{{ trans('messages.to_date') }}</label>
                    <input type="date" name="date_to" class="form-control" value="{{ $dateTo }}">
                </div>
                <div class="col-md-3">
                    <label class="form-label">&nbsp;</label>
                    <button type="submit" class="btn btn-primary w-100 d-block">{{ trans('messages.filter') }}</button>
                </div>
            </div>
        </form>
    </div>
</div>

<div class="row g-3 mb-4">
    <div class="col-md-4">
        <div class="card text-white bg-primary">
            <div class="card-body">
                <h5>{{ trans('messages.total_sales') }}</h5>
                <h3>{{ format_currency($totalSales) }}</h3>
            </div>
        </div>
    </div>
    <div class="col-md-4">
        <div class="card text-white bg-success">
            <div class="card-body">
                <h5>{{ trans('messages.total_profit') }}</h5>
                <h3>{{ format_currency($totalProfit) }}</h3>
            </div>
        </div>
    </div>
    <div class="col-md-4">
        <div class="card text-white bg-info">
            <div class="card-body">
                <h5>{{ trans('messages.total_invoices') }}</h5>
                <h3>{{ $totalCount }}</h3>
            </div>
        </div>
    </div>
</div>

<div class="card">
    <div class="card-header">
        <h5 class="mb-0">{{ trans('messages.periodic_sales_report') }}</h5>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-striped">
                <thead>
                    <tr>
                        <th>{{ trans('messages.period') }}</th>
                        <th class="text-end">{{ trans('messages.invoice_count') }}</th>
                        <th class="text-end">{{ trans('messages.total_sales') }}</th>
                        <th class="text-end">{{ trans('messages.profit') }}</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($periodicSales as $sale)
                    <tr>
                        <td>{{ $sale['period'] }}</td>
                        <td class="text-end">{{ $sale['count'] }}</td>
                        <td class="text-end">{{ format_currency($sale['total']) }}</td>
                        <td class="text-end {{ $sale['profit'] >= 0 ? 'text-success' : 'text-danger' }}">
                            {{ format_currency($sale['profit']) }}
                        </td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="4" class="text-center">{{ trans('messages.no_data') }}</td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>
</div>

@include('reports.partials.print-styles', ['reportTitle' => trans('messages.periodic_sales_report')])
@endsection

