@php
    $storeName = \App\Models\Setting::get('store_name', 'Gestock Pro');
    $storeLogo = \App\Models\Setting::get('store_logo');
    $currency = currency_symbol();
    $locale = app()->getLocale();
    $isRTL = $locale === 'ar';
    $dir = $isRTL ? 'rtl' : 'ltr';
    $dateFrom = $request->filled('date_from') ? $request->date_from : now()->startOfMonth()->format('Y-m-d');
    $dateTo = $request->filled('date_to') ? $request->date_to : now()->endOfMonth()->format('Y-m-d');
    $statusFilter = $request->filled('status') ? $request->status : trans('messages.all_status');
@endphp
<!DOCTYPE html>
<html lang="{{ $locale }}" dir="{{ $dir }}">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
    <title>{{ trans('messages.sales_report_title') }}</title>
    <style>
        @charset "UTF-8";
        
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: {{ $isRTL ? "'Cairo', DejaVu Sans, sans-serif" : "DejaVu Sans, 'Cabin', sans-serif" }};
            direction: {{ $dir }};
            font-size: 10px;
            color: #333;
            padding: 15px;
            unicode-bidi: embed;
        }
        
        @if($isRTL)
        * {
            font-family: 'Cairo', DejaVu Sans, sans-serif !important;
        }
        @else
        * {
            font-family: DejaVu Sans, 'Cabin', sans-serif !important;
        }
        @endif
        
        .header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 20px;
            border-bottom: 2px solid #333;
            padding-bottom: 15px;
        }
        
        .logo-container {
            {{ $isRTL ? 'text-align: right;' : 'text-align: left;' }}
        }
        
        .logo-container img {
            max-height: 60px;
            max-width: 150px;
        }
        
        .report-info {
            {{ $isRTL ? 'text-align: left;' : 'text-align: right;' }}
        }
        
        .report-info h2 {
            margin-bottom: 5px;
            color: #333;
            font-size: 18px;
        }
        
        .report-info p {
            margin: 3px 0;
            font-size: 10px;
            color: #666;
        }
        
        .summary {
            display: flex;
            justify-content: space-around;
            margin-bottom: 20px;
            padding: 15px;
            background-color: #f8f9fa;
            border-radius: 5px;
        }
        
        .summary-item {
            text-align: center;
        }
        
        .summary-item h4 {
            font-size: 11px;
            color: #666;
            margin-bottom: 5px;
        }
        
        .summary-item .value {
            font-size: 16px;
            font-weight: bold;
            color: #333;
        }
        
        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
        }
        
        thead {
            background-color: #343a40;
            color: white;
        }
        
        th, td {
            padding: 8px;
            text-align: {{ $isRTL ? 'right' : 'left' }};
            border: 1px solid #dee2e6;
        }
        
        th {
            font-weight: bold;
            font-size: 10px;
        }
        
        td {
            font-size: 9px;
        }
        
        tbody tr:nth-child(even) {
            background-color: #f8f9fa;
        }
        
        tbody tr.returned {
            background-color: #f8d7da;
        }
        
        .text-right {
            text-align: {{ $isRTL ? 'left' : 'right' }};
        }
        
        .text-center {
            text-align: center;
        }
        
        .badge {
            padding: 3px 8px;
            border-radius: 3px;
            font-size: 8px;
            font-weight: bold;
        }
        
        .badge-success {
            background-color: #28a745;
            color: white;
        }
        
        .badge-warning {
            background-color: #ffc107;
            color: #333;
        }
        
        .badge-danger {
            background-color: #dc3545;
            color: white;
        }
        
        .badge-info {
            background-color: #17a2b8;
            color: white;
        }
        
        .badge-secondary {
            background-color: #6c757d;
            color: white;
        }
        
        .footer {
            margin-top: 30px;
            padding-top: 15px;
            border-top: 1px solid #dee2e6;
            text-align: center;
            font-size: 9px;
            color: #666;
        }
    </style>
</head>
<body>
    <div class="header">
        <div class="logo-container">
            @if($storeLogo)
                <img src="{{ \Storage::disk('public')->path($storeLogo) }}" alt="{{ $storeName }}">
            @else
                <h2>{{ $storeName }}</h2>
            @endif
        </div>
        <div class="report-info">
            <h2>{{ trans('messages.sales_report_title') }}</h2>
            <p>{{ trans('messages.from_date') }}: {{ $dateFrom }}</p>
            <p>{{ trans('messages.to_date') }}: {{ $dateTo }}</p>
            <p>{{ trans('messages.status') }}: {{ is_string($statusFilter) ? $statusFilter : trans('messages.' . $statusFilter) }}</p>
            <p>{{ trans('messages.date') }}: {{ now()->format('Y-m-d H:i') }}</p>
        </div>
    </div>

    <div class="summary">
        <div class="summary-item">
            <h4>{{ trans('messages.total_sales') }}</h4>
            <div class="value">{{ $currency }} {{ number_format($totalSales, 2) }}</div>
        </div>
        <div class="summary-item">
            <h4>{{ trans('messages.total') }} {{ trans('messages.paid') }}</h4>
            <div class="value">{{ $currency }} {{ number_format($totalPaid, 2) }}</div>
        </div>
        <div class="summary-item">
            <h4>{{ trans('messages.total') }} {{ trans('messages.due') }}</h4>
            <div class="value">{{ $currency }} {{ number_format($totalDue, 2) }}</div>
        </div>
        <div class="summary-item">
            <h4>{{ trans('messages.total_profit') }}</h4>
            <div class="value">{{ $currency }} {{ number_format($totalProfit, 2) }}</div>
        </div>
    </div>

    <table>
        <thead>
            <tr>
                <th>{{ trans('messages.invoice_number') }}</th>
                <th>{{ trans('messages.date') }}</th>
                <th>{{ trans('messages.customer') }}</th>
                <th class="text-right">{{ trans('messages.total') }}</th>
                <th class="text-right">{{ trans('messages.paid') }}</th>
                <th class="text-right">{{ trans('messages.due') }}</th>
                <th class="text-right">{{ trans('messages.profit') }}</th>
                <th>{{ trans('messages.status') }}</th>
            </tr>
        </thead>
        <tbody>
            @forelse($invoices as $invoice)
            <tr class="{{ $invoice->status === 'returned' ? 'returned' : '' }}">
                <td>{{ $invoice->invoice_number }}</td>
                <td>{{ $invoice->created_at->format('Y-m-d') }}</td>
                <td>{{ $invoice->customer?->name ?? $invoice->customer_name }}</td>
                <td class="text-right">{{ $currency }} {{ number_format($invoice->total, 2) }}</td>
                <td class="text-right">{{ $currency }} {{ number_format($invoice->paid_amount, 2) }}</td>
                <td class="text-right">{{ $currency }} {{ number_format($invoice->due_amount, 2) }}</td>
                <td class="text-right">{{ $currency }} {{ number_format($invoice->profit, 2) }}</td>
                <td>
                    @php
                        $badgeClass = match($invoice->status) {
                            'paid' => 'success',
                            'partially_paid' => 'warning',
                            'draft' => 'secondary',
                            'returned' => 'danger',
                            default => 'info'
                        };
                    @endphp
                    <span class="badge badge-{{ $badgeClass }}">{{ trans('messages.' . $invoice->status) }}</span>
                </td>
            </tr>
            @empty
            <tr>
                <td colspan="8" class="text-center">{{ trans('messages.no_invoices_found') }}</td>
            </tr>
            @endforelse
        </tbody>
    </table>

    <div class="footer">
        <p>{{ $storeName }} - {{ trans('messages.sales_report_title') }} - {{ now()->format('Y-m-d H:i:s') }}</p>
    </div>
</body>
</html>

