@extends('layouts.master')

@section('title', trans('messages.stock_report'))

@section('content')
<div class="page-header">
    <h2>{{ trans('messages.stock_report') }}</h2>
    <div>
        <button onclick="window.print()" class="btn btn-primary">
            <i class="bi bi-printer"></i> {{ trans('messages.print_report') }}
        </button>
        <a href="{{ route('reports.index') }}" class="btn btn-secondary">
            <i class="bi bi-arrow-left"></i> {{ trans('messages.back') }}
        </a>
    </div>
</div>

<div class="row g-3 mb-4">
    <div class="col-md-6">
        <div class="card text-white bg-primary">
            <div class="card-body">
                <h5>{{ trans('messages.total_stock_value') }}</h5>
                <h3>{{ format_currency($totalValue) }}</h3>
            </div>
        </div>
    </div>
    <div class="col-md-6">
        <div class="card text-white bg-danger">
            <div class="card-body">
                <h5>{{ trans('messages.low_stock_items') }}</h5>
                <h3>{{ $lowStockCount }}</h3>
            </div>
        </div>
    </div>
</div>

<div class="card">
    <div class="card-body">
        <div class="table-responsive">
            <table class="table">
                <thead>
                    <tr>
                        <th>{{ trans('messages.product') }}</th>
                        <th>{{ trans('messages.category') }}</th>
                        <th class="text-end">{{ trans('messages.stock_quantity') }}</th>
                        <th class="text-end">{{ trans('messages.reorder_level') }}</th>
                        <th class="text-end">{{ trans('messages.purchase_price') }}</th>
                        <th class="text-end">{{ trans('messages.stock_value') }}</th>
                        <th>{{ trans('messages.status') }}</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($products as $product)
                    <tr>
                        <td>
                            <a href="{{ route('products.show', $product->id) }}">
                                {{ $product->name }}
                            </a>
                        </td>
                        <td>{{ $product->category?->name ?? '-' }}</td>
                        <td class="text-end">
                            {{ $product->stock_quantity }}
                            @if($product->isLowStock())
                                <span class="badge bg-danger ms-2">{{ trans('messages.low_stock') }}</span>
                            @endif
                        </td>
                        <td class="text-end">{{ $product->reorder_level }}</td>
                        <td class="text-end">{{ format_currency($product->purchase_price) }}</td>
                        <td class="text-end">{{ format_currency($product->stock_value) }}</td>
                        <td>
                            @if($product->isLowStock())
                                <span class="badge bg-danger">{{ trans('messages.low_stock') }}</span>
                            @else
                                <span class="badge bg-success">{{ trans('messages.in_stock') }}</span>
                            @endif
                        </td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="7" class="text-center">{{ trans('messages.no_data') }}</td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
        @if(method_exists($products, 'links'))
            <div class="card-footer">
                {{ $products->links() }}
            </div>
        @endif
    </div>
</div>

@include('reports.partials.print-styles', ['reportTitle' => trans('messages.stock_report')])
@endsection

