@extends('layouts.master')

@section('title', trans('messages.supplier_reports'))

@section('content')
<div class="page-header">
    <h2>{{ $type == 'best' ? trans('messages.best_suppliers') : trans('messages.worst_suppliers') }}</h2>
    <div>
        <button onclick="window.print()" class="btn btn-primary">
            <i class="bi bi-printer"></i> {{ trans('messages.print_report') }}
        </button>
        <a href="{{ route('reports.suppliers', array_merge(request()->all(), ['type' => $type == 'best' ? 'worst' : 'best'])) }}" class="btn btn-info">
            <i class="bi bi-arrow-repeat"></i> {{ $type == 'best' ? trans('messages.worst_suppliers') : trans('messages.best_suppliers') }}
        </a>
        <a href="{{ route('reports.index') }}" class="btn btn-secondary">
            <i class="bi bi-arrow-left"></i> {{ trans('messages.back') }}
        </a>
    </div>
</div>

<div class="card mb-3">
    <div class="card-body">
        <form method="GET" action="{{ route('reports.suppliers') }}">
            <input type="hidden" name="type" value="{{ $type }}">
            <div class="row g-3">
                <div class="col-md-4">
                    <label for="date_from" class="form-label">{{ trans('messages.from_date') }}</label>
                    <input type="date" name="date_from" class="form-control" value="{{ $dateFrom }}">
                </div>
                <div class="col-md-4">
                    <label for="date_to" class="form-label">{{ trans('messages.to_date') }}</label>
                    <input type="date" name="date_to" class="form-control" value="{{ $dateTo }}">
                </div>
                <div class="col-md-4">
                    <label class="form-label">&nbsp;</label>
                    <button type="submit" class="btn btn-primary w-100 d-block">{{ trans('messages.filter') }}</button>
                </div>
            </div>
        </form>
    </div>
</div>

<div class="card">
    <div class="card-header">
        <h5 class="mb-0">{{ $type == 'best' ? trans('messages.best_suppliers') : trans('messages.worst_suppliers') }}</h5>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-striped">
                <thead>
                    <tr>
                        <th>{{ trans('messages.supplier') }}</th>
                        <th class="text-end">{{ trans('messages.invoice_count') }}</th>
                        <th class="text-end">{{ trans('messages.total_amount') }}</th>
                        <th class="text-end">{{ trans('messages.amount_paid') }}</th>
                        <th class="text-end">{{ trans('messages.amount_remaining') }}</th>
                        <th class="text-end">{{ trans('messages.items_count') }}</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($supplierStatsPaginator as $stat)
                    <tr>
                        <td>
                            <a href="{{ route('suppliers.show', $stat['supplier']->id) }}">
                                {{ $stat['supplier']->name }}
                            </a>
                        </td>
                        <td class="text-end">{{ $stat['invoice_count'] }}</td>
                        <td class="text-end">{{ format_currency($stat['total_amount']) }}</td>
                        <td class="text-end">{{ format_currency($stat['amount_paid']) }}</td>
                        <td class="text-end">{{ format_currency($stat['amount_remaining']) }}</td>
                        <td class="text-end">{{ $stat['items_count'] }}</td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="6" class="text-center">{{ trans('messages.no_data') }}</td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
        <div class="mt-3">
            {{ $supplierStatsPaginator->links() }}
        </div>
    </div>
</div>

@include('reports.partials.print-styles', ['reportTitle' => ($type == 'best' ? trans('messages.best_suppliers') : trans('messages.worst_suppliers'))])
@endsection

