@extends('layouts.master')

@section('title', trans('messages.create_stock_take'))

@section('content')
<div class="page-header">
    <h2>{{ trans('messages.create_stock_take') }}</h2>
    <a href="{{ route('stock-takes.index') }}" class="btn btn-secondary">{{ trans('messages.back') }}</a>
</div>

<div class="card">
    <div class="card-body">
        <form method="POST" action="{{ route('stock-takes.store') }}">
            @csrf
            <div class="row mb-3">
                <div class="col-md-4">
                    <label for="stock_take_date" class="form-label">{{ trans('messages.stock_take_date') }} *</label>
                    <input type="date" class="form-control" id="stock_take_date" name="stock_take_date" value="{{ date('Y-m-d') }}" required>
                </div>
                <div class="col-md-4">
                    <label for="type" class="form-label">{{ trans('messages.type') }} *</label>
                    <select class="form-select" id="type" name="type" required>
                        <option value="full">{{ trans('messages.full') }}</option>
                        <option value="partial">{{ trans('messages.partial') }}</option>
                    </select>
                </div>
            </div>

            <div class="mb-3">
                <label for="products" class="form-label">{{ trans('messages.products') }} *</label>
                <select class="form-select" id="products" name="products[]" multiple size="10" required>
                    @foreach($products as $product)
                        <option value="{{ $product->id }}">{{ $product->name }} ({{ trans('messages.stock') }}: {{ $product->stock_quantity }})</option>
                    @endforeach
                </select>
                <small class="form-text text-muted">{{ trans('messages.hold_ctrl_to_select_multiple') }}</small>
            </div>

            <div class="mb-3">
                <label for="notes" class="form-label">{{ trans('messages.notes') }}</label>
                <textarea class="form-control" id="notes" name="notes" rows="3"></textarea>
            </div>

            <div class="text-end">
                <button type="submit" class="btn btn-primary">{{ trans('messages.save') }}</button>
            </div>
        </form>
    </div>
</div>
@endsection

