@extends('layouts.master')

@section('title', trans('messages.edit_stock_take'))

@section('content')
<div class="page-header">
    <h2>{{ trans('messages.edit_stock_take') }}: {{ $stockTake->reference_number }}</h2>
    <a href="{{ route('stock-takes.show', $stockTake) }}" class="btn btn-secondary">{{ trans('messages.back') }}</a>
</div>

<div class="card">
    <div class="card-body">
        <form method="POST" action="{{ route('stock-takes.update', $stockTake) }}">
            @csrf
            @method('PUT')
            
            <h5>{{ trans('messages.items') }}</h5>
            <div class="table-responsive mb-3">
                <table class="table">
                    <thead>
                        <tr>
                            <th>{{ trans('messages.product') }}</th>
                            <th>{{ trans('messages.system_quantity') }}</th>
                            <th>{{ trans('messages.counted_quantity') }} *</th>
                            <th>{{ trans('messages.variance') }}</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($stockTake->items as $item)
                        <tr>
                            <td>{{ $item->product->name }}</td>
                            <td>{{ $item->system_quantity }}</td>
                            <td>
                                <input type="number" class="form-control counted-quantity" 
                                       name="counted_quantities[{{ $item->id }}]" 
                                       value="{{ $item->counted_quantity }}" 
                                       min="0" 
                                       required
                                       onchange="calculateVariance(this)">
                            </td>
                            <td>
                                <span class="variance-badge badge" id="variance-{{ $item->id }}">
                                    {{ $item->variance > 0 ? '+' : '' }}{{ $item->variance }}
                                </span>
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>

            <div class="text-end">
                <button type="submit" class="btn btn-primary">{{ trans('messages.save') }}</button>
            </div>
        </form>
    </div>
</div>

@push('scripts')
<script>
function calculateVariance(input) {
    const row = input.closest('tr');
    const systemQty = parseInt(row.querySelector('td:nth-child(2)').textContent);
    const countedQty = parseInt(input.value) || 0;
    const variance = countedQty - systemQty;
    
    const badge = row.querySelector('.variance-badge');
    badge.textContent = (variance > 0 ? '+' : '') + variance;
    badge.className = 'variance-badge badge bg-' + (variance == 0 ? 'success' : (variance > 0 ? 'info' : 'danger'));
}
</script>
@endpush
@endsection

