@extends('layouts.master')

@section('title', trans('messages.stock_takes'))

@section('content')
<div class="page-header">
    <h2>{{ trans('messages.stock_takes') }}</h2>
    <div>
        <a href="{{ route('stock-takes.create') }}" class="btn btn-primary">
            <i class="bi bi-plus-circle"></i> {{ trans('messages.create_stock_take') }}
        </a>
    </div>
</div>

<div class="card">
    <div class="card-body">
        <form method="GET" action="{{ route('stock-takes.index') }}" class="mb-3">
            <div class="row g-3">
                <div class="col-md-4">
                    <input type="text" name="search" class="form-control" placeholder="{{ trans('messages.search') }}..." value="{{ request('search') }}">
                </div>
                <div class="col-md-3">
                    <select name="status" class="form-select">
                        <option value="">{{ trans('messages.all_statuses') }}</option>
                        <option value="draft" {{ request('status') == 'draft' ? 'selected' : '' }}>{{ trans('messages.draft') }}</option>
                        <option value="in_progress" {{ request('status') == 'in_progress' ? 'selected' : '' }}>{{ trans('messages.in_progress') }}</option>
                        <option value="completed" {{ request('status') == 'completed' ? 'selected' : '' }}>{{ trans('messages.completed') }}</option>
                    </select>
                </div>
                <div class="col-md-3">
                    <select name="type" class="form-select">
                        <option value="">{{ trans('messages.all_types') }}</option>
                        <option value="full" {{ request('type') == 'full' ? 'selected' : '' }}>{{ trans('messages.full') }}</option>
                        <option value="partial" {{ request('type') == 'partial' ? 'selected' : '' }}>{{ trans('messages.partial') }}</option>
                        <option value="scheduled" {{ request('type') == 'scheduled' ? 'selected' : '' }}>{{ trans('messages.scheduled') }}</option>
                    </select>
                </div>
                <div class="col-md-2">
                    <button type="submit" class="btn btn-secondary w-100">{{ trans('messages.filter') }}</button>
                </div>
            </div>
        </form>

        <div class="table-responsive">
            <table class="table table-hover">
                <thead>
                    <tr>
                        <th>{{ trans('messages.reference_number') }}</th>
                        <th>{{ trans('messages.stock_take_date') }}</th>
                        <th>{{ trans('messages.type') }}</th>
                        <th>{{ trans('messages.status') }}</th>
                        <th>{{ trans('messages.items_count') }}</th>
                        <th>{{ trans('messages.created_at') }}</th>
                        <th>{{ trans('messages.actions') }}</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($stockTakes as $stockTake)
                    <tr>
                        <td><a href="{{ route('stock-takes.show', $stockTake) }}">{{ $stockTake->reference_number }}</a></td>
                        <td>{{ $stockTake->stock_take_date->format('Y-m-d') }}</td>
                        <td>
                            <span class="badge bg-info">{{ trans('messages.' . $stockTake->type) }}</span>
                        </td>
                        <td>
                            @php
                                $badgeClass = match($stockTake->status) {
                                    'draft' => 'secondary',
                                    'in_progress' => 'warning',
                                    'completed' => 'success',
                                    'cancelled' => 'danger',
                                    default => 'secondary'
                                };
                            @endphp
                            <span class="badge bg-{{ $badgeClass }}">{{ trans('messages.' . $stockTake->status) }}</span>
                        </td>
                        <td>{{ $stockTake->items->count() }}</td>
                        <td>{{ $stockTake->created_at->format('Y-m-d') }}</td>
                        <td>
                            <a href="{{ route('stock-takes.show', $stockTake) }}" class="btn btn-sm btn-info">{{ trans('messages.view') }}</a>
                            @if($stockTake->isDraft())
                                <a href="{{ route('stock-takes.edit', $stockTake) }}" class="btn btn-sm btn-warning">{{ trans('messages.edit') }}</a>
                            @endif
                            @if(!$stockTake->isCompleted())
                                <form action="{{ route('stock-takes.complete', $stockTake) }}" method="POST" class="d-inline">
                                    @csrf
                                    <button type="submit" class="btn btn-sm btn-success" onclick="return confirm('{{ trans('messages.confirm_complete_stock_take') }}')">
                                        {{ trans('messages.complete_stock_take') }}
                                    </button>
                                </form>
                            @endif
                        </td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="7" class="text-center">{{ trans('messages.no_stock_takes_found') }}</td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
        </div>

        <div class="mt-3">
            {{ $stockTakes->links() }}
        </div>
    </div>
</div>
@endsection

