@extends('layouts.master')

@section('title', trans('messages.suppliers'))

@section('content')
@php
    $sort = request()->get('sort', 'created_at');
    $direction = request()->get('direction', 'desc');
@endphp
<div class="page-header">
    <h2>{{ trans('messages.suppliers') }}</h2>
    <div>
        @can('suppliers.import')
            <a href="{{ route('suppliers.import') }}" class="btn btn-success"><i class="bi bi-upload"></i> {{ trans('messages.import_suppliers') }}</a>
        @endcan
        @can('suppliers.create')
            <a href="{{ route('suppliers.create') }}" class="btn btn-primary"><i class="bi bi-plus-circle"></i> {{ trans('messages.add_supplier') }}</a>
        @endcan
        @if(request('filter') === 'with_debts')
            @can('suppliers.print_debts')
                <a href="{{ route('suppliers.print-with-debts') }}" class="btn btn-info" target="_blank"><i class="bi bi-printer"></i> {{ trans('messages.print') }}</a>
            @endcan
        @endif
    </div>
</div>

<div class="card">
    <div class="card-body">
        <form method="GET" action="{{ route('suppliers.index') }}" class="mb-3">
            <div class="row g-3">
                <div class="col-md-8">
                    <input type="text" name="search" class="form-control" placeholder="{{ trans('messages.search') }}..." value="{{ request('search') }}">
                </div>
                <div class="col-md-2">
                    <select name="filter" class="form-select">
                        <option value="">{{ trans('messages.all_suppliers') }}</option>
                        <option value="with_debts" {{ request('filter') === 'with_debts' ? 'selected' : '' }}>{{ trans('messages.suppliers_with_debts') }}</option>
                    </select>
                </div>
                <div class="col-md-2">
                    <button type="submit" class="btn btn-secondary w-100">{{ trans('messages.search') }}</button>
                </div>
            </div>
        </form>

        @can('suppliers.bulk_delete')
        <div class="mb-3">
            <button type="button" id="delete-selected-btn" class="btn btn-danger" disabled data-bs-toggle="modal" data-bs-target="#bulkDeleteModal">
                <i class="bi bi-trash"></i> {{ trans('messages.delete_selected') }}
            </button>
        </div>
        @endcan

        <div class="table-responsive">
            <table class="table table-hover">
                    <thead>
                        <tr>
                            @can('suppliers.bulk_delete')
                            <th style="width: 40px;">
                                <input type="checkbox" id="select-all" title="{{ trans('messages.select_all') }}">
                            </th>
                            @endcan
                            <th>
                            <a href="{{ request()->fullUrlWithQuery(['sort' => 'name', 'direction' => ($sort === 'name' && $direction === 'asc') ? 'desc' : 'asc']) }}" class="text-decoration-none text-dark">
                                {{ trans('messages.name') }}
                                @if($sort === 'name')
                                    <i class="bi bi-arrow-{{ $direction === 'asc' ? 'up' : 'down' }}"></i>
                                @else
                                    <i class="bi bi-arrow-down-up text-muted"></i>
                                @endif
                            </a>
                        </th>
                        <th>
                            <a href="{{ request()->fullUrlWithQuery(['sort' => 'email', 'direction' => ($sort === 'email' && $direction === 'asc') ? 'desc' : 'asc']) }}" class="text-decoration-none text-dark">
                                {{ trans('messages.email') }}
                                @if($sort === 'email')
                                    <i class="bi bi-arrow-{{ $direction === 'asc' ? 'up' : 'down' }}"></i>
                                @else
                                    <i class="bi bi-arrow-down-up text-muted"></i>
                                @endif
                            </a>
                        </th>
                        <th>
                            <a href="{{ request()->fullUrlWithQuery(['sort' => 'phone', 'direction' => ($sort === 'phone' && $direction === 'asc') ? 'desc' : 'asc']) }}" class="text-decoration-none text-dark">
                                {{ trans('messages.phone') }}
                                @if($sort === 'phone')
                                    <i class="bi bi-arrow-{{ $direction === 'asc' ? 'up' : 'down' }}"></i>
                                @else
                                    <i class="bi bi-arrow-down-up text-muted"></i>
                                @endif
                            </a>
                        </th>
                        <th>{{ trans('messages.address') }}</th>
                        <th>{{ trans('messages.current_balance') }}</th>
                        <th>{{ trans('messages.actions') }}</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($suppliers as $supplier)
                    <tr>
                        @can('suppliers.bulk_delete')
                        <td>
                            <input type="checkbox" class="item-checkbox" value="{{ $supplier->id }}">
                        </td>
                        @endcan
                        <td><a href="{{ route('suppliers.show', $supplier) }}">{{ $supplier->name }}</a></td>
                        <td>{{ $supplier->email ?? 'N/A' }}</td>
                        <td>{{ $supplier->phone ?? 'N/A' }}</td>
                        <td>{{ $supplier->address ?? 'N/A' }}</td>
                        <td>
                            @php
                                $balance = $supplier->calculated_balance ?? $supplier->calculateCurrentBalance();
                            @endphp
                            <span class="badge {{ $balance > 0 ? 'text-danger bg-light' : 'text-success bg-light' }}">
                                {{ format_currency($balance) }}
                            </span>
                        </td>
                        <td>
                            @can('suppliers.view')
                                <a href="{{ route('suppliers.show', $supplier) }}" class="btn btn-sm btn-info" title="{{ trans('messages.view') ?? 'View' }}"><i class="bi bi-eye"></i></a>
                            @endcan
                            @can('suppliers.update')
                                <a href="{{ route('suppliers.edit', $supplier) }}" class="btn btn-sm btn-warning" title="{{ trans('messages.edit') }}"><i class="bi bi-pencil"></i></a>
                            @endcan
                            @can('suppliers.delete')
                                <form action="{{ route('suppliers.destroy', $supplier) }}" method="POST" class="d-inline delete-form">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="btn btn-sm btn-danger" title="{{ trans('messages.delete') }}" onclick="event.preventDefault(); confirmAction('{{ trans('messages.confirm_delete_supplier') }}', '{{ trans('messages.confirm_delete') }}', () => this.closest('form').submit()); return false;"><i class="bi bi-trash"></i></button>
                                </form>
                            @endcan
                        </td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="{{ auth()->user()->can('suppliers.bulk_delete') ? '7' : '6' }}" class="text-center">{{ trans('messages.no_suppliers_found') }}</td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
        </div>

        <!-- Hidden form for bulk delete -->
        <form id="bulk-delete-form" method="POST" action="{{ route('suppliers.bulk_delete') }}" style="display: none;">
            @csrf
        </form>

        {{ $suppliers->links() }}
    </div>
</div>

@include('partials.bulk-delete-modal')
@endsection
