@php
    $currency = currency_symbol();
@endphp
<!DOCTYPE html>
<html lang="{{ $locale }}" dir="{{ $dir }}">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>{{ trans('messages.suppliers_with_debts') }}</title>
    <link rel="stylesheet" href="{{ asset('lib/fonts/google-fonts.css') }}">
    <link href="{{ asset('lib/css/bootstrap.min.css') }}" rel="stylesheet">
    <style>
        @charset "UTF-8";
        
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        @media print {
            .no-print {
                display: none !important;
            }
            body {
                padding: 0;
            }
        }
        
        body {
            font-family: {{ $isRTL ? "'Cairo', 'DejaVu Sans', sans-serif" : "'Cabin', 'DejaVu Sans', sans-serif" }};
            direction: {{ $dir }};
            padding: 20px;
            unicode-bidi: embed;
            font-size: 14px;
            color: #333;
        }
        
        @if($isRTL)
        * {
            font-family: 'Cairo', 'DejaVu Sans', sans-serif !important;
        }
        @else
        * {
            font-family: 'Cabin', 'DejaVu Sans', sans-serif !important;
        }
        @endif
        
        .header {
            border-bottom: 3px solid #dc3545;
            padding-bottom: 20px;
            margin-bottom: 30px;
        }
        
        .header-content {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 20px;
        }
        
        .logo-container {
            {{ $isRTL ? 'text-align: right;' : 'text-align: left;' }}
        }
        
        .logo-container img {
            max-height: 80px;
        }
        
        .header-info {
            {{ $isRTL ? 'text-align: left;' : 'text-align: right;' }}
        }
        
        .header-info h2 {
            color: #dc3545;
            margin-bottom: 10px;
        }
        
        .summary-box {
            background-color: #fff3cd;
            border: 2px solid #ffc107;
            border-radius: 5px;
            padding: 15px;
            margin-bottom: 20px;
        }
        
        .summary-box h4 {
            color: #856404;
            margin-bottom: 10px;
        }
        
        .table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
        }
        
        .table th {
            background-color: #dc3545;
            color: white;
            padding: 12px;
            text-align: {{ $isRTL ? 'right' : 'left' }};
            border: 1px solid #dc3545;
        }
        
        .table td {
            padding: 10px;
            border: 1px solid #dee2e6;
        }
        
        .table tbody tr:nth-child(even) {
            background-color: #f8f9fa;
        }
        
        .table tbody tr:hover {
            background-color: #e9ecef;
        }
        
        .text-danger {
            color: #dc3545 !important;
            font-weight: bold;
        }
        
        .footer {
            margin-top: 30px;
            padding-top: 20px;
            border-top: 2px solid #dee2e6;
            text-align: center;
            color: #6c757d;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="text-center mb-3 no-print">
            <button onclick="window.print()" class="btn btn-primary">
                <i class="bi bi-printer"></i> {{ $isRTL ? 'طباعة' : 'Imprimer' }}
            </button>
            <button onclick="window.close()" class="btn btn-secondary ms-2">
                <i class="bi bi-x-circle"></i> {{ trans('messages.close') }}
            </button>
        </div>
        
        <div class="header">
            <div class="header-content">
                <div class="logo-container">
                    @if($storeLogo)
                        <img src="{{ storage_url( $storeLogo) }}" alt="{{ $storeName }}">
                    @else
                        <h3>{{ $storeName }}</h3>
                    @endif
                </div>
                <div class="header-info">
                    <h2>{{ trans('messages.suppliers_with_debts') }}</h2>
                    <p><strong>{{ trans('messages.date') }}:</strong> {{ now()->format('Y-m-d H:i') }}</p>
                </div>
            </div>
        </div>
        
        <div class="summary-box">
            <h4><i class="bi bi-info-circle"></i> {{ trans('messages.summary') }}</h4>
            <p><strong>{{ trans('messages.total_suppliers') }}:</strong> {{ $suppliersWithDebts->count() }}</p>
            <p><strong>{{ trans('messages.total_debts') }}:</strong> <span class="text-danger">{{ format_currency($totalDebts) }}</span></p>
        </div>
        
        <table class="table">
            <thead>
                <tr>
                    <th>#</th>
                    <th>{{ trans('messages.name') }}</th>
                    <th>{{ trans('messages.phone') }}</th>
                    <th>{{ trans('messages.email') }}</th>
                    <th>{{ trans('messages.address') }}</th>
                    <th>{{ trans('messages.current_balance') }}</th>
                </tr>
            </thead>
            <tbody>
                @forelse($suppliersWithDebts as $index => $supplier)
                <tr>
                    <td>{{ $index + 1 }}</td>
                    <td>{{ $supplier->name }}</td>
                    <td>{{ $supplier->phone ?? 'N/A' }}</td>
                    <td>{{ $supplier->email ?? 'N/A' }}</td>
                    <td>{{ $supplier->address ?? 'N/A' }}</td>
                    <td class="text-danger">{{ format_currency($supplier->calculated_balance) }}</td>
                </tr>
                @empty
                <tr>
                    <td colspan="6" class="text-center">{{ trans('messages.no_suppliers_with_debts') }}</td>
                </tr>
                @endforelse
            </tbody>
            @if($suppliersWithDebts->count() > 0)
            <tfoot>
                <tr>
                    <td colspan="5" class="text-end"><strong>{{ trans('messages.total') }}:</strong></td>
                    <td class="text-danger"><strong>{{ format_currency($totalDebts) }}</strong></td>
                </tr>
            </tfoot>
            @endif
        </table>
        
        <div class="footer">
            <p>{{ trans('messages.generated_at') }}: {{ now()->format('Y-m-d H:i:s') }}</p>
        </div>
    </div>
</body>
</html>

