@extends('layouts.master')

@section('title', trans('messages.supplier_details'))

@section('content')
<div class="page-header">
    <h2>{{ trans('messages.supplier') }}: {{ $supplier->name }}</h2>
    <div>
        <a href="{{ route('suppliers.edit', $supplier) }}" class="btn btn-warning"><i class="bi bi-pencil"></i> {{ trans('messages.edit') }}</a>
        <a href="{{ route('suppliers.index') }}" class="btn btn-secondary">{{ trans('messages.back') }}</a>
    </div>
</div>

<div class="row">
    <div class="col-md-4">
        <div class="card">
            <div class="card-body">
                <h5>{{ trans('messages.supplier_details') }}</h5>
                <p><strong>{{ trans('messages.name') }}:</strong> {{ $supplier->name }}</p>
                <p><strong>{{ trans('messages.email') }}:</strong> {{ $supplier->email ?? 'N/A' }}</p>
                <p><strong>{{ trans('messages.phone') }}:</strong> {{ $supplier->phone ?? 'N/A' }}</p>
                <p><strong>{{ trans('messages.address') }}:</strong> {{ $supplier->address ?? 'N/A' }}</p>
                <p><strong>{{ trans('messages.current_balance') }}:</strong> 
                    @php
                        $balance = $supplier->calculated_balance ?? $supplier->calculateCurrentBalance();
                    @endphp
                    <span class="badge {{ $balance <= 0 ? 'text-success bg-light' : 'text-danger bg-light' }}">
                        {{ format_currency($balance) }}
                    </span>
                </p>
            </div>
        </div>
    </div>
    <div class="col-md-8">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0">{{ trans('messages.purchase_invoices') }}</h5>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table">
                        <thead>
                            <tr>
                                <th>{{ trans('messages.invoice_number') }}</th>
                                <th>{{ trans('messages.date') }}</th>
                                <th>{{ trans('messages.total_amount') }}</th>
                                <th>{{ trans('messages.amount_paid') }}</th>
                                <th>{{ trans('messages.amount_remaining') }}</th>
                                <th>{{ trans('messages.status') }}</th>
                                <th>{{ trans('messages.actions') }}</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse($supplier->purchaseInvoices as $purchaseInvoice)
                            <tr>
                                <td><a href="{{ route('purchase-invoices.show', $purchaseInvoice) }}">{{ $purchaseInvoice->invoice_number }}</a></td>
                                <td>{{ $purchaseInvoice->created_at->format('Y-m-d') }}</td>
                                <td>{{ format_currency($purchaseInvoice->total_amount) }}</td>
                                <td>{{ format_currency($purchaseInvoice->amount_paid) }}</td>
                                <td>{{ format_currency($purchaseInvoice->amount_remaining) }}</td>
                                <td>
                                    @php
                                        $badgeClass = match($purchaseInvoice->status) {
                                            'paid' => 'success',
                                            'partially_paid' => 'warning',
                                            'draft' => 'secondary',
                                            'returned' => 'danger',
                                            'confirmed' => 'info',
                                            default => 'info'
                                        };
                                    @endphp
                                    <span class="badge bg-{{ $badgeClass }}">{{ trans('messages.' . $purchaseInvoice->status) }}</span>
                                </td>
                                <td><a href="{{ route('purchase-invoices.show', $purchaseInvoice) }}" class="btn btn-sm btn-info"><i class="bi bi-eye"></i></a></td>
                            </tr>
                            @empty
                            <tr>
                                <td colspan="7" class="text-center">{{ trans('messages.no_purchase_invoices_found') }}</td>
                            </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
            </div>
        </div>

        <!-- Cheques Section -->
        <div class="card mt-3">
            <div class="card-header">
                <h5 class="mb-0">{{ trans('messages.cheques') }}</h5>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table">
                        <thead>
                            <tr>
                                <th>{{ trans('messages.cheque_number') }}</th>
                                <th>{{ trans('messages.bank_name') }}</th>
                                <th>{{ trans('messages.amount') }}</th>
                                <th>{{ trans('messages.issue_date') }}</th>
                                <th>{{ trans('messages.due_date') }}</th>
                                <th>{{ trans('messages.status') }}</th>
                                <th>{{ trans('messages.actions') }}</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse($supplier->cheques as $cheque)
                            <tr>
                                <td>{{ $cheque->cheque_number }}</td>
                                <td>{{ $cheque->bank_name }}</td>
                                <td>{{ format_currency($cheque->amount) }}</td>
                                <td>{{ $cheque->issue_date->format('Y-m-d') }}</td>
                                <td>{{ $cheque->due_date->format('Y-m-d') }}</td>
                                <td>
                                    @php
                                        $badgeClass = match($cheque->status) {
                                            'paid' => 'success',
                                            'returned' => 'danger',
                                            'cancelled' => 'secondary',
                                            'due' => 'warning',
                                            default => 'info'
                                        };
                                    @endphp
                                    <span class="badge bg-{{ $badgeClass }}">{{ trans('messages.' . $cheque->status) }}</span>
                                </td>
                                <td>
                                    <a href="{{ route('cheques.show', $cheque) }}" class="btn btn-sm btn-info">
                                        <i class="bi bi-eye"></i>
                                    </a>
                                </td>
                            </tr>
                            @empty
                            <tr>
                                <td colspan="7" class="text-center">{{ trans('messages.no_cheques_found') }}</td>
                            </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
            </div>
        </div>

        <!-- Promissory Notes Section -->
        <div class="card mt-3">
            <div class="card-header">
                <h5 class="mb-0">{{ trans('messages.promissory_notes') }}</h5>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table">
                        <thead>
                            <tr>
                                <th>{{ trans('messages.note_number') }}</th>
                                <th>{{ trans('messages.amount') }}</th>
                                <th>{{ trans('messages.issue_date') }}</th>
                                <th>{{ trans('messages.due_date') }}</th>
                                <th>{{ trans('messages.status') }}</th>
                                <th>{{ trans('messages.actions') }}</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse($supplier->promissoryNotes as $promissoryNote)
                            <tr>
                                <td>{{ $promissoryNote->note_number }}</td>
                                <td>{{ format_currency($promissoryNote->amount) }}</td>
                                <td>{{ $promissoryNote->issue_date->format('Y-m-d') }}</td>
                                <td>{{ $promissoryNote->due_date->format('Y-m-d') }}</td>
                                <td>
                                    @php
                                        $badgeClass = match($promissoryNote->status) {
                                            'paid' => 'success',
                                            'cancelled' => 'secondary',
                                            'due' => 'warning',
                                            default => 'info'
                                        };
                                    @endphp
                                    <span class="badge bg-{{ $badgeClass }}">{{ trans('messages.' . $promissoryNote->status) }}</span>
                                </td>
                                <td>
                                    <a href="{{ route('promissory-notes.show', $promissoryNote) }}" class="btn btn-sm btn-info">
                                        <i class="bi bi-eye"></i>
                                    </a>
                                </td>
                            </tr>
                            @empty
                            <tr>
                                <td colspan="6" class="text-center">{{ trans('messages.no_promissory_notes_found') }}</td>
                            </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
            </div>
        </div>

        <!-- Documents Section -->
        @include('documents.partials.manage', ['type' => 'supplier', 'id' => $supplier->id])
    </div>
</div>
@endsection

