@extends('layouts.master')

@section('title', trans('messages.treasury') . ' - ' . trans('messages.view'))

@section('content')
<div class="page-header">
    <h2>{{ trans('messages.treasury') }} - {{ trans('messages.view') }}</h2>
    <div>
        <a href="{{ route('treasury.index') }}" class="btn btn-secondary"><i class="bi bi-arrow-left"></i> {{ trans('messages.back') }}</a>
        @if(auth()->user()->hasAnyRole(['Super Admin', 'Admin']) && $treasury->reference_type === 'manual')
            <a href="{{ route('treasury.edit', $treasury) }}" class="btn btn-warning"><i class="bi bi-pencil"></i> {{ trans('messages.edit') }}</a>
            <form action="{{ route('treasury.destroy', $treasury) }}" method="POST" class="d-inline delete-form">
                @csrf
                @method('DELETE')
                <button type="submit" class="btn btn-danger" onclick="event.preventDefault(); confirmAction('{{ trans('messages.confirm_delete') }}', '{{ trans('messages.confirm_delete') }}', () => this.closest('form').submit()); return false;"><i class="bi bi-trash"></i> {{ trans('messages.delete') }}</button>
            </form>
        @endif
    </div>
</div>

<div class="card">
    <div class="card-header">
        <h5 class="mb-0">{{ trans('messages.treasury') }} #{{ $treasury->id }}</h5>
    </div>
    <div class="card-body">
        <div class="row">
            <div class="col-md-6">
                <table class="table table-bordered">
                    <tr>
                        <th style="width: 200px;">{{ trans('messages.date') }}</th>
                        <td>{{ $treasury->date ? \Carbon\Carbon::parse($treasury->date)->format('Y-m-d') : '-' }}</td>
                    </tr>
                    <tr>
                        <th>{{ trans('messages.type') }}</th>
                        <td>
                            <span class="badge {{ $treasury->type === 'income' ? 'bg-success' : 'bg-danger' }}">
                                {{ trans('messages.' . $treasury->type) }}
                            </span>
                        </td>
                    </tr>
                    <tr>
                        <th>{{ trans('messages.reference_type') }}</th>
                        <td>{{ trans('messages.' . $treasury->reference_type) }}</td>
                    </tr>
                    <tr>
                        <th>{{ trans('messages.amount') }}</th>
                        <td><strong>{{ format_currency($treasury->amount) }}</strong></td>
                    </tr>
                </table>
            </div>
            <div class="col-md-6">
                <table class="table table-bordered">
                    <tr>
                        <th style="width: 200px;">{{ trans('messages.payment_method') }}</th>
                        <td>{{ trans('messages.' . $treasury->payment_method) }}</td>
                    </tr>
                    <tr>
                        <th>{{ trans('messages.description') }}</th>
                        <td>{{ $treasury->description ?? '-' }}</td>
                    </tr>
                    <tr>
                        <th>{{ trans('messages.created_by') }}</th>
                        <td>{{ $treasury->creator->name ?? '-' }}</td>
                    </tr>
                    <tr>
                        <th>{{ trans('messages.created_at') }}</th>
                        <td>{{ $treasury->created_at->format('Y-m-d H:i:s') }}</td>
                    </tr>
                </table>
            </div>
        </div>
    </div>
</div>
@endsection

