@php
    $locale = app()->getLocale();
    $isRTL = $locale === 'ar';
@endphp
<!DOCTYPE html>
<html lang="{{ $locale }}" dir="{{ $isRTL ? 'rtl' : 'ltr' }}">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>{{ $isRTL ? 'انتهت الفترة التجريبية' : 'Trial Period Expired' }}</title>
    <link rel="stylesheet" href="{{ asset('lib/fonts/google-fonts.css') }}">
    <link href="{{ asset('lib/css/bootstrap.min.css') }}" rel="stylesheet">
    <link rel="stylesheet" href="{{ asset('lib/icons/bootstrap-icons/bootstrap-icons.css') }}">
    <style>
        @php
            $fontFamily = $isRTL ? "'Cairo', 'DejaVu Sans', 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif" : "'Cabin', 'DejaVu Sans', 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif";
        @endphp
        
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        @if($isRTL)
        * {
            font-family: 'Cairo', 'DejaVu Sans', 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif !important;
        }
        @else
        * {
            font-family: 'Cabin', 'DejaVu Sans', 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif !important;
        }
        @endif
        
        body {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            font-family: {{ $fontFamily }};
            padding: 20px;
            position: relative;
            overflow-x: hidden;
        }
        
        /* Animated background particles */
        body::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: url('data:image/svg+xml,<svg width="100" height="100" xmlns="http://www.w3.org/2000/svg"><circle cx="50" cy="50" r="2" fill="rgba(255,255,255,0.1)"/></svg>');
            opacity: 0.3;
            animation: float 20s infinite linear;
        }
        
        @keyframes float {
            0% { transform: translateY(0); }
            100% { transform: translateY(-100px); }
        }
        
        .trial-expired-card {
            background: white;
            border-radius: 20px;
            box-shadow: 0 20px 60px rgba(0,0,0,0.3);
            padding: 30px 35px;
            max-width: 600px;
            width: 100%;
            text-align: center;
            position: relative;
            z-index: 1;
            animation: slideUp 0.6s ease-out;
            margin: 0 auto;
        }
        
        @keyframes slideUp {
            from {
                opacity: 0;
                transform: translateY(30px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }
        
        .icon-wrapper {
            width: 90px;
            height: 90px;
            background: linear-gradient(135deg, #dc3545 0%, #c82333 100%);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 20px;
            box-shadow: 0 10px 30px rgba(220, 53, 69, 0.4);
            animation: pulse 2s infinite;
            position: relative;
        }
        
        .icon-wrapper::before {
            content: '';
            position: absolute;
            width: 100%;
            height: 100%;
            border-radius: 50%;
            background: rgba(220, 53, 69, 0.2);
            animation: ripple 2s infinite;
        }
        
        @keyframes pulse {
            0%, 100% {
                transform: scale(1);
            }
            50% {
                transform: scale(1.05);
            }
        }
        
        @keyframes ripple {
            0% {
                transform: scale(1);
                opacity: 1;
            }
            100% {
                transform: scale(1.5);
                opacity: 0;
            }
        }
        
        .icon-wrapper i {
            font-size: 45px;
            color: white;
            position: relative;
            z-index: 1;
        }
        
        h1 {
            color: #2c3e50;
            margin-bottom: 10px;
            font-weight: 700;
            font-size: 1.8rem;
        }
        
        .lead {
            color: #6c757d;
            font-size: 1rem;
            margin-bottom: 20px;
            line-height: 1.5;
        }
        
        .info-box {
            background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
            border-radius: 15px;
            padding: 18px;
            margin: 20px 0;
            border: 2px solid #e9ecef;
            box-shadow: 0 5px 15px rgba(0,0,0,0.05);
        }
        
        .info-box p {
            margin: 8px 0;
            font-size: 0.95rem;
            color: #495057;
        }
        
        .info-box strong {
            color: #2c3e50;
            font-weight: 600;
        }
        
        .contact-info {
            margin-top: 25px;
            padding-top: 20px;
            border-top: 2px solid #e9ecef;
        }
        
        .contact-info h5 {
            color: #2c3e50;
            margin-bottom: 15px;
            font-weight: 600;
            font-size: 1.1rem;
        }
        
        .contact-info p {
            margin: 10px 0;
            color: #495057;
            font-size: 0.95rem;
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 8px;
        }
        
        .contact-info i {
            color: #667eea;
            font-size: 1.2rem;
        }
        
        .contact-info strong {
            color: #2c3e50;
            font-weight: 600;
        }
        
        .btn {
            font-weight: 600;
            padding: 10px 25px;
            border-radius: 10px;
            transition: all 0.3s ease;
            box-shadow: 0 4px 15px rgba(0,0,0,0.1);
            border: none;
            font-size: 0.95rem;
        }
        
        .btn:hover {
            transform: translateY(-2px);
            box-shadow: 0 6px 20px rgba(0,0,0,0.15);
        }
        
        .btn-primary {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
        }
        
        .btn-primary:hover {
            background: linear-gradient(135deg, #5568d3 0%, #6a3d8f 100%);
            color: white;
        }
        
        .btn-secondary {
            background: #6c757d;
            color: white;
        }
        
        .btn-secondary:hover {
            background: #5a6268;
            color: white;
        }
        
        .btn i {
            margin-{{ $isRTL ? 'left' : 'right' }}: 8px;
        }
        
        @media (max-width: 768px) {
            .trial-expired-card {
                padding: 35px 25px;
            }
            
            h1 {
                font-size: 1.8rem;
            }
            
            .icon-wrapper {
                width: 100px;
                height: 100px;
            }
            
            .icon-wrapper i {
                font-size: 50px;
            }
            
            .btn {
                width: 100%;
                margin-bottom: 10px;
            }
        }
    </style>
</head>
<body>
    <div class="trial-expired-card">
            <div class="icon-wrapper">
                <i class="bi bi-exclamation-triangle-fill"></i>
            </div>
            <h1>{{ $isRTL ? 'انتهت الفترة التجريبية' : 'Trial Period Expired' }}</h1>
            <p class="lead text-muted">
                {{ $isRTL ? 'عذراً، انتهت فترة التجربة المجانية لمدة 20 يوم' : 'Sorry, the 20-day free trial period has ended' }}
            </p>
            
            <div class="info-box">
                <p class="mb-2">
                    <strong>{{ $isRTL ? 'تاريخ البداية:' : 'Start Date:' }}</strong> 
                    {{ $trialInfo['start_date'] }}
                </p>
                <p class="mb-0">
                    <strong>{{ $isRTL ? 'تاريخ الانتهاء:' : 'End Date:' }}</strong> 
                    {{ $trialInfo['end_date'] }}
                </p>
            </div>

            <div class="contact-info">
                <h5>{{ $isRTL ? 'للحصول على نسخة كاملة:' : 'To Get Full Version:' }}</h5>
                <p class="mb-2">
                    <i class="bi bi-envelope"></i> 
                    <strong>{{ $isRTL ? 'البريد الإلكتروني:' : 'Email:' }}</strong> 
                    imranesoft@gmail.com
                </p>
                <p class="mb-2">
                    <i class="bi bi-telephone"></i> 
                    <strong>{{ $isRTL ? 'الهاتف:' : 'Phone:' }}</strong> 
                    05.28.60.08.09
                </p>
                <p class="mb-0">
                    <i class="bi bi-globe"></i> 
                    <strong>{{ $isRTL ? 'الموقع:' : 'Website:' }}</strong> 
                    www.imranesoft.com
                </p>
            </div>

            <div class="mt-4 d-flex flex-wrap gap-2 justify-content-center">
                <a href="{{ route('license.activate') }}" class="btn btn-primary btn-lg">
                    <i class="bi bi-key"></i> 
                    {{ $isRTL ? 'تفعيل الترخيص' : 'Activate License' }}
                </a>
                <a href="{{ route('login') }}" class="btn btn-secondary btn-lg">
                    <i class="bi bi-arrow-left"></i> 
                    {{ $isRTL ? 'العودة إلى تسجيل الدخول' : 'Back to Login' }}
                </a>
            </div>
    </div>
</body>
</html>
