@extends('layouts.master')

@section('title', trans('messages.user_guide_title'))

@section('content')
<div class="page-header">
    <h2><i class="bi bi-book"></i> {{ trans('messages.user_guide_title') }}</h2>
</div>

<div class="card mb-3">
    <div class="card-body">
        <form method="GET" action="{{ route('user-guide.index') }}" class="row g-3">
            <div class="col-md-6">
                <label for="search" class="form-label">{{ trans('messages.search') }}</label>
                <input type="text" class="form-control" id="search" name="search" value="{{ $search }}" placeholder="{{ trans('messages.search_placeholder') }}">
            </div>
            <div class="col-md-4">
                <label for="category" class="form-label">{{ trans('messages.category') }}</label>
                <select class="form-select" id="category" name="category">
                    <option value="">{{ trans('messages.all_categories') }}</option>
                    @foreach($categories as $key => $name)
                        <option value="{{ $key }}" {{ $selectedCategory === $key ? 'selected' : '' }}>{{ $name }}</option>
                    @endforeach
                </select>
            </div>
            <div class="col-md-2 d-flex align-items-end">
                <button type="submit" class="btn btn-primary w-100">{{ trans('messages.filter') }}</button>
            </div>
        </form>
    </div>
</div>

<div class="card">
    <div class="card-header">
        <h5 class="mb-0">
            <i class="bi bi-question-circle"></i> {{ trans('messages.frequently_asked_questions') }}
            @if(count($faqs) > 0)
                <span class="badge bg-primary ms-2">{{ count($faqs) }}</span>
            @endif
        </h5>
    </div>
    <div class="card-body">
        @if(count($faqs) > 0)
            <div class="accordion" id="faqAccordion">
                @foreach($faqs as $index => $faq)
                    <div class="accordion-item">
                        <h2 class="accordion-header" id="heading{{ $faq['id'] }}">
                            <button class="accordion-button {{ $index === 0 ? '' : 'collapsed' }}" type="button" data-bs-toggle="collapse" data-bs-target="#collapse{{ $faq['id'] }}" aria-expanded="{{ $index === 0 ? 'true' : 'false' }}" aria-controls="collapse{{ $faq['id'] }}">
                                <i class="bi bi-question-circle-fill text-primary me-2"></i>
                                {{ $faq['question'] }}
                            </button>
                        </h2>
                        <div id="collapse{{ $faq['id'] }}" class="accordion-collapse collapse {{ $index === 0 ? 'show' : '' }}" aria-labelledby="heading{{ $faq['id'] }}" data-bs-parent="#faqAccordion">
                            <div class="accordion-body">
                                <div class="d-flex align-items-start mb-2">
                                    <i class="bi bi-info-circle-fill text-info me-2 mt-1"></i>
                                    <div class="flex-grow-1">
                                        {!! nl2br(e($faq['answer'])) !!}
                                    </div>
                                </div>
                                <small class="text-muted">
                                    <i class="bi bi-tag"></i> {{ $categories[$faq['category']] ?? $faq['category'] }}
                                </small>
                            </div>
                        </div>
                    </div>
                @endforeach
            </div>
        @else
            <div class="text-center py-5">
                <i class="bi bi-search text-muted" style="font-size: 3rem;"></i>
                <p class="text-muted mt-3">{{ trans('messages.no_faqs_found') }}</p>
                @if($search || $selectedCategory)
                    <a href="{{ route('user-guide.index') }}" class="btn btn-primary">{{ trans('messages.show_all_faqs') }}</a>
                @endif
            </div>
        @endif
    </div>
</div>
@endsection
