@extends('layouts.master')

@section('title', trans('messages.user_guide_title') . ' - ' . trans('messages.' . $section))

@section('content')
<div class="page-header">
    <h2>
        <i class="bi bi-book"></i> {{ trans('messages.user_guide_title') }}
        <small class="text-muted">- {{ trans('messages.' . $section) }}</small>
    </h2>
    <div>
        <a href="{{ route('user-guide.index') }}" class="btn btn-secondary">
            <i class="bi bi-arrow-left"></i> {{ trans('messages.back') }}
        </a>
    </div>
</div>

<div class="card">
    <div class="card-body">
        <div class="alert alert-info">
            <i class="bi bi-info-circle"></i> {{ trans('messages.no_guide_available') }}
        </div>
        
        <div class="guide-content">
            <h3>{{ trans('messages.' . $section) }}</h3>
            <p>{{ trans('messages.user_guide_description') }}</p>
            
            <!-- Placeholder for guide content with images -->
            <div class="guide-section mt-4">
                <h4>{{ trans('messages.getting_started') }}</h4>
                <p>سيتم إضافة المحتوى والصور هنا قريباً.</p>
                <p>Content and images will be added here soon.</p>
                
                <!-- Example image placeholder -->
                <div class="guide-image mt-3 mb-3">
                    <img src="{{ asset('images/guide-placeholder.png') }}" alt="Guide Image" class="img-fluid rounded" 
                         onerror="this.style.display='none';">
                    <p class="text-muted text-center mt-2">
                        <small>{{ trans('messages.image') }}: {{ trans('messages.' . $section) }}</small>
                    </p>
                </div>
            </div>
        </div>
    </div>
</div>

@push('styles')
<style>
    .guide-content {
        line-height: 1.8;
    }
    
    .guide-section {
        margin-bottom: 2rem;
    }
    
    .guide-image {
        text-align: center;
        padding: 1rem;
        background-color: #f8f9fa;
        border-radius: 0.5rem;
    }
    
    .guide-image img {
        max-width: 100%;
        height: auto;
        box-shadow: 0 2px 8px rgba(0,0,0,0.1);
    }
</style>
@endpush
@endsection

