@extends('layouts.master')

@section('title', trans('messages.edit_user'))

@section('content')
<div class="page-header">
    <h2>{{ trans('messages.edit_user') }}: {{ $user->name }}</h2>
    <a href="{{ route('users.index') }}" class="btn btn-secondary">{{ trans('messages.back') }}</a>
</div>

<div class="card">
    <div class="card-body">
        <form method="POST" action="{{ route('users.update', $user) }}" enctype="multipart/form-data">
            @csrf
            @method('PUT')

            <div class="row">
                <div class="col-md-6">
                    <div class="mb-3">
                        <label for="name" class="form-label">{{ trans('messages.name') }} *</label>
                        <input type="text" class="form-control @error('name') is-invalid @enderror" id="name" name="name" value="{{ old('name', $user->name) }}" required>
                        @error('name')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>

                <div class="col-md-6">
                    <div class="mb-3">
                        <label for="email" class="form-label">{{ trans('messages.email') }} *</label>
                        <input type="email" class="form-control @error('email') is-invalid @enderror" id="email" name="email" value="{{ old('email', $user->email) }}" required>
                        @error('email')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-md-6">
                    <div class="mb-3">
                        <label for="password" class="form-label">{{ trans('messages.password') }}</label>
                        <input type="password" class="form-control @error('password') is-invalid @enderror" id="password" name="password" minlength="6">
                        <small class="text-muted">{{ trans('messages.leave_blank_to_keep_current') }}</small>
                        @error('password')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>

                <div class="col-md-6">
                    <div class="mb-3">
                        <label for="password_confirmation" class="form-label">{{ trans('messages.confirm_password') }}</label>
                        <input type="password" class="form-control @error('password_confirmation') is-invalid @enderror" id="password_confirmation" name="password_confirmation" minlength="6">
                        @error('password_confirmation')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-md-6">
                    <div class="mb-3">
                        <label for="role" class="form-label">{{ trans('messages.role') }} *</label>
                        <select class="form-select @error('role') is-invalid @enderror" id="role" name="role" required>
                            <option value="">{{ trans('messages.select_role') }}</option>
                            @foreach($roles as $role)
                                @if($role->name === 'Admin' && !auth()->user()->hasRole('Super Admin'))
                                    @continue
                                @endif
                                <option value="{{ $role->name }}" {{ old('role', $user->roles->first()?->name) == $role->name ? 'selected' : '' }}>{{ $role->name }}</option>
                            @endforeach
                        </select>
                        @error('role')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                        @if(!auth()->user()->hasRole('Super Admin'))
                            <small class="text-muted">{{ trans('messages.only_super_admin_can_assign_admin_role') }}</small>
                        @endif
                    </div>
                </div>

                <div class="col-md-6">
                    <div class="mb-3">
                        <label for="status" class="form-label">{{ trans('messages.status') }}</label>
                        <select class="form-select @error('status') is-invalid @enderror" id="status" name="status">
                            <option value="active" {{ old('status', $user->status) == 'active' ? 'selected' : '' }}>{{ trans('messages.active') }}</option>
                            <option value="inactive" {{ old('status', $user->status) == 'inactive' ? 'selected' : '' }}>{{ trans('messages.inactive') }}</option>
                        </select>
                        @error('status')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-md-6">
                    <div class="mb-3">
                        <label for="phone" class="form-label">{{ trans('messages.phone') }}</label>
                        <input type="text" class="form-control @error('phone') is-invalid @enderror" id="phone" name="phone" value="{{ old('phone', $user->phone) }}">
                        @error('phone')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>

                <div class="col-md-6">
                    <div class="mb-3">
                        <label for="avatar" class="form-label">{{ trans('messages.profile_picture') }}</label>
                        @if($user->avatar)
                            <div class="mb-2">
                                <img src="{{ storage_url( $user->avatar) }}" alt="{{ $user->name }}" class="rounded-circle" style="width: 64px; height: 64px; object-fit: cover;">
                            </div>
                        @endif
                        <input type="file" class="form-control @error('avatar') is-invalid @enderror" id="avatar" name="avatar" accept="image/*">
                        @error('avatar')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                        <small class="text-muted">{{ trans('messages.max_size') }}: 2MB (JPEG, PNG, JPG, GIF)</small>
                    </div>
                </div>
            </div>

            <div class="d-flex justify-content-between">
                <a href="{{ route('users.index') }}" class="btn btn-secondary">{{ trans('messages.cancel') }}</a>
                <button type="submit" class="btn btn-primary">{{ trans('messages.update') }}</button>
            </div>
        </form>
    </div>
</div>
@endsection

