@extends('layouts.master')

@section('title', trans('messages.warehouse_details'))

@section('content')
<div class="page-header">
    <h2>{{ trans('messages.warehouse') }}: {{ $warehouse->name }}</h2>
    <div>
        <a href="{{ route('warehouses.edit', $warehouse) }}" class="btn btn-warning"><i class="bi bi-pencil"></i> {{ trans('messages.edit') }}</a>
        <a href="{{ route('warehouses.index') }}" class="btn btn-secondary">{{ trans('messages.back') }}</a>
    </div>
</div>

<div class="row">
    <div class="col-md-4">
        <div class="card">
            <div class="card-body">
                <h5>{{ trans('messages.warehouse_details') }}</h5>
                <p><strong>{{ trans('messages.warehouse_name') }}:</strong> {{ $warehouse->name }}</p>
                @if($warehouse->name_ar)
                    <p><strong>{{ trans('messages.warehouse_name_ar') }}:</strong> {{ $warehouse->name_ar }}</p>
                @endif
                @if($warehouse->code)
                    <p><strong>{{ trans('messages.warehouse_code') }}:</strong> {{ $warehouse->code }}</p>
                @endif
                <p><strong>{{ trans('messages.warehouse_address') }}:</strong> {{ $warehouse->address ?? 'N/A' }}</p>
                <p><strong>{{ trans('messages.warehouse_phone') }}:</strong> {{ $warehouse->phone ?? 'N/A' }}</p>
                <p><strong>{{ trans('messages.is_default_warehouse') }}:</strong> 
                    @if($warehouse->is_default)
                        <span class="badge bg-primary">{{ trans('messages.yes') }}</span>
                    @else
                        <span class="badge bg-secondary">{{ trans('messages.no') }}</span>
                    @endif
                </p>
                <p><strong>{{ trans('messages.is_active_warehouse') }}:</strong> 
                    @if($warehouse->is_active)
                        <span class="badge bg-success">{{ trans('messages.active') }}</span>
                    @else
                        <span class="badge bg-danger">{{ trans('messages.inactive') }}</span>
                    @endif
                </p>
                <p><strong>{{ trans('messages.total_stock_value') }}:</strong> {{ format_currency($warehouse->total_stock_value) }}</p>
                <p><strong>{{ trans('messages.total_products_count') }}:</strong> {{ $warehouse->total_products_count }}</p>
                @if($warehouse->notes)
                    <p><strong>{{ trans('messages.warehouse_notes') }}:</strong> {{ $warehouse->notes }}</p>
                @endif
            </div>
        </div>
    </div>
    <div class="col-md-8">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0">{{ trans('messages.warehouse_stock') }}</h5>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table">
                        <thead>
                            <tr>
                                <th>{{ trans('messages.product') }}</th>
                                <th>{{ trans('messages.quantity') }}</th>
                                <th>{{ trans('messages.reorder_level') }}</th>
                                <th>{{ trans('messages.purchase_price') }}</th>
                                <th>{{ trans('messages.stock_value') }}</th>
                                <th>{{ trans('messages.status') }}</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse($warehouse->products as $product)
                            <tr>
                                <td><a href="{{ route('products.show', $product) }}">{{ $product->name }}</a></td>
                                <td>{{ $product->pivot->quantity }}</td>
                                <td>{{ $product->pivot->reorder_level }}</td>
                                <td>{{ format_currency($product->purchase_price) }}</td>
                                <td>{{ format_currency($product->pivot->quantity * $product->purchase_price) }}</td>
                                <td>
                                    @if($product->pivot->quantity <= $product->pivot->reorder_level)
                                        <span class="badge bg-warning">{{ trans('messages.low_stock') }}</span>
                                    @else
                                        <span class="badge bg-success">{{ trans('messages.in_stock') }}</span>
                                    @endif
                                </td>
                            </tr>
                            @empty
                            <tr>
                                <td colspan="6" class="text-center">{{ trans('messages.no_products_found') }}</td>
                            </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

