<?php

use App\Http\Controllers\Auth\AuthenticatedSessionController;
use App\Http\Controllers\Auth\PasswordResetLinkController;
use App\Http\Controllers\Auth\NewPasswordController;
use App\Http\Controllers\CategoryController;
use App\Http\Controllers\ChequeController;
use App\Http\Controllers\CustomerController;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\InvoiceController;
use App\Http\Controllers\LanguageController;
use App\Http\Controllers\PaymentController;
use App\Http\Controllers\ProductController;
use App\Http\Controllers\PromissoryNoteController;
use App\Http\Controllers\InventoryController;
use App\Http\Controllers\ReportController;
use App\Http\Controllers\SupplierController;
use App\Http\Controllers\SupplierPaymentController;
use App\Http\Controllers\PurchaseInvoiceController;
use App\Http\Controllers\SettingsController;
use App\Http\Controllers\TreasuryController;
use App\Http\Controllers\UserController;
use App\Http\Controllers\BackupController;
use App\Http\Controllers\UserGuideController;
use App\Http\Controllers\NotificationController;
use App\Http\Controllers\WarehouseController;
use App\Http\Controllers\WarehouseTransferController;
use App\Http\Controllers\ProductDefectController;
use App\Http\Controllers\QualityComplaintController;
use App\Http\Controllers\QualityReportController;
use Illuminate\Support\Facades\Route;

Route::get('/', function () {
    return redirect()->route('login');
});

Route::get('language/{locale}', [LanguageController::class, 'switch'])->name('language.switch');

// Route to serve storage files without symlink (for hosting without symlink support)
Route::get('storage/{path}', [\App\Http\Controllers\StorageController::class, 'serve'])
    ->where('path', '.*')
    ->name('storage.file');

// Routes للترخيص والفترة التجريبية (قبل middleware auth)
Route::get('trial/expired', [\App\Http\Controllers\TrialController::class, 'expired'])->name('trial.expired');
Route::get('trial/test', [\App\Http\Controllers\TrialController::class, 'test'])->name('trial.test');
Route::get('trial/reset', [\App\Http\Controllers\TrialController::class, 'reset'])->name('trial.reset');
Route::get('trial/check', [\App\Http\Controllers\TrialController::class, 'check'])->name('trial.check');

Route::prefix('license')->name('license.')->group(function () {
    Route::get('activate', [\App\Http\Controllers\LicenseController::class, 'showActivationForm'])->name('activate');
    Route::post('activate', [\App\Http\Controllers\LicenseController::class, 'activate']);
    Route::get('info', [\App\Http\Controllers\LicenseController::class, 'info'])->name('info');
});

Route::middleware('guest')->group(function () {
    Route::get('login', [AuthenticatedSessionController::class, 'create'])->name('login');
    Route::post('login', [AuthenticatedSessionController::class, 'store']);

    Route::get('forgot-password', [PasswordResetLinkController::class, 'create'])->name('password.request');
    Route::post('forgot-password', [PasswordResetLinkController::class, 'store'])->name('password.email');

    Route::get('reset-password/{token}', [NewPasswordController::class, 'create'])->name('password.reset');
    Route::post('reset-password', [NewPasswordController::class, 'store'])->name('password.update');
});

Route::middleware('auth')->group(function () {
    Route::post('logout', [AuthenticatedSessionController::class, 'destroy'])->name('logout');

    Route::get('/dashboard', [DashboardController::class, 'index'])->name('dashboard');

    // POS
    Route::prefix('pos')->name('pos.')->group(function () {
        Route::get('/', [\App\Http\Controllers\PosController::class, 'index'])->name('index');
        Route::get('products', [\App\Http\Controllers\PosController::class, 'getProducts'])->name('products');
        Route::get('search', [\App\Http\Controllers\PosController::class, 'search'])->name('search');
        Route::get('barcode', [\App\Http\Controllers\PosController::class, 'searchByBarcode'])->name('barcode');
        Route::get('print-ticket', [\App\Http\Controllers\PosController::class, 'printTicket'])->name('print-ticket');
        Route::post('cart/add', [\App\Http\Controllers\PosController::class, 'addToCart'])->name('cart.add');
        Route::post('cart/update', [\App\Http\Controllers\PosController::class, 'updateCart'])->name('cart.update');
        Route::post('cart/remove', [\App\Http\Controllers\PosController::class, 'removeFromCart'])->name('cart.remove');
        Route::post('cart/clear', [\App\Http\Controllers\PosController::class, 'clearCart'])->name('cart.clear');
        Route::post('cart/discount', [\App\Http\Controllers\PosController::class, 'updateCartDiscount'])->name('cart.discount');
        Route::post('cart/item/discount', [\App\Http\Controllers\PosController::class, 'updateItemDiscount'])->name('cart.item.discount');
        Route::post('cart/item/price', [\App\Http\Controllers\PosController::class, 'updateItemPrice'])->name('cart.item.price');
        Route::post('create-invoice', [\App\Http\Controllers\PosController::class, 'createInvoice'])->name('create-invoice');
        Route::get('customers/search', [\App\Http\Controllers\PosController::class, 'searchCustomers'])->name('customers.search');
        Route::post('customers/quick-add', [\App\Http\Controllers\PosController::class, 'quickAddCustomer'])->name('customers.quick-add');
        Route::get('stats/today', [\App\Http\Controllers\PosController::class, 'getTodayStats'])->name('stats.today');
        Route::get('products/recent', [\App\Http\Controllers\PosController::class, 'getRecentProducts'])->name('products.recent');
        Route::get('products/favorites', [\App\Http\Controllers\PosController::class, 'getFavoriteProducts'])->name('products.favorites');
        Route::post('products/toggle-favorite', [\App\Http\Controllers\PosController::class, 'toggleFavorite'])->name('products.toggle-favorite');
        Route::get('products/bundles', [\App\Http\Controllers\PosController::class, 'getProductBundles'])->name('products.bundles');
        Route::post('draft/save', [\App\Http\Controllers\PosController::class, 'saveDraft'])->name('draft.save');
        Route::post('draft/load', [\App\Http\Controllers\PosController::class, 'loadDraft'])->name('draft.load');
        Route::get('drafts', [\App\Http\Controllers\PosController::class, 'getDrafts'])->name('drafts');
    });

    // Products
    // Custom routes must be defined before resource routes to avoid conflicts
    Route::get('products/import', [ProductController::class, 'importForm'])->name('products.import');
    Route::post('products/import', [ProductController::class, 'import'])->name('products.import.post');
    Route::get('products/import/template', [ProductController::class, 'downloadTemplate'])->name('products.import.template');
    Route::get('products/export', [ProductController::class, 'export'])->name('products.export');
    Route::post('products/bulk-delete', [ProductController::class, 'bulkDelete'])->name('products.bulk_delete');
    Route::get('products/print/low-stock', [ProductController::class, 'printLowStock'])->name('products.print_low_stock');
    Route::post('products/check-sku', [ProductController::class, 'checkSku'])->name('products.check_sku');
    Route::get('products/reports', [ProductController::class, 'reports'])->name('products.reports');
    Route::resource('products', ProductController::class);

    // Inventories
    Route::get('inventories/{inventory}/print', [InventoryController::class, 'print'])->name('inventories.print');
    Route::post('inventories/{inventory}/complete', [InventoryController::class, 'complete'])->name('inventories.complete');
    Route::resource('inventories', InventoryController::class);

    // Categories
    Route::get('categories/import', [CategoryController::class, 'importForm'])->name('categories.import');
    Route::post('categories/import', [CategoryController::class, 'import'])->name('categories.import.post');
    Route::get('categories/import/template', [CategoryController::class, 'downloadTemplate'])->name('categories.import.template');
    Route::post('categories/bulk-delete', [CategoryController::class, 'bulkDelete'])->name('categories.bulk_delete');
    Route::post('categories/store-ajax', [CategoryController::class, 'store'])->name('categories.store.ajax');
    Route::resource('categories', CategoryController::class);

    // Suppliers
    Route::get('suppliers/import', [SupplierController::class, 'importForm'])->name('suppliers.import');
    Route::post('suppliers/import', [SupplierController::class, 'import'])->name('suppliers.import.post');
    Route::get('suppliers/import/template', [SupplierController::class, 'downloadTemplate'])->name('suppliers.import.template');
    Route::post('suppliers/bulk-delete', [SupplierController::class, 'bulkDelete'])->name('suppliers.bulk_delete');
    Route::get('suppliers/print/with-debts', [SupplierController::class, 'printWithDebts'])->name('suppliers.print-with-debts');
    Route::resource('suppliers', SupplierController::class);

    // Cheques
    Route::get('cheques/get-invoices/{customerId}', [ChequeController::class, 'getInvoices'])->name('cheques.get-invoices');
    Route::get('cheques/get-purchase-invoices/{supplierId}', [ChequeController::class, 'getPurchaseInvoices'])->name('cheques.get-purchase-invoices');
    Route::post('cheques/{cheque}/mark-as-paid', [ChequeController::class, 'markAsPaid'])->name('cheques.mark-as-paid');
    Route::post('cheques/{cheque}/mark-as-returned', [ChequeController::class, 'markAsReturned'])->name('cheques.mark-as-returned');
    Route::post('cheques/{cheque}/cancel', [ChequeController::class, 'cancel'])->name('cheques.cancel');
    Route::resource('cheques', ChequeController::class);

    // Promissory Notes
    Route::get('promissory-notes/get-invoices/{customerId}', [PromissoryNoteController::class, 'getInvoices'])->name('promissory-notes.get-invoices');
    Route::get('promissory-notes/get-purchase-invoices/{supplierId}', [PromissoryNoteController::class, 'getPurchaseInvoices'])->name('promissory-notes.get-purchase-invoices');
    Route::post('promissory-notes/{promissoryNote}/mark-as-paid', [PromissoryNoteController::class, 'markAsPaid'])->name('promissory-notes.mark-as-paid');
    Route::post('promissory-notes/{promissoryNote}/cancel', [PromissoryNoteController::class, 'cancel'])->name('promissory-notes.cancel');
    Route::resource('promissory-notes', PromissoryNoteController::class);

    // Customers
    Route::get('customers/import', [CustomerController::class, 'importForm'])->name('customers.import');
    Route::post('customers/import', [CustomerController::class, 'import'])->name('customers.import.post');
    Route::get('customers/import/template', [CustomerController::class, 'downloadTemplate'])->name('customers.import.template');
    Route::post('customers/bulk-delete', [CustomerController::class, 'bulkDelete'])->name('customers.bulk_delete');
    Route::get('customers/print/with-debts', [CustomerController::class, 'printWithDebts'])->name('customers.print-with-debts');
    Route::resource('customers', CustomerController::class);

    // Invoices
    // Custom routes must be defined before resource routes to avoid conflicts
    Route::get('invoices/import', [InvoiceController::class, 'importForm'])->name('invoices.import');
    Route::post('invoices/import', [InvoiceController::class, 'import'])->name('invoices.import.post');
    Route::get('invoices/import/template', [InvoiceController::class, 'downloadTemplate'])->name('invoices.import.template');
    Route::get('invoices/export', [InvoiceController::class, 'export'])->name('invoices.export');
    Route::get('invoices/{invoice}/pdf', [InvoiceController::class, 'pdf'])->name('invoices.pdf');
    Route::get('invoices/{invoice}/print', [InvoiceController::class, 'print'])->name('invoices.print');
    Route::get('invoices/{invoice}/devis', [InvoiceController::class, 'devis'])->name('invoices.devis');
    Route::get('invoices/{invoice}/bon-livraison', [InvoiceController::class, 'bonDeLivraison'])->name('invoices.bon-livraison');
    Route::post('invoices/{invoice}/finalize', [InvoiceController::class, 'finalize'])->name('invoices.finalize');
    Route::post('invoices/{invoice}/return', [InvoiceController::class, 'return'])->name('invoices.return');
    Route::post('invoices/{invoice}/send-email', [InvoiceController::class, 'sendEmail'])->name('invoices.send-email');
    Route::post('invoices/{invoice}/send-reminder', [InvoiceController::class, 'sendReminder'])->name('invoices.send-reminder');
    Route::post('invoices/{invoice}/convert-quotation-to-invoice', [InvoiceController::class, 'convertQuotationToInvoice'])->name('invoices.convert-quotation-to-invoice');
    Route::resource('invoices', InvoiceController::class);
    Route::post('invoices/bulk-delete', [InvoiceController::class, 'bulkDelete'])->name('invoices.bulk_delete');
    
    // Quotations (Draft Invoices)
    Route::get('quotations', [InvoiceController::class, 'quotations'])->name('quotations.index');
    Route::get('quotations/create', [InvoiceController::class, 'createQuotation'])->name('quotations.create');
    Route::post('quotations', [InvoiceController::class, 'storeQuotation'])->name('quotations.store');
    Route::get('quotations/{invoice}', [InvoiceController::class, 'showQuotation'])->name('quotations.show');
    Route::get('quotations/{invoice}/edit', [InvoiceController::class, 'editQuotation'])->name('quotations.edit');
    Route::put('quotations/{invoice}', [InvoiceController::class, 'updateQuotation'])->name('quotations.update');
    Route::delete('quotations/{invoice}', [InvoiceController::class, 'destroyQuotation'])->name('quotations.destroy');
    Route::post('quotations/bulk-delete', [InvoiceController::class, 'bulkDeleteQuotations'])->name('quotations.bulk-delete');

    // Payments
    Route::post('invoices/{invoice}/payments', [PaymentController::class, 'store'])->name('payments.store');
    Route::delete('payments/{payment}', [PaymentController::class, 'destroy'])->name('payments.destroy');

    // Purchase Invoices
    // Custom routes must be defined before resource routes to avoid conflicts
    Route::get('purchase-invoices/import', [PurchaseInvoiceController::class, 'importForm'])->name('purchase-invoices.import');
    Route::post('purchase-invoices/import', [PurchaseInvoiceController::class, 'import'])->name('purchase-invoices.import.post');
    Route::get('purchase-invoices/import/template', [PurchaseInvoiceController::class, 'downloadTemplate'])->name('purchase-invoices.import.template');
    Route::get('purchase-invoices/export', [PurchaseInvoiceController::class, 'export'])->name('purchase-invoices.export');
    Route::get('purchase-invoices/{purchaseInvoice}/pdf', [PurchaseInvoiceController::class, 'pdf'])->name('purchase-invoices.pdf');
    Route::get('purchase-invoices/{purchaseInvoice}/print', [PurchaseInvoiceController::class, 'print'])->name('purchase-invoices.print');
    Route::get('purchase-invoices/{purchaseInvoice}/bon-commande', [PurchaseInvoiceController::class, 'bonDeCommande'])->name('purchase-invoices.bon-commande');
    Route::post('purchase-invoices/{purchaseInvoice}/confirm', [PurchaseInvoiceController::class, 'confirm'])->name('purchase-invoices.confirm');
    Route::post('purchase-invoices/{purchaseInvoice}/return', [PurchaseInvoiceController::class, 'return'])->name('purchase-invoices.return');
    Route::resource('purchase-invoices', PurchaseInvoiceController::class);
    Route::post('purchase-invoices/bulk-delete', [PurchaseInvoiceController::class, 'bulkDelete'])->name('purchase-invoices.bulk_delete');

    // Supplier Payments
    Route::post('purchase-invoices/{purchaseInvoice}/payments', [SupplierPaymentController::class, 'store'])->name('supplier-payments.store');
    Route::delete('supplier-payments/{supplierPayment}', [SupplierPaymentController::class, 'destroy'])->name('supplier-payments.destroy');

    // Settings
    Route::get('settings', [SettingsController::class, 'index'])->name('settings.index');
    Route::post('settings/update', [SettingsController::class, 'update'])->name('settings.update');
    Route::post('settings/logo', [SettingsController::class, 'uploadLogo'])->name('settings.logo');

    // Profile
    Route::get('profile/settings', [\App\Http\Controllers\ProfileController::class, 'edit'])->name('profile.settings');
    Route::put('profile/update', [\App\Http\Controllers\ProfileController::class, 'updateProfile'])->name('profile.update');
    Route::put('profile/password/update', [\App\Http\Controllers\ProfileController::class, 'updatePassword'])->name('profile.password.update');

    // Reports
    Route::prefix('reports')->name('reports.')->group(function () {
        Route::get('/', function() {
            return view('reports.index');
        })->name('index');
        Route::get('sales', [ReportController::class, 'sales'])->name('sales');
        Route::get('sales/periodic', [ReportController::class, 'salesPeriodic'])->name('sales.periodic');
        Route::get('products', [ReportController::class, 'products'])->name('products');
        Route::get('profit', [ReportController::class, 'profit'])->name('profit');
        Route::get('stock', [ReportController::class, 'stock'])->name('stock');
        Route::get('cash-flow', [ReportController::class, 'cashFlow'])->name('cash-flow');
        Route::get('cash-flow/print', [ReportController::class, 'cashFlowPrint'])->name('cash-flow.print');
        Route::get('profit-loss', [ReportController::class, 'profitLoss'])->name('profit-loss');
        Route::get('profit-loss/print', [ReportController::class, 'profitLossPrint'])->name('profit-loss.print');
        Route::get('balance-sheet', [ReportController::class, 'balanceSheet'])->name('balance-sheet');
        Route::get('balance-sheet/print', [ReportController::class, 'balanceSheetPrint'])->name('balance-sheet.print');
        Route::get('cost-analysis', [ReportController::class, 'costAnalysis'])->name('cost-analysis');
        Route::get('cost-analysis/print', [ReportController::class, 'costAnalysisPrint'])->name('cost-analysis.print');
        Route::get('suppliers', [ReportController::class, 'suppliers'])->name('suppliers');
        Route::get('customers', [ReportController::class, 'customers'])->name('customers');
        Route::get('product-movement', [ReportController::class, 'productMovement'])->name('product-movement');
        Route::get('stagnant-products', [ReportController::class, 'stagnantProducts'])->name('stagnant-products');
        Route::get('warehouses', [ReportController::class, 'warehouses'])->name('warehouses');
        Route::get('sales/export', [ReportController::class, 'exportSales'])->name('sales.export');
        Route::get('sales/export/pdf', [ReportController::class, 'exportSalesPdf'])->name('sales.export_pdf');
    });

    // Analytics
    Route::prefix('analytics')->name('analytics.')->group(function () {
        Route::get('/', [\App\Http\Controllers\AnalyticsController::class, 'index'])->name('index');
        Route::get('sales-trends', [\App\Http\Controllers\AnalyticsController::class, 'salesTrends'])->name('sales-trends');
        Route::get('sales-forecast', [\App\Http\Controllers\AnalyticsController::class, 'salesForecast'])->name('sales-forecast');
        Route::get('profitability', [\App\Http\Controllers\AnalyticsController::class, 'profitability'])->name('profitability');
        Route::get('charts', [\App\Http\Controllers\AnalyticsController::class, 'charts'])->name('charts');
    });

    // Permissions Management
    Route::prefix('permissions')->name('permissions.')->group(function () {
        Route::get('/', [\App\Http\Controllers\PermissionController::class, 'index'])->name('index');
        Route::get('user/{user}', [\App\Http\Controllers\PermissionController::class, 'showUser'])->name('user');
        Route::post('user/{user}/roles', [\App\Http\Controllers\PermissionController::class, 'updateUserRoles'])->name('user.roles');
        Route::post('user/{user}/permissions', [\App\Http\Controllers\PermissionController::class, 'updateUserPermissions'])->name('user.permissions');
        Route::post('role', [\App\Http\Controllers\PermissionController::class, 'createRole'])->name('role.create');
        Route::post('role/{role}/permissions', [\App\Http\Controllers\PermissionController::class, 'updateRolePermissions'])->name('role.permissions');
        Route::delete('role/{role}', [\App\Http\Controllers\PermissionController::class, 'destroyRole'])->name('role.destroy');
        Route::post('permission', [\App\Http\Controllers\PermissionController::class, 'createPermission'])->name('permission.create');
        Route::delete('permission/{permission}', [\App\Http\Controllers\PermissionController::class, 'destroyPermission'])->name('permission.destroy');
    });

    // Activity Logs
    Route::prefix('activity-logs')->name('activity-logs.')->group(function () {
        Route::get('/', [\App\Http\Controllers\ActivityLogController::class, 'index'])->name('index');
        Route::get('{activityLog}', [\App\Http\Controllers\ActivityLogController::class, 'show'])->name('show');
        Route::delete('{activityLog}', [\App\Http\Controllers\ActivityLogController::class, 'destroy'])->name('destroy');
        Route::post('clear', [\App\Http\Controllers\ActivityLogController::class, 'clear'])->name('clear');
    });

    // Users (Admin and Super Admin)
    Route::resource('users', UserController::class);
    Route::post('users/{user}/reset-password', [UserController::class, 'resetPassword'])->name('users.reset_password');

    // Treasury
    Route::get('treasury/dashboard', [TreasuryController::class, 'dashboard'])->name('treasury.dashboard');
    Route::get('treasury/export', [TreasuryController::class, 'export'])->name('treasury.export');
    Route::get('treasury/export/pdf', [TreasuryController::class, 'exportPdf'])->name('treasury.export_pdf');
    Route::post('treasury/bulk-delete', [TreasuryController::class, 'bulkDelete'])->name('treasury.bulk_delete');
    Route::resource('treasury', TreasuryController::class);

    // Backups (Super Admin only)
    Route::prefix('backups')->name('backups.')->group(function () {
        Route::get('/', [BackupController::class, 'index'])->name('index');
        Route::post('/', [BackupController::class, 'store'])->name('store');
        Route::post('settings', [BackupController::class, 'updateSettings'])->name('settings');
        Route::post('restore/{filename}', [BackupController::class, 'restore'])->name('restore');
        Route::post('/export-sqlite', [BackupController::class, 'exportToSqlite'])->name('export-sqlite');
        Route::get('download/{filename}', [BackupController::class, 'download'])->name('download');
        Route::delete('{filename}', [BackupController::class, 'destroy'])->name('destroy');
    });

    // User Guide
    Route::prefix('user-guide')->name('user-guide.')->group(function () {
        Route::get('/', [UserGuideController::class, 'index'])->name('index');
        Route::get('{section}', [UserGuideController::class, 'show'])->name('show');
    });

    // Notifications
    Route::prefix('notifications')->name('notifications.')->group(function () {
        Route::get('/', [NotificationController::class, 'index'])->name('index');
        Route::get('unread-count', [NotificationController::class, 'unreadCount'])->name('unread-count');
        Route::post('generate', [NotificationController::class, 'generate'])->name('generate');
        Route::post('{notification}/read', [NotificationController::class, 'markAsRead'])->name('read');
        Route::post('read-all', [NotificationController::class, 'markAllAsRead'])->name('read-all');
        Route::delete('{notification}', [NotificationController::class, 'destroy'])->name('destroy');
    });

    // Documents Management
    Route::prefix('documents')->name('documents.')->group(function () {
        Route::get('/', [\App\Http\Controllers\DocumentController::class, 'index'])->name('index');
        Route::post('/', [\App\Http\Controllers\DocumentController::class, 'store'])->name('store');
        Route::get('{document}/download', [\App\Http\Controllers\DocumentController::class, 'download'])->name('download');
        Route::get('{document}/view', [\App\Http\Controllers\DocumentController::class, 'view'])->name('view');
        Route::delete('{document}', [\App\Http\Controllers\DocumentController::class, 'destroy'])->name('destroy');
    });

    // Stock Management
    Route::prefix('stock-alerts')->name('stock-alerts.')->group(function () {
        Route::get('/', [\App\Http\Controllers\StockAlertController::class, 'index'])->name('index');
        Route::post('{stockAlert}/acknowledge', [\App\Http\Controllers\StockAlertController::class, 'acknowledge'])->name('acknowledge');
        Route::post('{stockAlert}/resolve', [\App\Http\Controllers\StockAlertController::class, 'resolve'])->name('resolve');
        Route::delete('{stockAlert}', [\App\Http\Controllers\StockAlertController::class, 'destroy'])->name('destroy');
    });

    Route::resource('purchase-orders', \App\Http\Controllers\PurchaseOrderController::class);
    Route::post('purchase-orders/{purchaseOrder}/approve', [\App\Http\Controllers\PurchaseOrderController::class, 'approve'])->name('purchase-orders.approve');
    Route::post('purchase-orders/{purchaseOrder}/convert-to-invoice', [\App\Http\Controllers\PurchaseOrderController::class, 'convertToPurchaseInvoice'])->name('purchase-orders.convert-to-invoice');
    Route::post('purchase-orders/bulk-delete', [\App\Http\Controllers\PurchaseOrderController::class, 'bulkDelete'])->name('purchase-orders.bulk-delete');

    Route::resource('stock-takes', \App\Http\Controllers\StockTakeController::class);
    Route::post('stock-takes/{stockTake}/complete', [\App\Http\Controllers\StockTakeController::class, 'complete'])->name('stock-takes.complete');
    
    // Warehouses - Transfer routes must be before resource route
    Route::prefix('warehouses')->name('warehouses.')->group(function () {
        Route::get('transfer', [WarehouseTransferController::class, 'index'])->name('transfer.index');
        Route::post('transfer', [WarehouseTransferController::class, 'store'])->name('transfer.store');
    });
    Route::resource('warehouses', WarehouseController::class);

    // Quality Management
    Route::prefix('quality')->name('quality.')->group(function () {
        Route::resource('defects', ProductDefectController::class);
        Route::resource('complaints', QualityComplaintController::class);
        Route::get('reports', [QualityReportController::class, 'index'])->name('reports.index');
    });
});

