

<?php $__env->startSection('title', trans('messages.quality_reports')); ?>

<?php $__env->startSection('content'); ?>
<div class="page-header">
    <h2><?php echo e(trans('messages.quality_reports')); ?></h2>
    <div>
        <button onclick="window.print()" class="btn btn-primary">
            <i class="bi bi-printer"></i> <?php echo e(trans('messages.print_report')); ?>

        </button>
        <a href="<?php echo e(route('quality.defects.index')); ?>" class="btn btn-secondary">
            <i class="bi bi-arrow-left"></i> <?php echo e(trans('messages.back')); ?>

        </a>
    </div>
</div>

<form method="GET" action="<?php echo e(route('quality.reports.index')); ?>" class="card mb-4">
    <div class="card-body">
        <div class="row g-3">
            <div class="col-md-5">
                <label for="date_from" class="form-label"><?php echo e(trans('messages.date_from')); ?></label>
                <input type="date" class="form-control" id="date_from" name="date_from" value="<?php echo e($dateFrom); ?>">
            </div>
            <div class="col-md-5">
                <label for="date_to" class="form-label"><?php echo e(trans('messages.date_to')); ?></label>
                <input type="date" class="form-control" id="date_to" name="date_to" value="<?php echo e($dateTo); ?>">
            </div>
            <div class="col-md-2">
                <label class="form-label">&nbsp;</label>
                <button type="submit" class="btn btn-primary w-100"><?php echo e(trans('messages.filter')); ?></button>
            </div>
        </div>
    </div>
</form>

<!-- Defects Statistics -->
<div class="row g-3 mb-4">
    <div class="col-md-3">
        <div class="card text-white bg-danger">
            <div class="card-body">
                <h5><?php echo e(trans('messages.total_defects')); ?></h5>
                <h3><?php echo e($totalDefects); ?></h3>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card text-white bg-success">
            <div class="card-body">
                <h5><?php echo e(trans('messages.resolved_defects')); ?></h5>
                <h3><?php echo e($resolvedDefects); ?></h3>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card text-white bg-warning">
            <div class="card-body">
                <h5><?php echo e(trans('messages.critical_defects')); ?></h5>
                <h3><?php echo e($criticalDefects); ?></h3>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card text-white bg-info">
            <div class="card-body">
                <h5><?php echo e(trans('messages.avg_resolution_time')); ?></h5>
                <h3><?php echo e($avgResolutionTime && $avgResolutionTime->avg_days ? number_format($avgResolutionTime->avg_days, 1) : '0'); ?> <?php echo e(trans('messages.days')); ?></h3>
            </div>
        </div>
    </div>
</div>

<!-- Complaints Statistics -->
<div class="row g-3 mb-4">
    <div class="col-md-3">
        <div class="card text-white bg-primary">
            <div class="card-body">
                <h5><?php echo e(trans('messages.total_complaints')); ?></h5>
                <h3><?php echo e($totalComplaints); ?></h3>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card text-white bg-success">
            <div class="card-body">
                <h5><?php echo e(trans('messages.resolved_complaints')); ?></h5>
                <h3><?php echo e($resolvedComplaints); ?></h3>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card text-white bg-warning">
            <div class="card-body">
                <h5><?php echo e(trans('messages.critical_complaints')); ?></h5>
                <h3><?php echo e($criticalComplaints); ?></h3>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card text-white bg-info">
            <div class="card-body">
                <h5><?php echo e(trans('messages.avg_resolution_time')); ?></h5>
                <h3><?php echo e($avgComplaintResolutionTime && $avgComplaintResolutionTime->avg_days ? number_format($avgComplaintResolutionTime->avg_days, 1) : '0'); ?> <?php echo e(trans('messages.days')); ?></h3>
            </div>
        </div>
    </div>
</div>

<div class="row">
    <div class="col-md-6">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0"><?php echo e(trans('messages.defects_by_type')); ?></h5>
            </div>
            <div class="card-body">
                <table class="table">
                    <thead>
                        <tr>
                            <th><?php echo e(trans('messages.defect_type')); ?></th>
                            <th class="text-end"><?php echo e(trans('messages.count')); ?></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $defectsByType; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e(trans('messages.defect_type_' . $item->defect_type)); ?></td>
                            <td class="text-end"><?php echo e($item->count); ?></td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
    <div class="col-md-6">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0"><?php echo e(trans('messages.complaints_by_type')); ?></h5>
            </div>
            <div class="card-body">
                <table class="table">
                    <thead>
                        <tr>
                            <th><?php echo e(trans('messages.complaint_type')); ?></th>
                            <th class="text-end"><?php echo e(trans('messages.count')); ?></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $complaintsByType; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e(trans('messages.complaint_type_' . $item->complaint_type)); ?></td>
                            <td class="text-end"><?php echo e($item->count); ?></td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<div class="row mt-4">
    <div class="col-md-6">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0"><?php echo e(trans('messages.products_with_most_defects')); ?></h5>
            </div>
            <div class="card-body">
                <table class="table">
                    <thead>
                        <tr>
                            <th><?php echo e(trans('messages.product')); ?></th>
                            <th class="text-end"><?php echo e(trans('messages.defect_count')); ?></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $productsWithDefects; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td><?php echo e($item->product->name); ?></td>
                            <td class="text-end"><?php echo e($item->defect_count); ?></td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="2" class="text-center"><?php echo e(trans('messages.no_data')); ?></td>
                        </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
    <div class="col-md-6">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0"><?php echo e(trans('messages.products_with_most_complaints')); ?></h5>
            </div>
            <div class="card-body">
                <table class="table">
                    <thead>
                        <tr>
                            <th><?php echo e(trans('messages.product')); ?></th>
                            <th class="text-end"><?php echo e(trans('messages.complaint_count')); ?></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $productsWithComplaints; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td><?php echo e($item->product->name); ?></td>
                            <td class="text-end"><?php echo e($item->complaint_count); ?></td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="2" class="text-center"><?php echo e(trans('messages.no_data')); ?></td>
                        </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<?php echo $__env->make('reports.partials.print-styles', ['reportTitle' => trans('messages.quality_reports')], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\GestionStock\resources\views/quality/reports/index.blade.php ENDPATH**/ ?>