<?php $__env->startSection('title', trans('messages.settings')); ?>

<?php $__env->startSection('content'); ?>
<div class="page-header">
    <h2><?php echo e(trans('messages.settings')); ?></h2>
</div>

<div class="row">
    <div class="col-md-10">
        <form method="POST" action="<?php echo e(route('settings.update')); ?>" id="settingsForm">
            <?php echo csrf_field(); ?>
            
            <!-- Store Settings -->
            <div class="card mb-3" id="store-settings">
                <div class="card-header bg-primary text-white">
                    <h5 class="mb-0"><i class="bi bi-shop"></i> <?php echo e(trans('messages.store_settings')); ?></h5>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6 mb-3">
                        <label for="store_name" class="form-label"><?php echo e(trans('messages.store_name')); ?> *</label>
                        <input type="text" class="form-control <?php $__errorArgs = ['store_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="store_name" name="store_name" value="<?php echo e(old('store_name', $settings['store_name'])); ?>" required>
                        <?php $__errorArgs = ['store_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                        <div class="col-md-6 mb-3">
                        <label for="currency" class="form-label"><?php echo e(trans('messages.currency')); ?> *</label>
                        <input type="text" class="form-control <?php $__errorArgs = ['currency'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="currency" name="currency" value="<?php echo e(old('currency', $settings['currency'])); ?>" placeholder="$" required>
                        <small class="text-muted"><?php echo e(trans('messages.examples')); ?>: $, €, £, د.م, د.ج, ر.س</small>
                        <?php $__errorArgs = ['currency'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                    </div>
                    <div class="mb-3">
                        <label for="invoice_footer_text" class="form-label"><?php echo e(trans('messages.invoice_footer_text')); ?></label>
                        <textarea class="form-control <?php $__errorArgs = ['invoice_footer_text'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="invoice_footer_text" name="invoice_footer_text" rows="3"><?php echo e(old('invoice_footer_text', $settings['invoice_footer_text'])); ?></textarea>
                        <?php $__errorArgs = ['invoice_footer_text'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    <div class="mb-3">
                        <label for="items_per_page" class="form-label"><?php echo e(trans('messages.items_per_page')); ?> *</label>
                        <select class="form-select <?php $__errorArgs = ['items_per_page'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="items_per_page" name="items_per_page" required>
                            <?php
                                $currentItemsPerPage = (int)$settings['items_per_page'];
                            ?>
                            <option value="10" <?php echo e($currentItemsPerPage == 10 ? 'selected' : ''); ?>>10</option>
                            <option value="15" <?php echo e($currentItemsPerPage == 15 ? 'selected' : ''); ?>>15</option>
                            <option value="20" <?php echo e($currentItemsPerPage == 20 ? 'selected' : ''); ?>>20</option>
                            <option value="25" <?php echo e($currentItemsPerPage == 25 ? 'selected' : ''); ?>>25</option>
                            <option value="50" <?php echo e($currentItemsPerPage == 50 ? 'selected' : ''); ?>>50</option>
                            <option value="100" <?php echo e($currentItemsPerPage == 100 ? 'selected' : ''); ?>>100</option>
                        </select>
                        <small class="form-text text-muted"><?php echo e(trans('messages.items_per_page_description')); ?></small>
                        <?php $__errorArgs = ['items_per_page'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                </div>
            </div>

            <!-- POS Settings -->
            <div class="card mb-3" id="pos-settings">
                <div class="card-header bg-success text-white">
                    <h5 class="mb-0"><i class="bi bi-cart"></i> <?php echo e(trans('messages.pos_settings')); ?></h5>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-12 mb-3">
                            <div class="form-check form-switch">
                                <input class="form-check-input" type="checkbox" id="pos_enabled" name="pos_enabled" value="1" <?php echo e($settings['pos_enabled'] ? 'checked' : ''); ?>>
                                <label class="form-check-label" for="pos_enabled">
                                    <strong><?php echo e(trans('messages.pos_enabled')); ?></strong>
                                </label>
                            </div>
                            <small class="form-text text-muted"><?php echo e(trans('messages.pos_enabled_description')); ?></small>
                        </div>
                    </div>
                    <hr>
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <div class="form-check form-switch">
                                <input class="form-check-input" type="checkbox" id="pos_show_images" name="pos_show_images" value="1" <?php echo e($settings['pos_show_images'] ? 'checked' : ''); ?> <?php echo e(!$settings['pos_enabled'] ? 'disabled' : ''); ?>>
                                <label class="form-check-label" for="pos_show_images">
                                    <?php echo e(trans('messages.pos_show_images')); ?>

                                </label>
                            </div>
                        </div>
                        <div class="col-md-6 mb-3">
                            <div class="form-check form-switch">
                                <input class="form-check-input" type="checkbox" id="pos_show_stock" name="pos_show_stock" value="1" <?php echo e($settings['pos_show_stock'] ? 'checked' : ''); ?> <?php echo e(!$settings['pos_enabled'] ? 'disabled' : ''); ?>>
                                <label class="form-check-label" for="pos_show_stock">
                                    <?php echo e(trans('messages.pos_show_stock')); ?>

                                </label>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <div class="form-check form-switch">
                                <input class="form-check-input" type="checkbox" id="pos_auto_select_customer" name="pos_auto_select_customer" value="1" <?php echo e($settings['pos_auto_select_customer'] ? 'checked' : ''); ?> <?php echo e(!$settings['pos_enabled'] ? 'disabled' : ''); ?>>
                                <label class="form-check-label" for="pos_auto_select_customer">
                                    <?php echo e(trans('messages.pos_auto_select_customer')); ?>

                                </label>
                            </div>
                        </div>
                        <div class="col-md-6 mb-3">
                            <div class="form-check form-switch">
                                <input class="form-check-input" type="checkbox" id="pos_enable_discount" name="pos_enable_discount" value="1" <?php echo e($settings['pos_enable_discount'] ? 'checked' : ''); ?> <?php echo e(!$settings['pos_enabled'] ? 'disabled' : ''); ?>>
                                <label class="form-check-label" for="pos_enable_discount">
                                    <?php echo e(trans('messages.pos_enable_discount')); ?>

                                </label>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <div class="form-check form-switch">
                                <input class="form-check-input" type="checkbox" id="pos_enable_tax" name="pos_enable_tax" value="1" <?php echo e($settings['pos_enable_tax'] ? 'checked' : ''); ?> <?php echo e(!$settings['pos_enabled'] ? 'disabled' : ''); ?>>
                                <label class="form-check-label" for="pos_enable_tax">
                                    <?php echo e(trans('messages.pos_enable_tax')); ?>

                                </label>
                            </div>
                        </div>
                        <div class="col-md-6 mb-3">
                            <div class="form-check form-switch">
                                <input class="form-check-input" type="checkbox" id="pos_auto_print" name="pos_auto_print" value="1" <?php echo e($settings['pos_auto_print'] ? 'checked' : ''); ?> <?php echo e(!$settings['pos_enabled'] ? 'disabled' : ''); ?>>
                                <label class="form-check-label" for="pos_auto_print">
                                    <?php echo e(trans('messages.pos_auto_print')); ?>

                                </label>
                            </div>
                            <small class="form-text text-muted"><?php echo e(trans('messages.pos_auto_print_description')); ?></small>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <div class="form-check form-switch">
                                <input class="form-check-input" type="checkbox" id="pos_enable_fullscreen" name="pos_enable_fullscreen" value="1" <?php echo e($settings['pos_enable_fullscreen'] ? 'checked' : ''); ?> <?php echo e(!$settings['pos_enabled'] ? 'disabled' : ''); ?>>
                                <label class="form-check-label" for="pos_enable_fullscreen">
                                    <?php echo e(trans('messages.pos_enable_fullscreen')); ?>

                                </label>
                            </div>
                            <small class="form-text text-muted"><?php echo e(trans('messages.pos_enable_fullscreen_description')); ?></small>
                        </div>
                        <div class="col-md-6 mb-3">
                            <div class="form-check form-switch">
                                <input class="form-check-input" type="checkbox" id="pos_enable_sound" name="pos_enable_sound" value="1" <?php echo e($settings['pos_enable_sound'] ? 'checked' : ''); ?> <?php echo e(!$settings['pos_enabled'] ? 'disabled' : ''); ?>>
                                <label class="form-check-label" for="pos_enable_sound">
                                    <?php echo e(trans('messages.pos_enable_sound')); ?>

                                </label>
                            </div>
                            <small class="form-text text-muted"><?php echo e(trans('messages.pos_enable_sound_description')); ?></small>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <div class="form-check form-switch">
                                <input class="form-check-input" type="checkbox" id="pos_enable_payment" name="pos_enable_payment" value="1" <?php echo e($settings['pos_enable_payment'] ? 'checked' : ''); ?> <?php echo e(!$settings['pos_enabled'] ? 'disabled' : ''); ?>>
                                <label class="form-check-label" for="pos_enable_payment">
                                    <?php echo e(trans('messages.pos_enable_payment')); ?>

                                </label>
                            </div>
                            <small class="form-text text-muted"><?php echo e(trans('messages.pos_enable_payment_description')); ?></small>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label for="pos_products_per_page" class="form-label"><?php echo e(trans('messages.pos_products_per_page')); ?> *</label>
                            <select class="form-select" id="pos_products_per_page" name="pos_products_per_page" required <?php echo e(!$settings['pos_enabled'] ? 'disabled' : ''); ?>>
                                <option value="10" <?php echo e($settings['pos_products_per_page'] == 10 ? 'selected' : ''); ?>>10</option>
                                <option value="20" <?php echo e($settings['pos_products_per_page'] == 20 ? 'selected' : ''); ?>>20</option>
                                <option value="30" <?php echo e($settings['pos_products_per_page'] == 30 ? 'selected' : ''); ?>>30</option>
                                <option value="50" <?php echo e($settings['pos_products_per_page'] == 50 ? 'selected' : ''); ?>>50</option>
                            </select>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Dashboard Settings -->
            <div class="card mb-3" id="dashboard-settings">
                <div class="card-header bg-info text-white">
                    <h5 class="mb-0"><i class="bi bi-speedometer2"></i> <?php echo e(trans('messages.dashboard_settings')); ?></h5>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <div class="form-check form-switch">
                                <input class="form-check-input" type="checkbox" id="dashboard_show_sales_chart" name="dashboard_show_sales_chart" value="1" <?php echo e($settings['dashboard_show_sales_chart'] ? 'checked' : ''); ?>>
                                <label class="form-check-label" for="dashboard_show_sales_chart">
                                    <?php echo e(trans('messages.dashboard_show_sales_chart')); ?>

                                </label>
                            </div>
                        </div>
                        <div class="col-md-6 mb-3">
                            <div class="form-check form-switch">
                                <input class="form-check-input" type="checkbox" id="dashboard_show_low_stock" name="dashboard_show_low_stock" value="1" <?php echo e($settings['dashboard_show_low_stock'] ? 'checked' : ''); ?>>
                                <label class="form-check-label" for="dashboard_show_low_stock">
                                    <?php echo e(trans('messages.dashboard_show_low_stock')); ?>

                                </label>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <div class="form-check form-switch">
                                <input class="form-check-input" type="checkbox" id="dashboard_show_recent_invoices" name="dashboard_show_recent_invoices" value="1" <?php echo e($settings['dashboard_show_recent_invoices'] ? 'checked' : ''); ?>>
                                <label class="form-check-label" for="dashboard_show_recent_invoices">
                                    <?php echo e(trans('messages.dashboard_show_recent_invoices')); ?>

                                </label>
                            </div>
                        </div>
                        <div class="col-md-6 mb-3">
                            <div class="form-check form-switch">
                                <input class="form-check-input" type="checkbox" id="dashboard_show_quality" name="dashboard_show_quality" value="1" <?php echo e($settings['dashboard_show_quality'] ? 'checked' : ''); ?>>
                                <label class="form-check-label" for="dashboard_show_quality">
                                    <?php echo e(trans('messages.dashboard_show_quality')); ?>

                                </label>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <div class="form-check form-switch">
                                <input class="form-check-input" type="checkbox" id="menu_show_quality" name="menu_show_quality" value="1" <?php echo e($settings['menu_show_quality'] ? 'checked' : ''); ?>>
                                <label class="form-check-label" for="menu_show_quality">
                                    <?php echo e(trans('messages.menu_show_quality')); ?>

                                </label>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label for="dashboard_recent_invoices_count" class="form-label"><?php echo e(trans('messages.dashboard_recent_invoices_count')); ?> *</label>
                            <input type="number" class="form-control" id="dashboard_recent_invoices_count" name="dashboard_recent_invoices_count" value="<?php echo e($settings['dashboard_recent_invoices_count']); ?>" min="5" max="50" required>
                        </div>
                    </div>
                    <div class="mb-3">
                        <label for="dashboard_low_stock_count" class="form-label"><?php echo e(trans('messages.dashboard_low_stock_count')); ?> *</label>
                        <input type="number" class="form-control" id="dashboard_low_stock_count" name="dashboard_low_stock_count" value="<?php echo e($settings['dashboard_low_stock_count']); ?>" min="5" max="50" required>
                    </div>
                </div>
            </div>

            <!-- Product Management Settings -->
            <div class="card mb-3" id="product-settings">
                <div class="card-header bg-warning text-dark">
                    <h5 class="mb-0"><i class="bi bi-box-seam"></i> <?php echo e(trans('messages.product_management_settings')); ?></h5>
                </div>
                <div class="card-body">
                    <h6 class="mb-3"><?php echo e(trans('messages.sku_settings')); ?></h6>
                    <div class="row">
                        <div class="col-md-6 mb-3">
                        <label for="sku_generation_mode" class="form-label"><?php echo e(trans('messages.sku_generation_mode')); ?> *</label>
                        <select class="form-select <?php $__errorArgs = ['sku_generation_mode'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="sku_generation_mode" name="sku_generation_mode" required>
                            <option value="auto" <?php echo e($settings['sku_generation_mode'] == 'auto' ? 'selected' : ''); ?>><?php echo e(trans('messages.automatic')); ?></option>
                            <option value="manual" <?php echo e($settings['sku_generation_mode'] == 'manual' ? 'selected' : ''); ?>><?php echo e(trans('messages.manual')); ?></option>
                        </select>
                        <small class="form-text text-muted"><?php echo e(trans('messages.sku_generation_mode_description')); ?></small>
                        <?php $__errorArgs = ['sku_generation_mode'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                        <div class="col-md-6 mb-3" id="sku_prefix_container" style="display: <?php echo e($settings['sku_generation_mode'] == 'auto' ? 'block' : 'none'); ?>;">
                        <label for="sku_prefix" class="form-label"><?php echo e(trans('messages.sku_prefix')); ?></label>
                        <input type="text" class="form-control <?php $__errorArgs = ['sku_prefix'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="sku_prefix" name="sku_prefix" value="<?php echo e(old('sku_prefix', $settings['sku_prefix'])); ?>" placeholder="PROD-">
                        <small class="form-text text-muted"><?php echo e(trans('messages.sku_prefix_description')); ?></small>
                        <?php $__errorArgs = ['sku_prefix'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                    </div>
                    <hr>
                    <h6 class="mb-3"><?php echo e(trans('messages.barcode_settings')); ?></h6>
                    <div class="row">
                        <div class="col-md-6 mb-3">
                        <label for="barcode_format" class="form-label"><?php echo e(trans('messages.barcode_format')); ?> *</label>
                        <select class="form-select <?php $__errorArgs = ['barcode_format'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="barcode_format" name="barcode_format" required>
                            <option value="CODE128" <?php echo e($settings['barcode_format'] == 'CODE128' ? 'selected' : ''); ?>>CODE128</option>
                            <option value="EAN13" <?php echo e($settings['barcode_format'] == 'EAN13' ? 'selected' : ''); ?>>EAN13</option>
                            <option value="EAN8" <?php echo e($settings['barcode_format'] == 'EAN8' ? 'selected' : ''); ?>>EAN8</option>
                            <option value="CODE39" <?php echo e($settings['barcode_format'] == 'CODE39' ? 'selected' : ''); ?>>CODE39</option>
                            <option value="ITF14" <?php echo e($settings['barcode_format'] == 'ITF14' ? 'selected' : ''); ?>>ITF14</option>
                            <option value="MSI" <?php echo e($settings['barcode_format'] == 'MSI' ? 'selected' : ''); ?>>MSI</option>
                            <option value="pharmacode" <?php echo e($settings['barcode_format'] == 'pharmacode' ? 'selected' : ''); ?>>Pharmacode</option>
                            <option value="codabar" <?php echo e($settings['barcode_format'] == 'codabar' ? 'selected' : ''); ?>>Codabar</option>
                        </select>
                        <small class="form-text text-muted"><?php echo e(trans('messages.barcode_format_description')); ?></small>
                        <?php $__errorArgs = ['barcode_format'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                        <div class="col-md-6 mb-3">
                            <div class="form-check form-switch">
                            <input class="form-check-input" type="checkbox" id="show_product_name_in_barcode" name="show_product_name_in_barcode" value="1" <?php echo e($settings['show_product_name_in_barcode'] ? 'checked' : ''); ?>>
                            <label class="form-check-label" for="show_product_name_in_barcode">
                                <?php echo e(trans('messages.show_product_name_in_barcode')); ?>

                            </label>
                        </div>
                        <small class="form-text text-muted"><?php echo e(trans('messages.show_product_name_in_barcode_description')); ?></small>
                        </div>
                    </div>
                    <hr>
                    <h6 class="mb-3"><?php echo e(trans('messages.stock_settings')); ?></h6>
                    <div class="row">
                        <div class="col-md-6 mb-3">
                        <label for="warehouse_mode" class="form-label"><?php echo e(trans('messages.warehouse_mode')); ?> *</label>
                        <select class="form-select <?php $__errorArgs = ['warehouse_mode'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="warehouse_mode" name="warehouse_mode" required>
                            <option value="single" <?php echo e($settings['warehouse_mode'] == 'single' ? 'selected' : ''); ?>><?php echo e(trans('messages.single_warehouse')); ?></option>
                            <option value="multiple" <?php echo e($settings['warehouse_mode'] == 'multiple' ? 'selected' : ''); ?>><?php echo e(trans('messages.multiple_warehouses')); ?></option>
                        </select>
                        <small class="form-text text-muted"><?php echo e(trans('messages.warehouse_mode_description')); ?></small>
                        <?php $__errorArgs = ['warehouse_mode'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                        <div class="col-md-6 mb-3">
                            <div class="form-check form-switch">
                            <input class="form-check-input" type="checkbox" id="allow_negative_stock" name="allow_negative_stock" value="1" <?php echo e($settings['allow_negative_stock'] ? 'checked' : ''); ?>>
                            <label class="form-check-label" for="allow_negative_stock">
                                <?php echo e(trans('messages.allow_negative_stock')); ?>

                            </label>
                        </div>
                        <small class="form-text text-muted"><?php echo e(trans('messages.allow_negative_stock_description')); ?></small>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <div class="form-check form-switch">
                                <input class="form-check-input" type="checkbox" id="enable_batch_tracking" name="enable_batch_tracking" value="1" <?php echo e($settings['enable_batch_tracking'] ? 'checked' : ''); ?>>
                                <label class="form-check-label" for="enable_batch_tracking">
                                    <?php echo e(trans('messages.enable_batch_tracking')); ?>

                                </label>
                            </div>
                            <small class="form-text text-muted"><?php echo e(trans('messages.enable_batch_tracking_description')); ?></small>
                        </div>
                        <div class="col-md-6 mb-3">
                            <div class="form-check form-switch">
                                <input class="form-check-input" type="checkbox" id="auto_calculate_profit" name="auto_calculate_profit" value="1" <?php echo e($settings['auto_calculate_profit'] ? 'checked' : ''); ?>>
                                <label class="form-check-label" for="auto_calculate_profit">
                                    <?php echo e(trans('messages.auto_calculate_profit')); ?>

                                </label>
                            </div>
                            <small class="form-text text-muted"><?php echo e(trans('messages.auto_calculate_profit_description')); ?></small>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Invoice Settings -->
            <div class="card mb-3" id="invoice-settings">
                <div class="card-header bg-danger text-white">
                    <h5 class="mb-0"><i class="bi bi-receipt"></i> <?php echo e(trans('messages.invoice_settings')); ?></h5>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label for="invoice_number_format" class="form-label"><?php echo e(trans('messages.invoice_number_format')); ?></label>
                            <input type="text" class="form-control" id="invoice_number_format" name="invoice_number_format" value="<?php echo e($settings['invoice_number_format']); ?>" placeholder="INV-{YEAR}-{NUMBER}">
                            <small class="form-text text-muted"><?php echo e(trans('messages.invoice_number_format_help')); ?></small>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label for="invoice_default_status" class="form-label"><?php echo e(trans('messages.invoice_default_status')); ?> *</label>
                            <select class="form-select" id="invoice_default_status" name="invoice_default_status" required>
                                <option value="draft" <?php echo e($settings['invoice_default_status'] == 'draft' ? 'selected' : ''); ?>><?php echo e(trans('messages.draft')); ?></option>
                                <option value="final" <?php echo e($settings['invoice_default_status'] == 'final' ? 'selected' : ''); ?>><?php echo e(trans('messages.final')); ?></option>
                            </select>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-4 mb-3">
                            <div class="form-check form-switch">
                                <input class="form-check-input" type="checkbox" id="invoice_show_logo" name="invoice_show_logo" value="1" <?php echo e($settings['invoice_show_logo'] ? 'checked' : ''); ?>>
                                <label class="form-check-label" for="invoice_show_logo">
                                    <?php echo e(trans('messages.invoice_show_logo')); ?>

                                </label>
                            </div>
                        </div>
                        <div class="col-md-4 mb-3">
                            <div class="form-check form-switch">
                                <input class="form-check-input" type="checkbox" id="invoice_show_barcode" name="invoice_show_barcode" value="1" <?php echo e($settings['invoice_show_barcode'] ? 'checked' : ''); ?>>
                                <label class="form-check-label" for="invoice_show_barcode">
                                    <?php echo e(trans('messages.invoice_show_barcode')); ?>

                                </label>
                            </div>
                        </div>
                        <div class="col-md-4 mb-3">
                            <div class="form-check form-switch">
                                <input class="form-check-input" type="checkbox" id="invoice_auto_finalize" name="invoice_auto_finalize" value="1" <?php echo e($settings['invoice_auto_finalize'] ? 'checked' : ''); ?>>
                                <label class="form-check-label" for="invoice_auto_finalize">
                                    <?php echo e(trans('messages.invoice_auto_finalize')); ?>

                                </label>
                            </div>
                        </div>
                    </div>
                    <div class="mb-3">
                        <div class="form-check form-switch">
                            <input class="form-check-input" type="checkbox" id="invoice_send_email" name="invoice_send_email" value="1" <?php echo e($settings['invoice_send_email'] ? 'checked' : ''); ?>>
                            <label class="form-check-label" for="invoice_send_email">
                                <?php echo e(trans('messages.invoice_send_email')); ?>

                            </label>
                        </div>
                        <small class="form-text text-muted"><?php echo e(trans('messages.invoice_send_email_description')); ?></small>
                    </div>
                </div>
            </div>

            <!-- Purchase Invoice Settings -->
            <div class="card mb-3" id="purchase-invoice-settings">
                <div class="card-header bg-warning text-dark">
                    <h5 class="mb-0"><i class="bi bi-file-earmark-text"></i> <?php echo e(trans('messages.purchase_invoice_settings')); ?></h5>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label for="purchase_invoice_number_format" class="form-label"><?php echo e(trans('messages.purchase_invoice_number_format')); ?></label>
                            <input type="text" class="form-control" id="purchase_invoice_number_format" name="purchase_invoice_number_format" value="<?php echo e($settings['purchase_invoice_number_format']); ?>" placeholder="PINV-{YEAR}-{NUMBER}">
                            <small class="form-text text-muted"><?php echo e(trans('messages.invoice_number_format_help')); ?></small>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label for="purchase_invoice_default_status" class="form-label"><?php echo e(trans('messages.purchase_invoice_default_status')); ?> *</label>
                            <select class="form-select" id="purchase_invoice_default_status" name="purchase_invoice_default_status" required>
                                <option value="draft" <?php echo e($settings['purchase_invoice_default_status'] == 'draft' ? 'selected' : ''); ?>><?php echo e(trans('messages.draft')); ?></option>
                                <option value="confirmed" <?php echo e($settings['purchase_invoice_default_status'] == 'confirmed' ? 'selected' : ''); ?>><?php echo e(trans('messages.confirmed')); ?></option>
                            </select>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <div class="form-check form-switch">
                                <input class="form-check-input" type="checkbox" id="purchase_invoice_show_logo" name="purchase_invoice_show_logo" value="1" <?php echo e($settings['purchase_invoice_show_logo'] ? 'checked' : ''); ?>>
                                <label class="form-check-label" for="purchase_invoice_show_logo">
                                    <?php echo e(trans('messages.purchase_invoice_show_logo')); ?>

                                </label>
                            </div>
                        </div>
                        <div class="col-md-6 mb-3">
                            <div class="form-check form-switch">
                                <input class="form-check-input" type="checkbox" id="purchase_invoice_show_barcode" name="purchase_invoice_show_barcode" value="1" <?php echo e($settings['purchase_invoice_show_barcode'] ? 'checked' : ''); ?>>
                                <label class="form-check-label" for="purchase_invoice_show_barcode">
                                    <?php echo e(trans('messages.purchase_invoice_show_barcode')); ?>

                                </label>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Reports Settings -->
            <div class="card mb-3" id="reports-settings">
                <div class="card-header bg-secondary text-white">
                    <h5 class="mb-0"><i class="bi bi-graph-up"></i> <?php echo e(trans('messages.reports_settings')); ?></h5>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label for="reports_default_date_range" class="form-label"><?php echo e(trans('messages.reports_default_date_range')); ?> *</label>
                            <select class="form-select" id="reports_default_date_range" name="reports_default_date_range" required>
                                <option value="today" <?php echo e($settings['reports_default_date_range'] == 'today' ? 'selected' : ''); ?>><?php echo e(trans('messages.today')); ?></option>
                                <option value="week" <?php echo e($settings['reports_default_date_range'] == 'week' ? 'selected' : ''); ?>><?php echo e(trans('messages.week')); ?></option>
                                <option value="month" <?php echo e($settings['reports_default_date_range'] == 'month' ? 'selected' : ''); ?>><?php echo e(trans('messages.month')); ?></option>
                                <option value="quarter" <?php echo e($settings['reports_default_date_range'] == 'quarter' ? 'selected' : ''); ?>><?php echo e(trans('messages.quarter')); ?></option>
                                <option value="year" <?php echo e($settings['reports_default_date_range'] == 'year' ? 'selected' : ''); ?>><?php echo e(trans('messages.year')); ?></option>
                                <option value="custom" <?php echo e($settings['reports_default_date_range'] == 'custom' ? 'selected' : ''); ?>><?php echo e(trans('messages.custom')); ?></option>
                            </select>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label for="reports_export_format" class="form-label"><?php echo e(trans('messages.reports_export_format')); ?> *</label>
                            <select class="form-select" id="reports_export_format" name="reports_export_format" required>
                                <option value="excel" <?php echo e($settings['reports_export_format'] == 'excel' ? 'selected' : ''); ?>><?php echo e(trans('messages.excel')); ?></option>
                                <option value="pdf" <?php echo e($settings['reports_export_format'] == 'pdf' ? 'selected' : ''); ?>>PDF</option>
                            </select>
                        </div>
                    </div>
                    <div class="mb-3">
                        <div class="form-check form-switch">
                            <input class="form-check-input" type="checkbox" id="reports_show_charts" name="reports_show_charts" value="1" <?php echo e($settings['reports_show_charts'] ? 'checked' : ''); ?>>
                            <label class="form-check-label" for="reports_show_charts">
                                <?php echo e(trans('messages.reports_show_charts')); ?>

                            </label>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Backup Settings -->
            <div class="card mb-3" id="backup-settings">
                <div class="card-header bg-dark text-white">
                    <h5 class="mb-0"><i class="bi bi-database"></i> <?php echo e(trans('messages.backup_settings')); ?></h5>
                </div>
                <div class="card-body">
                    <div class="mb-3">
                        <div class="form-check form-switch">
                            <input class="form-check-input" type="checkbox" id="auto_backup_enabled" name="auto_backup_enabled" value="1" <?php echo e($settings['auto_backup_enabled'] ? 'checked' : ''); ?>>
                            <label class="form-check-label" for="auto_backup_enabled">
                                <?php echo e(trans('messages.enable_automatic_backup')); ?>

                            </label>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-4 mb-3">
                            <label for="auto_backup_frequency" class="form-label">
                                <?php echo e(trans('messages.backup_frequency')); ?>

                                <span class="backup-required-indicator" style="display: <?php echo e($settings['auto_backup_enabled'] ? 'inline' : 'none'); ?>;">*</span>
                            </label>
                            <select class="form-select" id="auto_backup_frequency" name="auto_backup_frequency" <?php echo e($settings['auto_backup_enabled'] ? 'required' : ''); ?> <?php echo e(!$settings['auto_backup_enabled'] ? 'disabled' : ''); ?>>
                                <option value="daily" <?php echo e($settings['auto_backup_frequency'] == 'daily' ? 'selected' : ''); ?>><?php echo e(trans('messages.daily')); ?></option>
                                <option value="weekly" <?php echo e($settings['auto_backup_frequency'] == 'weekly' ? 'selected' : ''); ?>><?php echo e(trans('messages.weekly')); ?></option>
                            </select>
                        </div>
                        <div class="col-md-4 mb-3">
                            <label for="auto_backup_time" class="form-label">
                                <?php echo e(trans('messages.backup_time')); ?>

                                <span class="backup-required-indicator" style="display: <?php echo e($settings['auto_backup_enabled'] ? 'inline' : 'none'); ?>;">*</span>
                            </label>
                            <input type="time" class="form-control" id="auto_backup_time" name="auto_backup_time" value="<?php echo e($settings['auto_backup_time']); ?>" <?php echo e($settings['auto_backup_enabled'] ? 'required' : ''); ?> <?php echo e(!$settings['auto_backup_enabled'] ? 'disabled' : ''); ?>>
                        </div>
                        <div class="col-md-4 mb-3">
                            <label for="backup_retention_days" class="form-label"><?php echo e(trans('messages.backup_retention_days')); ?> *</label>
                            <input type="number" class="form-control" id="backup_retention_days" name="backup_retention_days" value="<?php echo e($settings['backup_retention_days']); ?>" min="1" max="365" required>
                            <small class="form-text text-muted"><?php echo e(trans('messages.backup_retention_days_help')); ?></small>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Notification Settings -->
            <div class="card mb-3" id="notification-settings">
                <div class="card-header bg-warning text-dark">
                    <h5 class="mb-0"><i class="bi bi-bell"></i> <?php echo e(trans('messages.notification_settings')); ?></h5>
                </div>
                <div class="card-body">
                    <div class="mb-3">
                        <div class="form-check form-switch">
                            <input class="form-check-input" type="checkbox" id="notifications_enabled" name="notifications_enabled" value="1" <?php echo e($settings['notifications_enabled'] ? 'checked' : ''); ?>>
                            <label class="form-check-label" for="notifications_enabled">
                                <?php echo e(trans('messages.notifications_enabled')); ?>

                            </label>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <div class="form-check form-switch">
                                <input class="form-check-input" type="checkbox" id="notifications_low_stock" name="notifications_low_stock" value="1" <?php echo e($settings['notifications_low_stock'] ? 'checked' : ''); ?> <?php echo e(!$settings['notifications_enabled'] ? 'disabled' : ''); ?>>
                                <label class="form-check-label" for="notifications_low_stock">
                                    <?php echo e(trans('messages.notifications_low_stock')); ?>

                                </label>
                            </div>
                        </div>
                        <div class="col-md-6 mb-3">
                            <div class="form-check form-switch">
                                <input class="form-check-input" type="checkbox" id="notifications_pending_invoices" name="notifications_pending_invoices" value="1" <?php echo e($settings['notifications_pending_invoices'] ? 'checked' : ''); ?> <?php echo e(!$settings['notifications_enabled'] ? 'disabled' : ''); ?>>
                                <label class="form-check-label" for="notifications_pending_invoices">
                                    <?php echo e(trans('messages.notifications_pending_invoices')); ?>

                                </label>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Activity Logs Settings -->
            <div class="card mb-3" id="activity-logs-settings">
                <div class="card-header bg-info text-white">
                    <h5 class="mb-0"><i class="bi bi-clock-history"></i> <?php echo e(trans('messages.activity_logs_settings')); ?></h5>
                </div>
                <div class="card-body">
                    <div class="mb-3">
                        <label for="activity_logs_retention_days" class="form-label"><?php echo e(trans('messages.activity_logs_retention_days')); ?> *</label>
                        <input type="number" class="form-control <?php $__errorArgs = ['activity_logs_retention_days'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                               id="activity_logs_retention_days" 
                               name="activity_logs_retention_days" 
                               value="<?php echo e(old('activity_logs_retention_days', $settings['activity_logs_retention_days'])); ?>" 
                               min="0" 
                               max="365" 
                               required>
                        <small class="form-text text-muted"><?php echo e(trans('messages.activity_logs_retention_days_description')); ?></small>
                        <?php $__errorArgs = ['activity_logs_retention_days'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                </div>
            </div>

            <div class="text-end mb-4">
                <button type="submit" class="btn btn-primary btn-lg">
                    <i class="bi bi-save"></i> <?php echo e(trans('messages.save_settings')); ?>

                </button>
            </div>
        </form>
    </div>
    <div class="col-md-2">
        <div class="card sticky-top" style="top: 20px;">
            <div class="card-header">
                <h6 class="mb-0"><?php echo e(trans('messages.quick_navigation')); ?></h6>
            </div>
            <div class="card-body p-2">
                <nav class="nav flex-column">
                    <a class="nav-link" href="#store-settings"><?php echo e(trans('messages.store_settings')); ?></a>
                    <a class="nav-link" href="#pos-settings"><?php echo e(trans('messages.pos_settings')); ?></a>
                    <a class="nav-link" href="#dashboard-settings"><?php echo e(trans('messages.dashboard_settings')); ?></a>
                    <a class="nav-link" href="#product-settings"><?php echo e(trans('messages.product_management_settings')); ?></a>
                    <a class="nav-link" href="#invoice-settings"><?php echo e(trans('messages.invoice_settings')); ?></a>
                    <a class="nav-link" href="#reports-settings"><?php echo e(trans('messages.reports_settings')); ?></a>
                    <a class="nav-link" href="#backup-settings"><?php echo e(trans('messages.backup_settings')); ?></a>
                    <a class="nav-link" href="#notification-settings"><?php echo e(trans('messages.notification_settings')); ?></a>
                    <a class="nav-link" href="#activity-logs-settings"><?php echo e(trans('messages.activity_logs_settings')); ?></a>
                </nav>
            </div>
        </div>
    </div>
</div>

<div class="row">
    <div class="col-md-10">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0"><i class="bi bi-image"></i> <?php echo e(trans('messages.store_logo')); ?></h5>
            </div>
            <div class="card-body">
                <?php if($settings['store_logo']): ?>
                    <div class="mb-3 text-center">
                        <img src="<?php echo e(storage_url($settings['store_logo'])); ?>" alt="<?php echo e(trans('messages.store_logo')); ?>" class="img-fluid" style="max-height: 150px;">
                    </div>
                <?php endif; ?>
                <form method="POST" action="<?php echo e(route('settings.logo')); ?>" enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>
                    <div class="mb-3">
                        <label for="store_logo" class="form-label"><?php echo e(trans('messages.store_logo')); ?></label>
                        <input type="file" class="form-control <?php $__errorArgs = ['store_logo'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="store_logo" name="store_logo" accept="image/jpeg,image/jpg,image/png" required>
                        <small class="text-muted"><?php echo e(trans('messages.max_size')); ?>: 2MB</small>
                        <?php $__errorArgs = ['store_logo'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    <button type="submit" class="btn btn-primary w-100"><?php echo e(trans('messages.upload')); ?></button>
                </form>
            </div>
        </div>
    </div>
</div>

<!-- Add extra space at the bottom to prevent footer overlap -->
<div style="margin-bottom: 100px;"></div>

<?php $__env->startPush('scripts'); ?>
<script>
document.addEventListener('DOMContentLoaded', function() {
    // SKU Generation Mode
    const skuGenerationMode = document.getElementById('sku_generation_mode');
    const skuPrefixContainer = document.getElementById('sku_prefix_container');
    
    if (skuGenerationMode) {
    skuGenerationMode.addEventListener('change', function() {
        if (this.value === 'auto') {
            skuPrefixContainer.style.display = 'block';
        } else {
            skuPrefixContainer.style.display = 'none';
        }
    });
    }

    // Auto Backup Enabled
    const autoBackupEnabled = document.getElementById('auto_backup_enabled');
    const autoBackupFrequency = document.getElementById('auto_backup_frequency');
    const autoBackupTime = document.getElementById('auto_backup_time');
    const backupRequiredIndicators = document.querySelectorAll('.backup-required-indicator');
    
    if (autoBackupEnabled) {
        autoBackupEnabled.addEventListener('change', function() {
            const enabled = this.checked;
            autoBackupFrequency.disabled = !enabled;
            autoBackupTime.disabled = !enabled;
            
            // Toggle required attribute
            if (enabled) {
                autoBackupFrequency.setAttribute('required', 'required');
                autoBackupTime.setAttribute('required', 'required');
                backupRequiredIndicators.forEach(indicator => indicator.style.display = 'inline');
            } else {
                autoBackupFrequency.removeAttribute('required');
                autoBackupTime.removeAttribute('required');
                backupRequiredIndicators.forEach(indicator => indicator.style.display = 'none');
            }
        });
    }

    // Notifications Enabled
    const notificationsEnabled = document.getElementById('notifications_enabled');
    const notificationsLowStock = document.getElementById('notifications_low_stock');
    const notificationsPendingInvoices = document.getElementById('notifications_pending_invoices');
    
    if (notificationsEnabled) {
        notificationsEnabled.addEventListener('change', function() {
            const enabled = this.checked;
            notificationsLowStock.disabled = !enabled;
            notificationsPendingInvoices.disabled = !enabled;
        });
    }

    // POS Enabled
    const posEnabled = document.getElementById('pos_enabled');
    const posSettings = [
        'pos_show_images', 'pos_show_stock', 'pos_auto_select_customer',
        'pos_enable_discount', 'pos_enable_tax', 'pos_auto_print',
        'pos_enable_fullscreen', 'pos_enable_sound', 'pos_enable_payment',
        'pos_products_per_page'
    ];
    
    if (posEnabled) {
        posEnabled.addEventListener('change', function() {
            const enabled = this.checked;
            posSettings.forEach(settingId => {
                const element = document.getElementById(settingId);
                if (element) {
                    element.disabled = !enabled;
                }
            });
        });
    }

    // Smooth scroll for navigation
    document.querySelectorAll('a[href^="#"]').forEach(anchor => {
        anchor.addEventListener('click', function (e) {
            e.preventDefault();
            const target = document.querySelector(this.getAttribute('href'));
            if (target) {
                target.scrollIntoView({ behavior: 'smooth', block: 'start' });
            }
        });
    });

    // Remove disabled attribute before form submission
    const settingsForm = document.getElementById('settingsForm');
    if (settingsForm) {
        settingsForm.addEventListener('submit', function(e) {
            // Remove disabled attribute from all disabled fields so they can be submitted
            const disabledFields = this.querySelectorAll('[disabled]');
            disabledFields.forEach(field => {
                field.removeAttribute('disabled');
            });
        });
    }
});
</script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\GestionStock\resources\views/settings/index.blade.php ENDPATH**/ ?>