

<?php $__env->startSection('title', trans('messages.customers')); ?>

<?php $__env->startSection('content'); ?>
<?php
    $sort = request()->get('sort', 'created_at');
    $direction = request()->get('direction', 'desc');
?>
<div class="page-header">
    <h2><?php echo e(trans('messages.customers')); ?></h2>
    <div>
        <?php if(auth()->user()->hasAnyRole(['Admin', 'Super Admin'])): ?>
            <a href="<?php echo e(route('customers.import')); ?>" class="btn btn-success"><i class="bi bi-upload"></i> <?php echo e(trans('messages.import_customers')); ?></a>
        <?php endif; ?>
        <a href="<?php echo e(route('customers.create')); ?>" class="btn btn-primary"><i class="bi bi-plus-circle"></i> <?php echo e(trans('messages.add_customer')); ?></a>
        <?php if(request('filter') === 'with_debts'): ?>
            <a href="<?php echo e(route('customers.print-with-debts')); ?>" class="btn btn-info" target="_blank"><i class="bi bi-printer"></i> <?php echo e(trans('messages.print')); ?></a>
        <?php endif; ?>
    </div>
</div>

<div class="card">
    <div class="card-body">
        <form method="GET" action="<?php echo e(route('customers.index')); ?>" class="mb-3">
            <div class="row g-3">
                <div class="col-md-8">
                    <input type="text" name="search" class="form-control" placeholder="<?php echo e(trans('messages.search')); ?>..." value="<?php echo e(request('search')); ?>">
                </div>
                <div class="col-md-2">
                    <select name="filter" class="form-select">
                        <option value=""><?php echo e(trans('messages.all_customers')); ?></option>
                        <option value="with_debts" <?php echo e(request('filter') === 'with_debts' ? 'selected' : ''); ?>><?php echo e(trans('messages.customers_with_debts')); ?></option>
                    </select>
                </div>
                <div class="col-md-2">
                    <button type="submit" class="btn btn-secondary w-100"><?php echo e(trans('messages.search')); ?></button>
                </div>
            </div>
        </form>

        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('customers.bulk_delete')): ?>
        <div class="mb-3">
            <button type="button" id="delete-selected-btn" class="btn btn-danger" disabled data-bs-toggle="modal" data-bs-target="#bulkDeleteModal">
                <i class="bi bi-trash"></i> <?php echo e(trans('messages.delete_selected')); ?>

            </button>
        </div>
        <?php endif; ?>

        <div class="table-responsive">
            <table class="table table-hover">
                    <thead>
                        <tr>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('customers.bulk_delete')): ?>
                            <th style="width: 40px;">
                                <input type="checkbox" id="select-all" title="<?php echo e(trans('messages.select_all')); ?>">
                            </th>
                            <?php endif; ?>
                            <th>
                            <a href="<?php echo e(request()->fullUrlWithQuery(['sort' => 'name', 'direction' => ($sort === 'name' && $direction === 'asc') ? 'desc' : 'asc'])); ?>" class="text-decoration-none text-dark">
                                <?php echo e(trans('messages.name')); ?>

                                <?php if($sort === 'name'): ?>
                                    <i class="bi bi-arrow-<?php echo e($direction === 'asc' ? 'up' : 'down'); ?>"></i>
                                <?php else: ?>
                                    <i class="bi bi-arrow-down-up text-muted"></i>
                                <?php endif; ?>
                            </a>
                        </th>
                        <th>
                            <a href="<?php echo e(request()->fullUrlWithQuery(['sort' => 'email', 'direction' => ($sort === 'email' && $direction === 'asc') ? 'desc' : 'asc'])); ?>" class="text-decoration-none text-dark">
                                <?php echo e(trans('messages.email')); ?>

                                <?php if($sort === 'email'): ?>
                                    <i class="bi bi-arrow-<?php echo e($direction === 'asc' ? 'up' : 'down'); ?>"></i>
                                <?php else: ?>
                                    <i class="bi bi-arrow-down-up text-muted"></i>
                                <?php endif; ?>
                            </a>
                        </th>
                        <th>
                            <a href="<?php echo e(request()->fullUrlWithQuery(['sort' => 'phone', 'direction' => ($sort === 'phone' && $direction === 'asc') ? 'desc' : 'asc'])); ?>" class="text-decoration-none text-dark">
                                <?php echo e(trans('messages.phone')); ?>

                                <?php if($sort === 'phone'): ?>
                                    <i class="bi bi-arrow-<?php echo e($direction === 'asc' ? 'up' : 'down'); ?>"></i>
                                <?php else: ?>
                                    <i class="bi bi-arrow-down-up text-muted"></i>
                                <?php endif; ?>
                            </a>
                        </th>
                        <th><?php echo e(trans('messages.current_balance')); ?></th>
                        <th><?php echo e(trans('messages.actions')); ?></th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $customers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $customer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('customers.bulk_delete')): ?>
                        <td>
                            <input type="checkbox" class="item-checkbox" value="<?php echo e($customer->id); ?>">
                        </td>
                        <?php endif; ?>
                        <td><a href="<?php echo e(route('customers.show', $customer)); ?>"><?php echo e($customer->name); ?></a></td>
                        <td><?php echo e($customer->email ?? 'N/A'); ?></td>
                        <td><?php echo e($customer->phone ?? 'N/A'); ?></td>
                        <td>
                            <?php
                                $balance = $customer->calculated_balance ?? $customer->calculateCurrentBalance();
                            ?>
                            <span class="badge <?php echo e($balance <= 0 ? 'text-success bg-light' : 'text-danger bg-light'); ?>">
                                <?php echo e(format_currency($balance)); ?>

                            </span>
                        </td>
                        <td>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('customers.view')): ?>
                                <a href="<?php echo e(route('customers.show', $customer)); ?>" class="btn btn-sm btn-info" title="<?php echo e(trans('messages.view') ?? 'View'); ?>"><i class="bi bi-eye"></i></a>
                            <?php endif; ?>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('customers.update')): ?>
                                <a href="<?php echo e(route('customers.edit', $customer)); ?>" class="btn btn-sm btn-warning" title="<?php echo e(trans('messages.edit')); ?>"><i class="bi bi-pencil"></i></a>
                            <?php endif; ?>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('customers.delete')): ?>
                                <form action="<?php echo e(route('customers.destroy', $customer)); ?>" method="POST" class="d-inline delete-form">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('DELETE'); ?>
                                    <button type="submit" class="btn btn-sm btn-danger" title="<?php echo e(trans('messages.delete')); ?>" onclick="event.preventDefault(); confirmAction('<?php echo e(trans('messages.confirm_delete_customer')); ?>', '<?php echo e(trans('messages.confirm_delete')); ?>', () => this.closest('form').submit()); return false;"><i class="bi bi-trash"></i></button>
                                </form>
                            <?php endif; ?>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td colspan="<?php echo e(auth()->user()->can('customers.bulk_delete') ? '6' : '5'); ?>" class="text-center"><?php echo e(trans('messages.no_customers_found')); ?></td>
                    </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>

        <!-- Hidden form for bulk delete -->
        <form id="bulk-delete-form" method="POST" action="<?php echo e(route('customers.bulk_delete')); ?>" style="display: none;">
            <?php echo csrf_field(); ?>
        </form>

        <?php echo e($customers->links()); ?>

    </div>
</div>

<?php echo $__env->make('partials.bulk-delete-modal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\GestionStock\resources\views/customers/index.blade.php ENDPATH**/ ?>