

<?php $__env->startSection('title', trans('messages.users')); ?>

<?php $__env->startSection('content'); ?>
<?php
    $sort = request()->get('sort', 'created_at');
    $direction = request()->get('direction', 'desc');
?>
<div class="page-header">
    <h2><?php echo e(trans('messages.users')); ?></h2>
    <a href="<?php echo e(route('users.create')); ?>" class="btn btn-primary"><i class="bi bi-plus-circle"></i> <?php echo e(trans('messages.add_user')); ?></a>
</div>

<div class="card">
    <div class="card-body">
        <form method="GET" action="<?php echo e(route('users.index')); ?>" class="mb-3">
            <div class="row g-3">
                <div class="col-md-4">
                    <input type="text" name="search" class="form-control" placeholder="<?php echo e(trans('messages.search')); ?>..." value="<?php echo e(request('search')); ?>">
                </div>
                <div class="col-md-3">
                    <select name="status" class="form-select">
                        <option value=""><?php echo e(trans('messages.all_status')); ?></option>
                        <option value="active" <?php echo e(request('status') == 'active' ? 'selected' : ''); ?>><?php echo e(trans('messages.active')); ?></option>
                        <option value="inactive" <?php echo e(request('status') == 'inactive' ? 'selected' : ''); ?>><?php echo e(trans('messages.inactive')); ?></option>
                    </select>
                </div>
                <div class="col-md-3">
                    <select name="role" class="form-select">
                        <option value=""><?php echo e(trans('messages.all_roles')); ?></option>
                        <?php $__currentLoopData = $roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($role->name); ?>" <?php echo e(request('role') == $role->name ? 'selected' : ''); ?>><?php echo e($role->name); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                <div class="col-md-2">
                    <button type="submit" class="btn btn-secondary w-100"><?php echo e(trans('messages.filter')); ?></button>
                </div>
            </div>
        </form>

        <div class="table-responsive">
            <table class="table table-hover">
                <thead>
                    <tr>
                        <th>
                            <a href="<?php echo e(request()->fullUrlWithQuery(['sort' => 'name', 'direction' => ($sort === 'name' && $direction === 'asc') ? 'desc' : 'asc'])); ?>" class="text-decoration-none text-dark">
                                <?php echo e(trans('messages.name')); ?>

                                <?php if($sort === 'name'): ?>
                                    <i class="bi bi-arrow-<?php echo e($direction === 'asc' ? 'up' : 'down'); ?>"></i>
                                <?php else: ?>
                                    <i class="bi bi-arrow-down-up text-muted"></i>
                                <?php endif; ?>
                            </a>
                        </th>
                        <th>
                            <a href="<?php echo e(request()->fullUrlWithQuery(['sort' => 'email', 'direction' => ($sort === 'email' && $direction === 'asc') ? 'desc' : 'asc'])); ?>" class="text-decoration-none text-dark">
                                <?php echo e(trans('messages.email')); ?>

                                <?php if($sort === 'email'): ?>
                                    <i class="bi bi-arrow-<?php echo e($direction === 'asc' ? 'up' : 'down'); ?>"></i>
                                <?php else: ?>
                                    <i class="bi bi-arrow-down-up text-muted"></i>
                                <?php endif; ?>
                            </a>
                        </th>
                        <th><?php echo e(trans('messages.role')); ?></th>
                        <th><?php echo e(trans('messages.status')); ?></th>
                        <th><?php echo e(trans('messages.phone')); ?></th>
                        <th><?php echo e(trans('messages.actions')); ?></th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr>
                        <td>
                            <div class="d-flex align-items-center">
                                <?php if($user->avatar): ?>
                                    <img src="<?php echo e(storage_url( $user->avatar)); ?>" alt="<?php echo e($user->name); ?>" class="rounded-circle me-2" style="width: 32px; height: 32px; object-fit: cover;">
                                <?php else: ?>
                                    <div class="rounded-circle bg-secondary text-white d-flex align-items-center justify-content-center me-2" style="width: 32px; height: 32px; font-size: 14px;">
                                        <?php echo e(strtoupper(substr($user->name, 0, 1))); ?>

                                    </div>
                                <?php endif; ?>
                                <?php echo e($user->name); ?>

                            </div>
                        </td>
                        <td><?php echo e($user->email); ?></td>
                        <td>
                            <?php if($user->roles->count() > 0): ?>
                                <?php $__currentLoopData = $user->roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <span class="badge bg-primary"><?php echo e($role->name); ?></span>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php else: ?>
                                <span class="text-muted">-</span>
                            <?php endif; ?>
                        </td>
                        <td>
                            <span class="badge bg-<?php echo e($user->status === 'active' ? 'success' : 'secondary'); ?>">
                                <?php echo e(trans('messages.' . $user->status)); ?>

                            </span>
                        </td>
                        <td><?php echo e($user->phone ?? 'N/A'); ?></td>
                        <td>
                            <a href="<?php echo e(route('users.edit', $user)); ?>" class="btn btn-sm btn-warning" title="<?php echo e(trans('messages.edit')); ?>"><i class="bi bi-pencil"></i></a>
                            <button type="button" class="btn btn-sm btn-info" data-bs-toggle="modal" data-bs-target="#resetPasswordModal<?php echo e($user->id); ?>" title="<?php echo e(trans('messages.reset_password')); ?>">
                                <i class="bi bi-key"></i>
                            </button>
                            <form action="<?php echo e(route('users.destroy', $user)); ?>" method="POST" class="d-inline delete-form">
                                <?php echo csrf_field(); ?>
                                <?php echo method_field('DELETE'); ?>
                                <button type="submit" class="btn btn-sm btn-danger" title="<?php echo e(trans('messages.delete')); ?>" onclick="event.preventDefault(); confirmAction('<?php echo e(trans('messages.confirm_delete')); ?>', '<?php echo e(trans('messages.confirm_delete')); ?>', () => this.closest('form').submit()); return false;"><i class="bi bi-trash"></i></button>
                            </form>
                        </td>
                    </tr>

                    <!-- Reset Password Modal -->
                    <div class="modal fade" id="resetPasswordModal<?php echo e($user->id); ?>" tabindex="-1" aria-labelledby="resetPasswordModalLabel<?php echo e($user->id); ?>" aria-hidden="true">
                        <div class="modal-dialog">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title" id="resetPasswordModalLabel<?php echo e($user->id); ?>"><?php echo e(trans('messages.reset_password')); ?></h5>
                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                </div>
                                <form action="<?php echo e(route('users.reset_password', $user)); ?>" method="POST">
                                    <?php echo csrf_field(); ?>
                                    <div class="modal-body">
                                        <p><?php echo e(trans('messages.reset_password_for')); ?>: <strong><?php echo e($user->name); ?></strong></p>
                                        <div class="mb-3">
                                            <label for="password<?php echo e($user->id); ?>" class="form-label"><?php echo e(trans('messages.new_password')); ?> *</label>
                                            <input type="password" class="form-control" id="password<?php echo e($user->id); ?>" name="password" required minlength="6">
                                        </div>
                                        <div class="mb-3">
                                            <label for="password_confirmation<?php echo e($user->id); ?>" class="form-label"><?php echo e(trans('messages.confirm_password')); ?> *</label>
                                            <input type="password" class="form-control" id="password_confirmation<?php echo e($user->id); ?>" name="password_confirmation" required minlength="6">
                                        </div>
                                    </div>
                                    <div class="modal-footer">
                                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal"><?php echo e(trans('messages.cancel')); ?></button>
                                        <button type="submit" class="btn btn-primary"><?php echo e(trans('messages.reset_password')); ?></button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td colspan="6" class="text-center"><?php echo e(trans('messages.no_users_found')); ?></td>
                    </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
        <?php echo e($users->links()); ?>

    </div>
</div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\GestionStock\resources\views/users/index.blade.php ENDPATH**/ ?>