<?php
    $locale = app()->getLocale();
    $isRTL = $locale === 'ar';
    $dir = $isRTL ? 'rtl' : 'ltr';
    $lang = $locale;
    $storeName = \App\Models\Setting::get('store_name', 'Gestock Pro');
    $storeLogo = \App\Models\Setting::get('store_logo');
    $currency = \App\Models\Setting::get('currency', '$');
?>
<!DOCTYPE html>
<html lang="<?php echo e($lang); ?>" dir="<?php echo e($dir); ?>">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <title><?php echo $__env->yieldContent('title', $storeName); ?></title>
    
    <!-- Custom Fonts - Load both fonts for all languages -->
    <link rel="stylesheet" href="<?php echo e(asset('lib/fonts/google-fonts.css')); ?>">
    <!-- Bootstrap 5 CSS (RTL or LTR based on language) -->
    <?php if($isRTL): ?>
        <link href="<?php echo e(asset('lib/css/bootstrap.rtl.min.css')); ?>" rel="stylesheet">
    <?php else: ?>
        <link href="<?php echo e(asset('lib/css/bootstrap.min.css')); ?>" rel="stylesheet">
    <?php endif; ?>
    <!-- Bootstrap Icons -->
    <link rel="stylesheet" href="<?php echo e(asset('lib/icons/bootstrap-icons/bootstrap-icons.css')); ?>">
    <!-- Flag Icons -->
    <link rel="stylesheet" href="<?php echo e(asset('lib/icons/flag-icons/flag-icons.min.css')); ?>">
    <!-- Custom CSS -->
    <link rel="stylesheet" href="<?php echo e(asset('css/custom.css')); ?>">
    
    <?php echo $__env->yieldPushContent('styles'); ?>
</head>
<body>
    <?php if(auth()->guard()->check()): ?>
        <?php echo $__env->make('layouts.partials.navbar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php echo $__env->make('layouts.partials.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php endif; ?>

    <main class="<?php if(auth()->guard()->check()): ?> main-content <?php endif; ?>">
        <div class="container-fluid">
            <?php if(session('success')): ?>
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    <?php echo e(function_exists('translate_alert_message') ? translate_alert_message(session('success')) : session('success')); ?>

                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            <?php endif; ?>

            <?php if(session('error')): ?>
                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                    <?php echo e(function_exists('translate_alert_message') ? translate_alert_message(session('error')) : session('error')); ?>

                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            <?php endif; ?>

            <?php if($errors->any()): ?>
                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                    <ul class="mb-0">
                        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li><?php echo e($error); ?></li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            <?php endif; ?>

            <?php if(session('trial_warning')): ?>
                <div class="alert alert-warning alert-dismissible fade show" role="alert">
                    <i class="bi bi-exclamation-triangle"></i>
                    <strong>تنبيه:</strong> <?php echo e(session('trial_warning')['message']); ?>

                    <a href="<?php echo e(route('license.activate')); ?>" class="btn btn-sm btn-warning ms-2">
                        <i class="bi bi-key"></i> تفعيل الترخيص الآن
                    </a>
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            <?php endif; ?>

            <?php echo $__env->yieldContent('content'); ?>
        </div>
    </main>

    <!-- Footer -->
    <footer class="footer mt-auto bg-light border-top">
        <div class="container-fluid">
            <div class="row align-items-center justify-content-center">
                <div class="col-12 text-center">
                    <div class="footer-text">
                        <strong class="footer-brand">Gestock Pro</strong>
                        <span class="footer-version">v3.25.1</span>
                        <span class="mx-2">|</span>
                        <?php echo e(trans('messages.developed_by')); ?> 
                        <strong class="footer-company">ImraneSoft</strong> 
                        <?php echo e(trans('messages.since')); ?> 2012
                        <span class="mx-2">|</span>
                        <?php echo e(trans('messages.last_update')); ?> 21/01/2025
                    </div>
                </div>
            </div>
        </div>
    </footer>

    <!-- jQuery -->
    <script src="<?php echo e(asset('lib/js/jquery-3.7.0.min.js')); ?>"></script>
    <!-- Bootstrap 5 JS -->
    <script src="<?php echo e(asset('lib/js/bootstrap.bundle.min.js')); ?>"></script>
    <!-- Chart.js -->
    <script src="<?php echo e(asset('lib/js/chart.umd.min.js')); ?>"></script>
    <!-- Custom JS -->
    <script src="<?php echo e(asset('js/custom.js')); ?>"></script>
    
    <!-- Confirm Modal Helper -->
    <script>
        // Helper function to show confirm modal with translations
        function confirmAction(message, title, onConfirm, onCancel) {
            const defaultTitle = title || '<?php echo e(trans('messages.confirm')); ?>';
            const cancelText = '<?php echo e(trans('messages.cancel')); ?>';
            const confirmText = '<?php echo e(trans('messages.confirm')); ?>';
            
            showConfirmModal(message, defaultTitle, onConfirm, onCancel);
        }
    </script>
    
    <?php echo $__env->yieldPushContent('scripts'); ?>
</body>
</html>
<?php /**PATH C:\xampp\htdocs\GestionStock\resources\views/layouts/master.blade.php ENDPATH**/ ?>