

<?php $__env->startSection('title', trans('messages.profitability_analysis')); ?>

<?php $__env->startSection('content'); ?>
<div class="page-header">
    <h2><?php echo e(trans('messages.profitability_analysis')); ?></h2>
    <div>
        <button onclick="window.print()" class="btn btn-primary">
            <i class="bi bi-printer"></i> <?php echo e(trans('messages.print_report')); ?>

        </button>
        <a href="<?php echo e(route('analytics.index')); ?>" class="btn btn-secondary">
            <i class="bi bi-arrow-left"></i> <?php echo e(trans('messages.back')); ?>

        </a>
    </div>
</div>

<div class="card mb-3">
    <div class="card-body">
        <form method="GET" action="<?php echo e(route('analytics.profitability')); ?>">
            <div class="row g-3">
                <div class="col-md-4">
                    <label for="date_from" class="form-label"><?php echo e(trans('messages.from_date')); ?></label>
                    <input type="date" name="date_from" class="form-control" value="<?php echo e($dateFrom); ?>">
                </div>
                <div class="col-md-4">
                    <label for="date_to" class="form-label"><?php echo e(trans('messages.to_date')); ?></label>
                    <input type="date" name="date_to" class="form-control" value="<?php echo e($dateTo); ?>">
                </div>
                <div class="col-md-4">
                    <label class="form-label">&nbsp;</label>
                    <button type="submit" class="btn btn-primary w-100 d-block"><?php echo e(trans('messages.filter')); ?></button>
                </div>
            </div>
        </form>
    </div>
</div>

<div class="row g-3 mb-4">
    <div class="col-md-12">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0"><?php echo e(trans('messages.monthly_profitability')); ?></h5>
            </div>
            <div class="card-body">
                <canvas id="monthlyProfitabilityChart" height="80"></canvas>
            </div>
        </div>
    </div>
</div>

<div class="row g-3 mb-4">
    <div class="col-md-6">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0"><?php echo e(trans('messages.product_profitability')); ?></h5>
            </div>
            <div class="card-body">
                <canvas id="productProfitabilityChart" height="300"></canvas>
            </div>
        </div>
    </div>
    <div class="col-md-6">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0"><?php echo e(trans('messages.category_profitability')); ?></h5>
            </div>
            <div class="card-body">
                <canvas id="categoryProfitabilityChart" height="300"></canvas>
            </div>
        </div>
    </div>
</div>

<div class="row g-3">
    <div class="col-md-12">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0"><?php echo e(trans('messages.product_profitability')); ?></h5>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-striped">
                        <thead>
                            <tr>
                                <th><?php echo e(trans('messages.product')); ?></th>
                                <th class="text-end"><?php echo e(trans('messages.quantity_sold')); ?></th>
                                <th class="text-end"><?php echo e(trans('messages.total_revenue')); ?></th>
                                <th class="text-end"><?php echo e(trans('messages.total_cost')); ?></th>
                                <th class="text-end"><?php echo e(trans('messages.profit')); ?></th>
                                <th class="text-end"><?php echo e(trans('messages.profit_margin')); ?> %</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__empty_1 = true; $__currentLoopData = $productProfitability; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td>
                                    <a href="<?php echo e(route('products.show', $item['product']->id)); ?>">
                                        <?php echo e($item['product']->name); ?>

                                    </a>
                                </td>
                                <td class="text-end"><?php echo e($item['quantity']); ?></td>
                                <td class="text-end"><?php echo e(format_currency($item['revenue'])); ?></td>
                                <td class="text-end"><?php echo e(format_currency($item['cost'])); ?></td>
                                <td class="text-end <?php echo e($item['profit'] >= 0 ? 'text-success' : 'text-danger'); ?>">
                                    <?php echo e(format_currency($item['profit'])); ?>

                                </td>
                                <td class="text-end"><?php echo e(number_format($item['margin'], 2)); ?>%</td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="6" class="text-center"><?php echo e(trans('messages.no_data')); ?></td>
                            </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<?php $__env->startPush('scripts'); ?>
<script>
// Monthly Profitability Chart
const monthlyProfitabilityCtx = document.getElementById('monthlyProfitabilityChart').getContext('2d');
const monthlyProfitabilityChart = new Chart(monthlyProfitabilityCtx, {
    type: 'bar',
    data: {
        labels: <?php echo json_encode($monthlyLabels, 15, 512) ?>,
        datasets: [{
            label: '<?php echo e(trans('messages.total_revenue')); ?>',
            data: <?php echo json_encode($monthlyRevenue, 15, 512) ?>,
            backgroundColor: 'rgba(75, 192, 192, 0.6)'
        }, {
            label: '<?php echo e(trans('messages.total_cost')); ?>',
            data: <?php echo json_encode($monthlyCost, 15, 512) ?>,
            backgroundColor: 'rgba(255, 99, 132, 0.6)'
        }, {
            label: '<?php echo e(trans('messages.profit')); ?>',
            data: <?php echo json_encode($monthlyProfitData, 15, 512) ?>,
            backgroundColor: 'rgba(54, 162, 235, 0.6)'
        }]
    },
    options: {
        responsive: true,
        scales: {
            y: {
                beginAtZero: true
            }
        }
    }
});

// Product Profitability Chart (Top 10)
const topProducts = <?php echo json_encode($productProfitability->take(10)->values(), 15, 512) ?>;
const productProfitabilityCtx = document.getElementById('productProfitabilityChart').getContext('2d');
const productProfitabilityChart = new Chart(productProfitabilityCtx, {
    type: 'doughnut',
    data: {
        labels: topProducts.map(p => p.product.name),
        datasets: [{
            data: topProducts.map(p => p.profit),
            backgroundColor: [
                'rgba(255, 99, 132, 0.6)',
                'rgba(54, 162, 235, 0.6)',
                'rgba(255, 206, 86, 0.6)',
                'rgba(75, 192, 192, 0.6)',
                'rgba(153, 102, 255, 0.6)',
                'rgba(255, 159, 64, 0.6)',
                'rgba(199, 199, 199, 0.6)',
                'rgba(83, 102, 255, 0.6)',
                'rgba(255, 99, 255, 0.6)',
                'rgba(99, 255, 132, 0.6)'
            ]
        }]
    },
    options: {
        responsive: true,
        maintainAspectRatio: false
    }
});

// Category Profitability Chart
const categories = <?php echo json_encode($categoryProfitability->take(10)->values(), 15, 512) ?>;
const categoryProfitabilityCtx = document.getElementById('categoryProfitabilityChart').getContext('2d');
const categoryProfitabilityChart = new Chart(categoryProfitabilityCtx, {
    type: 'pie',
    data: {
        labels: categories.map(c => c.category ? c.category.name : '<?php echo e(trans('messages.uncategorized')); ?>'),
        datasets: [{
            data: categories.map(c => c.profit),
            backgroundColor: [
                'rgba(255, 99, 132, 0.6)',
                'rgba(54, 162, 235, 0.6)',
                'rgba(255, 206, 86, 0.6)',
                'rgba(75, 192, 192, 0.6)',
                'rgba(153, 102, 255, 0.6)',
                'rgba(255, 159, 64, 0.6)',
                'rgba(199, 199, 199, 0.6)',
                'rgba(83, 102, 255, 0.6)',
                'rgba(255, 99, 255, 0.6)',
                'rgba(99, 255, 132, 0.6)'
            ]
        }]
    },
    options: {
        responsive: true,
        maintainAspectRatio: false
    }
});
</script>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('styles'); ?>
<style>
@media print {
    .page-header, .card.mb-3:first-of-type, .btn {
        display: none !important;
    }
    .card {
        border: none;
        box-shadow: none;
    }
}
</style>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\GestionStock\resources\views/analytics/profitability.blade.php ENDPATH**/ ?>