

<?php $__env->startSection('title', trans('messages.stock_alerts')); ?>

<?php $__env->startSection('content'); ?>
<div class="page-header">
    <h2><?php echo e(trans('messages.stock_alerts')); ?></h2>
    <div>
        <a href="<?php echo e(route('stock-alerts.index', ['status' => 'pending'])); ?>" class="btn btn-warning">
            <i class="bi bi-exclamation-triangle"></i> <?php echo e(trans('messages.pending_alerts')); ?>

        </a>
    </div>
</div>

<div class="card">
    <div class="card-body">
        <form method="GET" action="<?php echo e(route('stock-alerts.index')); ?>" class="mb-3">
            <div class="row g-3">
                <div class="col-md-4">
                    <input type="text" name="search" class="form-control" placeholder="<?php echo e(trans('messages.search')); ?>..." value="<?php echo e(request('search')); ?>">
                </div>
                <div class="col-md-3">
                    <select name="status" class="form-select">
                        <option value=""><?php echo e(trans('messages.all_statuses')); ?></option>
                        <option value="pending" <?php echo e(request('status') == 'pending' ? 'selected' : ''); ?>><?php echo e(trans('messages.pending')); ?></option>
                        <option value="acknowledged" <?php echo e(request('status') == 'acknowledged' ? 'selected' : ''); ?>><?php echo e(trans('messages.acknowledged')); ?></option>
                        <option value="resolved" <?php echo e(request('status') == 'resolved' ? 'selected' : ''); ?>><?php echo e(trans('messages.resolved')); ?></option>
                    </select>
                </div>
                <div class="col-md-2">
                    <button type="submit" class="btn btn-secondary w-100"><?php echo e(trans('messages.filter')); ?></button>
                </div>
            </div>
        </form>

        <div class="table-responsive">
            <table class="table table-hover">
                <thead>
                    <tr>
                        <th><?php echo e(trans('messages.product')); ?></th>
                        <th><?php echo e(trans('messages.current_quantity')); ?></th>
                        <th><?php echo e(trans('messages.reorder_level')); ?></th>
                        <th><?php echo e(trans('messages.status')); ?></th>
                        <th><?php echo e(trans('messages.created_at')); ?></th>
                        <th><?php echo e(trans('messages.actions')); ?></th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $alerts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $alert): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr>
                        <td>
                            <strong><?php echo e($alert->product->name); ?></strong>
                            <?php if($alert->product->sku): ?>
                                <br><small class="text-muted"><?php echo e(trans('messages.sku')); ?>: <?php echo e($alert->product->sku); ?></small>
                            <?php endif; ?>
                        </td>
                        <td>
                            <span class="badge bg-<?php echo e($alert->current_quantity <= 0 ? 'danger' : 'warning'); ?>">
                                <?php echo e($alert->current_quantity); ?>

                            </span>
                        </td>
                        <td><?php echo e($alert->reorder_level); ?></td>
                        <td>
                            <?php
                                $badgeClass = match($alert->status) {
                                    'pending' => 'warning',
                                    'acknowledged' => 'info',
                                    'resolved' => 'success',
                                    default => 'secondary'
                                };
                            ?>
                            <span class="badge bg-<?php echo e($badgeClass); ?>"><?php echo e(trans('messages.' . $alert->status)); ?></span>
                        </td>
                        <td><?php echo e($alert->created_at->format('Y-m-d H:i')); ?></td>
                        <td>
                            <?php if($alert->status === 'pending'): ?>
                                <form action="<?php echo e(route('stock-alerts.acknowledge', $alert)); ?>" method="POST" class="d-inline">
                                    <?php echo csrf_field(); ?>
                                    <button type="submit" class="btn btn-sm btn-info"><?php echo e(trans('messages.acknowledge')); ?></button>
                                </form>
                                <form action="<?php echo e(route('stock-alerts.resolve', $alert)); ?>" method="POST" class="d-inline">
                                    <?php echo csrf_field(); ?>
                                    <button type="submit" class="btn btn-sm btn-success"><?php echo e(trans('messages.resolve')); ?></button>
                                </form>
                            <?php endif; ?>
                            <form action="<?php echo e(route('stock-alerts.destroy', $alert)); ?>" method="POST" class="d-inline" onsubmit="return confirm('<?php echo e(trans('messages.confirm_delete')); ?>')">
                                <?php echo csrf_field(); ?>
                                <?php echo method_field('DELETE'); ?>
                                <button type="submit" class="btn btn-sm btn-danger"><?php echo e(trans('messages.delete')); ?></button>
                            </form>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td colspan="6" class="text-center"><?php echo e(trans('messages.no_alerts_found')); ?></td>
                    </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>

        <div class="mt-3">
            <?php echo e($alerts->links()); ?>

        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\GestionStock\resources\views/stock-alerts/index.blade.php ENDPATH**/ ?>