

<?php $__env->startSection('title', trans('messages.all_movements')); ?>

<?php $__env->startSection('content'); ?>
<div class="page-header">
    <h2><?php echo e(trans('messages.all_movements')); ?></h2>
    <div>
        <a href="<?php echo e(route('treasury.dashboard')); ?>" class="btn btn-info"><i class="bi bi-speedometer2"></i> <?php echo e(trans('messages.treasury_dashboard')); ?></a>
        <?php if(auth()->user()->hasAnyRole(['Super Admin', 'Admin'])): ?>
            <a href="<?php echo e(route('treasury.create')); ?>" class="btn btn-success"><i class="bi bi-plus-circle"></i> <?php echo e(trans('messages.add_transaction')); ?></a>
        <?php endif; ?>
        <?php if(auth()->user()->hasAnyRole(['Super Admin', 'Admin', 'User'])): ?>
            <a href="<?php echo e(route('treasury.export', request()->query())); ?>" class="btn btn-primary"><i class="bi bi-download"></i> <?php echo e(trans('messages.export_excel')); ?></a>
            <a href="<?php echo e(route('treasury.export_pdf', request()->query())); ?>" class="btn btn-warning" target="_blank"><i class="bi bi-file-pdf"></i> <?php echo e(trans('messages.export_pdf')); ?></a>
        <?php endif; ?>
    </div>
</div>

<!-- Filters -->
<div class="card mb-3">
    <div class="card-body">
        <form method="GET" action="<?php echo e(route('treasury.index')); ?>" class="row g-3">
            <div class="col-md-2">
                <label for="start_date" class="form-label"><?php echo e(trans('messages.start_date')); ?></label>
                <input type="date" class="form-control" id="start_date" name="start_date" value="<?php echo e($startDate); ?>">
            </div>
            <div class="col-md-2">
                <label for="end_date" class="form-label"><?php echo e(trans('messages.end_date')); ?></label>
                <input type="date" class="form-control" id="end_date" name="end_date" value="<?php echo e($endDate); ?>">
            </div>
            <div class="col-md-2">
                <label for="type" class="form-label"><?php echo e(trans('messages.type')); ?></label>
                <select class="form-select" id="type" name="type">
                    <option value=""><?php echo e(trans('messages.all')); ?></option>
                    <option value="income" <?php echo e($type === 'income' ? 'selected' : ''); ?>><?php echo e(trans('messages.income')); ?></option>
                    <option value="expense" <?php echo e($type === 'expense' ? 'selected' : ''); ?>><?php echo e(trans('messages.expense')); ?></option>
                </select>
            </div>
            <div class="col-md-2">
                <label for="payment_method" class="form-label"><?php echo e(trans('messages.payment_method')); ?></label>
                <select class="form-select" id="payment_method" name="payment_method">
                    <option value=""><?php echo e(trans('messages.all')); ?></option>
                    <option value="cash" <?php echo e($paymentMethod === 'cash' ? 'selected' : ''); ?>><?php echo e(trans('messages.cash')); ?></option>
                    <option value="card" <?php echo e($paymentMethod === 'card' ? 'selected' : ''); ?>><?php echo e(trans('messages.card')); ?></option>
                    <option value="bank" <?php echo e($paymentMethod === 'bank' ? 'selected' : ''); ?>><?php echo e(trans('messages.bank')); ?></option>
                    <option value="other" <?php echo e($paymentMethod === 'other' ? 'selected' : ''); ?>><?php echo e(trans('messages.other')); ?></option>
                </select>
            </div>
            <div class="col-md-2">
                <label for="reference_type" class="form-label"><?php echo e(trans('messages.reference_type')); ?></label>
                <select class="form-select" id="reference_type" name="reference_type">
                    <option value=""><?php echo e(trans('messages.all')); ?></option>
                    <option value="sale_invoice" <?php echo e($referenceType === 'sale_invoice' ? 'selected' : ''); ?>><?php echo e(trans('messages.sale_invoice')); ?></option>
                    <option value="purchase_invoice" <?php echo e($referenceType === 'purchase_invoice' ? 'selected' : ''); ?>><?php echo e(trans('messages.purchase_invoice')); ?></option>
                    <option value="manual" <?php echo e($referenceType === 'manual' ? 'selected' : ''); ?>><?php echo e(trans('messages.manual')); ?></option>
                    <option value="supplier_payment" <?php echo e($referenceType === 'supplier_payment' ? 'selected' : ''); ?>><?php echo e(trans('messages.supplier_payment')); ?></option>
                    <option value="customer_payment" <?php echo e($referenceType === 'customer_payment' ? 'selected' : ''); ?>><?php echo e(trans('messages.customer_payment')); ?></option>
                    <option value="refund" <?php echo e($referenceType === 'refund' ? 'selected' : ''); ?>><?php echo e(trans('messages.refund')); ?></option>
                </select>
            </div>
            <div class="col-md-2 d-flex align-items-end">
                <button type="submit" class="btn btn-secondary w-100"><?php echo e(trans('messages.filter')); ?></button>
            </div>
        </form>
    </div>
</div>

<?php if(auth()->user()->hasAnyRole(['Super Admin', 'Admin'])): ?>
<div class="mb-3">
    <button type="button" id="delete-selected-btn" class="btn btn-danger" disabled>
        <i class="bi bi-trash"></i> <?php echo e(trans('messages.delete_selected')); ?>

    </button>
</div>
<?php endif; ?>

<div class="card">
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-hover">
                    <thead>
                        <tr>
                            <?php if(auth()->user()->hasAnyRole(['Super Admin', 'Admin'])): ?>
                            <th style="width: 40px;">
                                <input type="checkbox" id="select-all" title="<?php echo e(trans('messages.select_all')); ?>">
                            </th>
                            <?php endif; ?>
                            <th>
                                <a href="<?php echo e(request()->fullUrlWithQuery(['sort' => 'date', 'direction' => ($sort === 'date' && $direction === 'asc') ? 'desc' : 'asc'])); ?>" class="text-decoration-none text-dark">
                                    <?php echo e(trans('messages.date')); ?>

                                    <?php if($sort === 'date'): ?>
                                        <i class="bi bi-arrow-<?php echo e($direction === 'asc' ? 'up' : 'down'); ?>"></i>
                                    <?php else: ?>
                                        <i class="bi bi-arrow-down-up text-muted"></i>
                                    <?php endif; ?>
                                </a>
                            </th>
                            <th>
                                <a href="<?php echo e(request()->fullUrlWithQuery(['sort' => 'type', 'direction' => ($sort === 'type' && $direction === 'asc') ? 'desc' : 'asc'])); ?>" class="text-decoration-none text-dark">
                                    <?php echo e(trans('messages.type')); ?>

                                    <?php if($sort === 'type'): ?>
                                        <i class="bi bi-arrow-<?php echo e($direction === 'asc' ? 'up' : 'down'); ?>"></i>
                                    <?php else: ?>
                                        <i class="bi bi-arrow-down-up text-muted"></i>
                                    <?php endif; ?>
                                </a>
                            </th>
                            <th>
                                <a href="<?php echo e(request()->fullUrlWithQuery(['sort' => 'reference_type', 'direction' => ($sort === 'reference_type' && $direction === 'asc') ? 'desc' : 'asc'])); ?>" class="text-decoration-none text-dark">
                                    <?php echo e(trans('messages.reference_type')); ?>

                                    <?php if($sort === 'reference_type'): ?>
                                        <i class="bi bi-arrow-<?php echo e($direction === 'asc' ? 'up' : 'down'); ?>"></i>
                                    <?php else: ?>
                                        <i class="bi bi-arrow-down-up text-muted"></i>
                                    <?php endif; ?>
                                </a>
                            </th>
                            <th>
                                <a href="<?php echo e(request()->fullUrlWithQuery(['sort' => 'amount', 'direction' => ($sort === 'amount' && $direction === 'asc') ? 'desc' : 'asc'])); ?>" class="text-decoration-none text-dark">
                                    <?php echo e(trans('messages.amount')); ?>

                                    <?php if($sort === 'amount'): ?>
                                        <i class="bi bi-arrow-<?php echo e($direction === 'asc' ? 'up' : 'down'); ?>"></i>
                                    <?php else: ?>
                                        <i class="bi bi-arrow-down-up text-muted"></i>
                                    <?php endif; ?>
                                </a>
                            </th>
                            <th>
                                <a href="<?php echo e(request()->fullUrlWithQuery(['sort' => 'payment_method', 'direction' => ($sort === 'payment_method' && $direction === 'asc') ? 'desc' : 'asc'])); ?>" class="text-decoration-none text-dark">
                                    <?php echo e(trans('messages.payment_method')); ?>

                                    <?php if($sort === 'payment_method'): ?>
                                        <i class="bi bi-arrow-<?php echo e($direction === 'asc' ? 'up' : 'down'); ?>"></i>
                                    <?php else: ?>
                                        <i class="bi bi-arrow-down-up text-muted"></i>
                                    <?php endif; ?>
                                </a>
                            </th>
                            <th><?php echo e(trans('messages.description')); ?></th>
                            <th><?php echo e(trans('messages.created_by')); ?></th>
                            <?php if(auth()->user()->hasAnyRole(['Super Admin', 'Admin'])): ?>
                            <th><?php echo e(trans('messages.actions')); ?></th>
                            <?php endif; ?>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $treasuries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $treasury): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <?php if(auth()->user()->hasAnyRole(['Super Admin', 'Admin'])): ?>
                            <td>
                                <input type="checkbox" class="item-checkbox" value="<?php echo e($treasury->id); ?>">
                            </td>
                            <?php endif; ?>
                            <td><?php echo e($treasury->date ? \Carbon\Carbon::parse($treasury->date)->format('Y-m-d') : '-'); ?></td>
                            <td>
                                <span class="badge <?php echo e($treasury->type === 'income' ? 'bg-success' : 'bg-danger'); ?>">
                                    <?php echo e(trans('messages.' . $treasury->type)); ?>

                                </span>
                            </td>
                            <td><?php echo e(trans('messages.' . $treasury->reference_type)); ?></td>
                            <td><?php echo e(format_currency($treasury->amount)); ?></td>
                            <td><?php echo e(trans('messages.' . $treasury->payment_method)); ?></td>
                            <td><?php echo e($treasury->description ?? '-'); ?></td>
                            <td><?php echo e($treasury->creator->name ?? '-'); ?></td>
                            <?php if(auth()->user()->hasAnyRole(['Super Admin', 'Admin'])): ?>
                            <td>
                                <a href="<?php echo e(route('treasury.show', $treasury)); ?>" class="btn btn-sm btn-info" title="<?php echo e(trans('messages.view')); ?>"><i class="bi bi-eye"></i></a>
                                <a href="<?php echo e(route('treasury.edit', $treasury)); ?>" class="btn btn-sm btn-warning" title="<?php echo e(trans('messages.edit')); ?>"><i class="bi bi-pencil"></i></a>
                                <form action="<?php echo e(route('treasury.destroy', $treasury)); ?>" method="POST" class="d-inline delete-form">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('DELETE'); ?>
                                    <button type="submit" class="btn btn-sm btn-danger" title="<?php echo e(trans('messages.delete')); ?>" onclick="event.preventDefault(); confirmAction('<?php echo e(trans('messages.confirm_delete')); ?>', '<?php echo e(trans('messages.confirm_delete')); ?>', () => this.closest('form').submit()); return false;"><i class="bi bi-trash"></i></button>
                                </form>
                            </td>
                            <?php endif; ?>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="<?php echo e(auth()->user()->hasAnyRole(['Super Admin', 'Admin']) ? '9' : '7'); ?>" class="text-center"><?php echo e(trans('messages.no_data')); ?></td>
                        </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<!-- Hidden form for bulk delete -->
<form id="bulk-delete-form" method="POST" action="<?php echo e(route('treasury.bulk_delete')); ?>" style="display: none;">
    <?php echo csrf_field(); ?>
</form>

<?php echo e($treasuries->links()); ?>


<?php echo $__env->make('partials.bulk-delete-modal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\GestionStock\resources\views/treasury/index.blade.php ENDPATH**/ ?>