

<?php $__env->startSection('title', trans('messages.sales_forecast')); ?>

<?php $__env->startSection('content'); ?>
<div class="page-header">
    <h2><?php echo e(trans('messages.sales_forecast')); ?></h2>
    <div>
        <button onclick="window.print()" class="btn btn-primary">
            <i class="bi bi-printer"></i> <?php echo e(trans('messages.print_report')); ?>

        </button>
        <a href="<?php echo e(route('analytics.index')); ?>" class="btn btn-secondary">
            <i class="bi bi-arrow-left"></i> <?php echo e(trans('messages.back')); ?>

        </a>
    </div>
</div>

<div class="card mb-3">
    <div class="card-body">
        <form method="GET" action="<?php echo e(route('analytics.sales-forecast')); ?>">
            <div class="row g-3">
                <div class="col-md-4">
                    <label for="months" class="form-label"><?php echo e(trans('messages.months')); ?> (<?php echo e(trans('messages.historical_data')); ?>)</label>
                    <input type="number" name="months" class="form-control" value="<?php echo e($months); ?>" min="3" max="24">
                </div>
                <div class="col-md-4">
                    <label for="forecast_periods" class="form-label"><?php echo e(trans('messages.forecast_periods')); ?></label>
                    <input type="number" name="forecast_periods" class="form-control" value="<?php echo e($forecastPeriods); ?>" min="1" max="12">
                </div>
                <div class="col-md-4">
                    <label class="form-label">&nbsp;</label>
                    <button type="submit" class="btn btn-primary w-100 d-block"><?php echo e(trans('messages.filter')); ?></button>
                </div>
            </div>
        </form>
    </div>
</div>

<div class="row g-3 mb-4">
    <div class="col-md-12">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0"><?php echo e(trans('messages.sales_forecast')); ?></h5>
            </div>
            <div class="card-body">
                <canvas id="salesForecastChart" height="80"></canvas>
            </div>
        </div>
    </div>
</div>

<div class="row g-3 mb-4">
    <div class="col-md-12">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0"><?php echo e(trans('messages.invoice_count')); ?> <?php echo e(trans('messages.forecast')); ?></h5>
            </div>
            <div class="card-body">
                <canvas id="countForecastChart" height="80"></canvas>
            </div>
        </div>
    </div>
</div>

<?php $__env->startPush('scripts'); ?>
<script>
const allLabels = <?php echo json_encode(array_merge($labels, $forecastLabels), 512) ?>;
const allSales = <?php echo json_encode(array_merge($salesValues, $forecastSales), 512) ?>;
const allCounts = <?php echo json_encode(array_merge($countValues, $forecastCount), 512) ?>;
const historicalLength = <?php echo e(count($labels)); ?>;

const salesForecastCtx = document.getElementById('salesForecastChart').getContext('2d');
const salesForecastChart = new Chart(salesForecastCtx, {
    type: 'line',
    data: {
        labels: allLabels,
        datasets: [{
            label: '<?php echo e(trans('messages.historical_data')); ?>',
            data: allSales.map((v, i) => i < historicalLength ? v : null),
            borderColor: 'rgb(75, 192, 192)',
            backgroundColor: 'rgba(75, 192, 192, 0.2)',
            tension: 0.1
        }, {
            label: '<?php echo e(trans('messages.forecasted_data')); ?>',
            data: allSales.map((v, i) => i >= historicalLength ? v : null),
            borderColor: 'rgb(255, 99, 132)',
            backgroundColor: 'rgba(255, 99, 132, 0.2)',
            borderDash: [5, 5],
            tension: 0.1
        }]
    },
    options: {
        responsive: true,
        scales: {
            y: {
                beginAtZero: true
            }
        }
    }
});

const countForecastCtx = document.getElementById('countForecastChart').getContext('2d');
const countForecastChart = new Chart(countForecastCtx, {
    type: 'line',
    data: {
        labels: allLabels,
        datasets: [{
            label: '<?php echo e(trans('messages.historical_data')); ?>',
            data: allCounts.map((v, i) => i < historicalLength ? v : null),
            borderColor: 'rgb(54, 162, 235)',
            backgroundColor: 'rgba(54, 162, 235, 0.2)',
            tension: 0.1
        }, {
            label: '<?php echo e(trans('messages.forecasted_data')); ?>',
            data: allCounts.map((v, i) => i >= historicalLength ? v : null),
            borderColor: 'rgb(255, 159, 64)',
            backgroundColor: 'rgba(255, 159, 64, 0.2)',
            borderDash: [5, 5],
            tension: 0.1
        }]
    },
    options: {
        responsive: true,
        scales: {
            y: {
                beginAtZero: true
            }
        }
    }
});
</script>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('styles'); ?>
<style>
@media print {
    .page-header, .card.mb-3:first-of-type, .btn {
        display: none !important;
    }
    .card {
        border: none;
        box-shadow: none;
    }
}
</style>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\GestionStock\resources\views/analytics/sales-forecast.blade.php ENDPATH**/ ?>