

<?php $__env->startSection('title', trans('messages.user_guide_title')); ?>

<?php $__env->startSection('content'); ?>
<div class="page-header">
    <h2><i class="bi bi-book"></i> <?php echo e(trans('messages.user_guide_title')); ?></h2>
</div>

<div class="card mb-3">
    <div class="card-body">
        <form method="GET" action="<?php echo e(route('user-guide.index')); ?>" class="row g-3">
            <div class="col-md-6">
                <label for="search" class="form-label"><?php echo e(trans('messages.search')); ?></label>
                <input type="text" class="form-control" id="search" name="search" value="<?php echo e($search); ?>" placeholder="<?php echo e(trans('messages.search_placeholder')); ?>">
            </div>
            <div class="col-md-4">
                <label for="category" class="form-label"><?php echo e(trans('messages.category')); ?></label>
                <select class="form-select" id="category" name="category">
                    <option value=""><?php echo e(trans('messages.all_categories')); ?></option>
                    <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $name): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($key); ?>" <?php echo e($selectedCategory === $key ? 'selected' : ''); ?>><?php echo e($name); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
            <div class="col-md-2 d-flex align-items-end">
                <button type="submit" class="btn btn-primary w-100"><?php echo e(trans('messages.filter')); ?></button>
            </div>
        </form>
    </div>
</div>

<div class="card">
    <div class="card-header">
        <h5 class="mb-0">
            <i class="bi bi-question-circle"></i> <?php echo e(trans('messages.frequently_asked_questions')); ?>

            <?php if(count($faqs) > 0): ?>
                <span class="badge bg-primary ms-2"><?php echo e(count($faqs)); ?></span>
            <?php endif; ?>
        </h5>
    </div>
    <div class="card-body">
        <?php if(count($faqs) > 0): ?>
            <div class="accordion" id="faqAccordion">
                <?php $__currentLoopData = $faqs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $faq): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="accordion-item">
                        <h2 class="accordion-header" id="heading<?php echo e($faq['id']); ?>">
                            <button class="accordion-button <?php echo e($index === 0 ? '' : 'collapsed'); ?>" type="button" data-bs-toggle="collapse" data-bs-target="#collapse<?php echo e($faq['id']); ?>" aria-expanded="<?php echo e($index === 0 ? 'true' : 'false'); ?>" aria-controls="collapse<?php echo e($faq['id']); ?>">
                                <i class="bi bi-question-circle-fill text-primary me-2"></i>
                                <?php echo e($faq['question']); ?>

                            </button>
                        </h2>
                        <div id="collapse<?php echo e($faq['id']); ?>" class="accordion-collapse collapse <?php echo e($index === 0 ? 'show' : ''); ?>" aria-labelledby="heading<?php echo e($faq['id']); ?>" data-bs-parent="#faqAccordion">
                            <div class="accordion-body">
                                <div class="d-flex align-items-start mb-2">
                                    <i class="bi bi-info-circle-fill text-info me-2 mt-1"></i>
                                    <div class="flex-grow-1">
                                        <?php echo nl2br(e($faq['answer'])); ?>

                                    </div>
                                </div>
                                <small class="text-muted">
                                    <i class="bi bi-tag"></i> <?php echo e($categories[$faq['category']] ?? $faq['category']); ?>

                                </small>
                            </div>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        <?php else: ?>
            <div class="text-center py-5">
                <i class="bi bi-search text-muted" style="font-size: 3rem;"></i>
                <p class="text-muted mt-3"><?php echo e(trans('messages.no_faqs_found')); ?></p>
                <?php if($search || $selectedCategory): ?>
                    <a href="<?php echo e(route('user-guide.index')); ?>" class="btn btn-primary"><?php echo e(trans('messages.show_all_faqs')); ?></a>
                <?php endif; ?>
            </div>
        <?php endif; ?>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\GestionStock\resources\views/user-guide/index.blade.php ENDPATH**/ ?>