<?php $__env->startSection('title', trans('messages.database_backup')); ?>

<?php $__env->startSection('content'); ?>
<div class="page-header">
    <h2><?php echo e(trans('messages.database_backup')); ?></h2>
    <div>
        <form action="<?php echo e(route('backups.store')); ?>" method="POST" class="d-inline">
            <?php echo csrf_field(); ?>
            <button type="submit" class="btn btn-success">
                <i class="bi bi-database-add"></i> <?php echo e(trans('messages.create_backup_now')); ?>

            </button>
        </form>
        
    </div>
</div>

<!-- Stats Cards -->
<div class="row g-3 mb-4">
    <div class="col-md-4">
        <div class="card">
            <div class="card-body">
                <h5 class="card-title"><?php echo e(trans('messages.total_backups')); ?></h5>
                <h2 class="mb-0"><?php echo e($backups->count()); ?></h2>
            </div>
        </div>
    </div>
    <div class="col-md-4">
        <div class="card">
            <div class="card-body">
                <h5 class="card-title"><?php echo e(trans('messages.total_size')); ?></h5>
                <h2 class="mb-0"><?php echo e(format_file_size($totalSize)); ?></h2>
            </div>
        </div>
    </div>
    <div class="col-md-4">
        <div class="card">
            <div class="card-body">
                <h5 class="card-title"><?php echo e(trans('messages.latest_backup')); ?></h5>
                <h6 class="mb-0">
                    <?php if($latestBackup): ?>
                        <?php echo e(\Carbon\Carbon::createFromTimestamp($latestBackup['created_at'])->format('Y-m-d H:i:s')); ?>

                    <?php else: ?>
                        <span class="text-danger"><?php echo e(trans('messages.no_backup_created')); ?></span>
                    <?php endif; ?>
                </h6>
            </div>
        </div>
    </div>
</div>

<?php if($backups->isEmpty()): ?>
<div class="alert alert-warning">
    <i class="bi bi-exclamation-triangle"></i> <?php echo e(trans('messages.no_backups_found')); ?>

</div>
<?php else: ?>
<div class="card">
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-hover">
                <thead>
                    <tr>
                        <th><?php echo e(trans('messages.filename')); ?></th>
                        <th><?php echo e(trans('messages.size')); ?></th>
                        <th><?php echo e(trans('messages.created_at')); ?></th>
                        <th><?php echo e(trans('messages.actions')); ?></th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $backups; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $backup): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($backup['filename']); ?></td>
                        <td><?php echo e(format_file_size($backup['size'])); ?></td>
                        <td><?php echo e(\Carbon\Carbon::createFromTimestamp($backup['created_at'])->format('Y-m-d H:i:s')); ?></td>
                        <td>
                            <a href="<?php echo e(route('backups.download', $backup['filename'])); ?>" class="btn btn-sm btn-primary">
                                <i class="bi bi-download"></i> <?php echo e(trans('messages.download')); ?>

                            </a>
                            <form action="<?php echo e(route('backups.restore', $backup['filename'])); ?>" method="POST" class="d-inline" onsubmit="return confirm('<?php echo e(trans('messages.confirm_restore_backup')); ?>')">
                                <?php echo csrf_field(); ?>
                                <button type="submit" class="btn btn-sm btn-success">
                                    <i class="bi bi-arrow-clockwise"></i> <?php echo e(trans('messages.restore')); ?>

                                </button>
                            </form>
                            <button type="button" class="btn btn-sm btn-danger" onclick="confirmDelete('<?php echo e($backup['filename']); ?>')">
                                <i class="bi bi-trash"></i> <?php echo e(trans('messages.delete')); ?>

                            </button>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
    </div>
</div>
<?php endif; ?>

<!-- Delete Confirmation Modal -->
<div class="modal fade" id="deleteModal" tabindex="-1" aria-labelledby="deleteModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="deleteModalLabel"><?php echo e(trans('messages.confirm_delete')); ?></h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <p><?php echo e(trans('messages.confirm_delete_backup')); ?></p>
                <p class="text-danger"><strong id="backup-filename"></strong></p>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal"><?php echo e(trans('messages.cancel')); ?></button>
                <form id="delete-form" method="POST" style="display: inline;">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('DELETE'); ?>
                    <button type="submit" class="btn btn-danger"><?php echo e(trans('messages.delete')); ?></button>
                </form>
            </div>
        </div>
    </div>
</div>

<script>
function confirmDelete(filename) {
    document.getElementById('backup-filename').textContent = filename;
    document.getElementById('delete-form').action = '<?php echo e(route("backups.destroy", ":filename")); ?>'.replace(':filename', filename);
    const modal = new bootstrap.Modal(document.getElementById('deleteModal'));
    modal.show();
}

</script>
</div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\GestionStock\resources\views/backups/index.blade.php ENDPATH**/ ?>