

<?php $__env->startSection('title', trans('messages.stock_take')); ?>

<?php $__env->startSection('content'); ?>
<div class="page-header">
    <h2><?php echo e(trans('messages.reference_number')); ?>: <?php echo e($stockTake->reference_number); ?></h2>
    <div>
        <?php if($stockTake->isDraft()): ?>
            <a href="<?php echo e(route('stock-takes.edit', $stockTake)); ?>" class="btn btn-warning">
                <i class="bi bi-pencil"></i> <?php echo e(trans('messages.edit')); ?>

            </a>
        <?php endif; ?>
        <?php if(!$stockTake->isCompleted()): ?>
            <form action="<?php echo e(route('stock-takes.complete', $stockTake)); ?>" method="POST" class="d-inline">
                <?php echo csrf_field(); ?>
                <button type="submit" class="btn btn-success" onclick="return confirm('<?php echo e(trans('messages.confirm_complete_stock_take')); ?>')">
                    <i class="bi bi-check-circle"></i> <?php echo e(trans('messages.complete_stock_take')); ?>

                </button>
            </form>
        <?php endif; ?>
        <a href="<?php echo e(route('stock-takes.index')); ?>" class="btn btn-secondary"><?php echo e(trans('messages.back')); ?></a>
    </div>
</div>

<div class="row">
    <div class="col-md-12">
        <div class="card mb-3">
            <div class="card-header">
                <h5 class="mb-0"><?php echo e(trans('messages.stock_take_details')); ?></h5>
            </div>
            <div class="card-body">
                <div class="row mb-3">
                    <div class="col-md-4">
                        <p><strong><?php echo e(trans('messages.stock_take_date')); ?>:</strong> <?php echo e($stockTake->stock_take_date->format('Y-m-d')); ?></p>
                        <p><strong><?php echo e(trans('messages.type')); ?>:</strong> 
                            <span class="badge bg-info"><?php echo e(trans('messages.' . $stockTake->type)); ?></span>
                        </p>
                    </div>
                    <div class="col-md-4">
                        <p><strong><?php echo e(trans('messages.status')); ?>:</strong> 
                            <?php
                                $badgeClass = match($stockTake->status) {
                                    'draft' => 'secondary',
                                    'in_progress' => 'warning',
                                    'completed' => 'success',
                                    default => 'secondary'
                                };
                            ?>
                            <span class="badge bg-<?php echo e($badgeClass); ?>"><?php echo e(trans('messages.' . $stockTake->status)); ?></span>
                        </p>
                        <p><strong><?php echo e(trans('messages.items_count')); ?>:</strong> <?php echo e($stockTake->items->count()); ?></p>
                    </div>
                    <div class="col-md-4">
                        <p><strong><?php echo e(trans('messages.created_by')); ?>:</strong> <?php echo e($stockTake->creator->name ?? '-'); ?></p>
                        <?php if($stockTake->completer): ?>
                            <p><strong><?php echo e(trans('messages.completed_by')); ?>:</strong> <?php echo e($stockTake->completer->name); ?></p>
                            <p><strong><?php echo e(trans('messages.completed_at')); ?>:</strong> <?php echo e($stockTake->completed_at->format('Y-m-d H:i')); ?></p>
                        <?php endif; ?>
                    </div>
                </div>

                <?php if($stockTake->notes): ?>
                <div class="mb-3">
                    <strong><?php echo e(trans('messages.notes')); ?>:</strong>
                    <p><?php echo e($stockTake->notes); ?></p>
                </div>
                <?php endif; ?>

                <h5 class="mt-4"><?php echo e(trans('messages.items')); ?></h5>
                <div class="table-responsive">
                    <table class="table table-striped">
                        <thead>
                            <tr>
                                <th><?php echo e(trans('messages.product')); ?></th>
                                <th><?php echo e(trans('messages.system_quantity')); ?></th>
                                <th><?php echo e(trans('messages.counted_quantity')); ?></th>
                                <th><?php echo e(trans('messages.variance')); ?></th>
                                <th><?php echo e(trans('messages.variance_value')); ?></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $stockTake->items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($item->product->name); ?></td>
                                <td><?php echo e($item->system_quantity); ?></td>
                                <td><?php echo e($item->counted_quantity); ?></td>
                                <td>
                                    <span class="badge bg-<?php echo e($item->variance == 0 ? 'success' : ($item->variance > 0 ? 'info' : 'danger')); ?>">
                                        <?php echo e($item->variance > 0 ? '+' : ''); ?><?php echo e($item->variance); ?>

                                    </span>
                                </td>
                                <td><?php echo e($item->variance_value ? format_currency($item->variance_value) : '-'); ?></td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\GestionStock\resources\views/stock-takes/show.blade.php ENDPATH**/ ?>