

<?php $__env->startSection('title', trans('messages.quality_complaints')); ?>

<?php $__env->startSection('content'); ?>
<?php
    $sort = request()->get('sort', 'created_at');
    $direction = request()->get('direction', 'desc');
?>
<div class="page-header">
    <h2><?php echo e(trans('messages.quality_complaints')); ?></h2>
    <div>
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('quality.complaints.create')): ?>
            <a href="<?php echo e(route('quality.complaints.create')); ?>" class="btn btn-primary"><i class="bi bi-plus-circle"></i> <?php echo e(trans('messages.add_complaint')); ?></a>
        <?php endif; ?>
    </div>
</div>

<div class="card">
    <div class="card-body">
        <form method="GET" action="<?php echo e(route('quality.complaints.index')); ?>" class="mb-3">
            <div class="row g-3">
                <div class="col-md-3">
                    <input type="text" name="search" class="form-control" placeholder="<?php echo e(trans('messages.search')); ?>..." value="<?php echo e(request('search')); ?>">
                </div>
                <div class="col-md-2">
                    <select name="status" class="form-select">
                        <option value=""><?php echo e(trans('messages.all_statuses')); ?></option>
                        <option value="new" <?php echo e(request('status') == 'new' ? 'selected' : ''); ?>><?php echo e(trans('messages.new')); ?></option>
                        <option value="in_progress" <?php echo e(request('status') == 'in_progress' ? 'selected' : ''); ?>><?php echo e(trans('messages.in_progress')); ?></option>
                        <option value="resolved" <?php echo e(request('status') == 'resolved' ? 'selected' : ''); ?>><?php echo e(trans('messages.resolved')); ?></option>
                        <option value="closed" <?php echo e(request('status') == 'closed' ? 'selected' : ''); ?>><?php echo e(trans('messages.closed')); ?></option>
                        <option value="rejected" <?php echo e(request('status') == 'rejected' ? 'selected' : ''); ?>><?php echo e(trans('messages.rejected')); ?></option>
                    </select>
                </div>
                <div class="col-md-2">
                    <select name="severity" class="form-select">
                        <option value=""><?php echo e(trans('messages.all_severities')); ?></option>
                        <option value="low" <?php echo e(request('severity') == 'low' ? 'selected' : ''); ?>><?php echo e(trans('messages.low')); ?></option>
                        <option value="medium" <?php echo e(request('severity') == 'medium' ? 'selected' : ''); ?>><?php echo e(trans('messages.medium')); ?></option>
                        <option value="high" <?php echo e(request('severity') == 'high' ? 'selected' : ''); ?>><?php echo e(trans('messages.high')); ?></option>
                        <option value="critical" <?php echo e(request('severity') == 'critical' ? 'selected' : ''); ?>><?php echo e(trans('messages.critical')); ?></option>
                    </select>
                </div>
                <div class="col-md-2">
                    <select name="complaint_type" class="form-select">
                        <option value=""><?php echo e(trans('messages.all_types')); ?></option>
                        <option value="customer" <?php echo e(request('complaint_type') == 'customer' ? 'selected' : ''); ?>><?php echo e(trans('messages.customer')); ?></option>
                        <option value="supplier" <?php echo e(request('complaint_type') == 'supplier' ? 'selected' : ''); ?>><?php echo e(trans('messages.supplier')); ?></option>
                        <option value="internal" <?php echo e(request('complaint_type') == 'internal' ? 'selected' : ''); ?>><?php echo e(trans('messages.internal')); ?></option>
                        <option value="other" <?php echo e(request('complaint_type') == 'other' ? 'selected' : ''); ?>><?php echo e(trans('messages.other')); ?></option>
                    </select>
                </div>
                <div class="col-md-3">
                    <button type="submit" class="btn btn-secondary w-100"><?php echo e(trans('messages.filter')); ?></button>
                </div>
            </div>
        </form>

        <div class="table-responsive">
            <table class="table table-hover">
                <thead>
                    <tr>
                        <th>
                            <a href="<?php echo e(route('quality.complaints.index', array_merge(request()->all(), ['sort' => 'complaint_number', 'direction' => $sort === 'complaint_number' && $direction === 'asc' ? 'desc' : 'asc']))); ?>" class="text-decoration-none text-dark">
                                <?php echo e(trans('messages.complaint_number')); ?>

                                <?php if($sort === 'complaint_number'): ?>
                                    <i class="bi bi-arrow-<?php echo e($direction === 'asc' ? 'up' : 'down'); ?>"></i>
                                <?php endif; ?>
                            </a>
                        </th>
                        <th><?php echo e(trans('messages.complaint_type')); ?></th>
                        <th><?php echo e(trans('messages.product')); ?></th>
                        <th><?php echo e(trans('messages.complainant')); ?></th>
                        <th><?php echo e(trans('messages.severity')); ?></th>
                        <th>
                            <a href="<?php echo e(route('quality.complaints.index', array_merge(request()->all(), ['sort' => 'reported_date', 'direction' => $sort === 'reported_date' && $direction === 'asc' ? 'desc' : 'asc']))); ?>" class="text-decoration-none text-dark">
                                <?php echo e(trans('messages.reported_date')); ?>

                                <?php if($sort === 'reported_date'): ?>
                                    <i class="bi bi-arrow-<?php echo e($direction === 'asc' ? 'up' : 'down'); ?>"></i>
                                <?php endif; ?>
                            </a>
                        </th>
                        <th>
                            <a href="<?php echo e(route('quality.complaints.index', array_merge(request()->all(), ['sort' => 'status', 'direction' => $sort === 'status' && $direction === 'asc' ? 'desc' : 'asc']))); ?>" class="text-decoration-none text-dark">
                                <?php echo e(trans('messages.status')); ?>

                                <?php if($sort === 'status'): ?>
                                    <i class="bi bi-arrow-<?php echo e($direction === 'asc' ? 'up' : 'down'); ?>"></i>
                                <?php endif; ?>
                            </a>
                        </th>
                        <th><?php echo e(trans('messages.actions')); ?></th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $complaints; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $complaint): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr>
                        <td><strong><?php echo e($complaint->complaint_number); ?></strong></td>
                        <td><?php echo e(trans('messages.complaint_type_' . $complaint->complaint_type)); ?></td>
                        <td>
                            <?php if($complaint->product): ?>
                                <a href="<?php echo e(route('products.show', $complaint->product)); ?>"><?php echo e($complaint->product->name); ?></a>
                            <?php else: ?>
                                -
                            <?php endif; ?>
                        </td>
                        <td>
                            <?php if($complaint->customer): ?>
                                <a href="<?php echo e(route('customers.show', $complaint->customer)); ?>"><?php echo e($complaint->customer->name); ?></a>
                            <?php elseif($complaint->supplier): ?>
                                <a href="<?php echo e(route('suppliers.show', $complaint->supplier)); ?>"><?php echo e($complaint->supplier->name); ?></a>
                            <?php elseif($complaint->complainant_name): ?>
                                <?php echo e($complaint->complainant_name); ?>

                            <?php else: ?>
                                -
                            <?php endif; ?>
                        </td>
                        <td>
                            <span class="badge bg-<?php echo e($complaint->getSeverityBadgeClass()); ?>">
                                <?php echo e(trans('messages.severity_' . $complaint->severity)); ?>

                            </span>
                        </td>
                        <td><?php echo e($complaint->reported_date->format('Y-m-d')); ?></td>
                        <td>
                            <span class="badge bg-<?php echo e($complaint->getStatusBadgeClass()); ?>">
                                <?php echo e(trans('messages.status_' . $complaint->status)); ?>

                            </span>
                        </td>
                        <td>
                            <a href="<?php echo e(route('quality.complaints.show', $complaint)); ?>" class="btn btn-sm btn-info">
                                <i class="bi bi-eye"></i>
                            </a>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('quality.complaints.update')): ?>
                                <a href="<?php echo e(route('quality.complaints.edit', $complaint)); ?>" class="btn btn-sm btn-warning">
                                    <i class="bi bi-pencil"></i>
                                </a>
                            <?php endif; ?>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('quality.complaints.delete')): ?>
                                <form action="<?php echo e(route('quality.complaints.destroy', $complaint)); ?>" method="POST" class="d-inline" onsubmit="return confirm('<?php echo e(trans('messages.confirm_delete_complaint')); ?>')">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('DELETE'); ?>
                                    <button type="submit" class="btn btn-sm btn-danger">
                                        <i class="bi bi-trash"></i>
                                    </button>
                                </form>
                            <?php endif; ?>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td colspan="8" class="text-center"><?php echo e(trans('messages.no_complaints_found')); ?></td>
                    </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>

        <div class="card-footer">
            <?php echo e($complaints->links()); ?>

        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\GestionStock\resources\views/quality/complaints/index.blade.php ENDPATH**/ ?>