

<?php $__env->startSection('title', trans('messages.dashboard')); ?>

<?php $__env->startSection('content'); ?>
<div class="row mt-4">
    <div class="col-12">
        <h2 class="mb-4"><?php echo e(trans('messages.dashboard')); ?></h2>
    </div>
</div>

<div class="row g-3 mb-4">
    <div class="col-md-3">
        <div class="card text-white bg-primary">
            <div class="card-body">
                <h5 class="card-title"><?php echo e(trans('messages.today_sales')); ?></h5>
                <h3 class="mb-0"><?php echo e(format_currency($todaySales)); ?></h3>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card text-white bg-success">
            <div class="card-body">
                <h5 class="card-title"><?php echo e(trans('messages.month_sales')); ?></h5>
                <h3 class="mb-0"><?php echo e(format_currency($monthSales)); ?></h3>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card text-white bg-warning">
            <div class="card-body">
                <h5 class="card-title"><?php echo e(trans('messages.pending_invoices')); ?></h5>
                <h3 class="mb-0"><?php echo e($pendingInvoices); ?></h3>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card text-white bg-danger">
            <div class="card-body">
                <h5 class="card-title"><?php echo e(trans('messages.low_stock')); ?></h5>
                <h3 class="mb-0"><?php echo e($lowStockProducts); ?></h3>
            </div>
        </div>
    </div>
</div>

<?php if(auth()->check() && (auth()->user()->hasRole('Super Admin') || auth()->user()->hasRole('Admin'))): ?>
<div class="row g-3 mb-4">
    <div class="col-md-12">
        <?php
            $treasuryBalance = \App\Http\Controllers\TreasuryController::getCurrentBalance();
        ?>
        <div class="card <?php echo e($treasuryBalance >= 0 ? 'border-success' : 'border-danger'); ?>">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-center">
                    <div>
                        <h5 class="card-title mb-0"><?php echo e(trans('messages.current_cash_balance')); ?></h5>
                        <h2 class="mb-0 <?php echo e($treasuryBalance >= 0 ? 'text-success' : 'text-danger'); ?>"><?php echo e(format_currency($treasuryBalance)); ?></h2>
                    </div>
                    <div>
                        <a href="<?php echo e(route('treasury.dashboard')); ?>" class="btn btn-primary"><i class="bi bi-cash-coin"></i> <?php echo e(trans('messages.treasury_dashboard')); ?></a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php endif; ?>

<!-- Warehouse Statistics (Only if multiple warehouses mode is enabled) -->
<?php if(isset($warehouseStats) && $warehouseStats): ?>
<div class="row g-3 mb-4">
    <div class="col-12">
        <div class="card border-info">
            <div class="card-header bg-info text-white">
                <h5 class="mb-0">
                    <i class="bi bi-boxes"></i> <?php echo e(trans('messages.warehouses_statistics')); ?>

                </h5>
            </div>
            <div class="card-body">
                <div class="row g-3">
                    <div class="col-md-3">
                        <div class="text-center">
                            <h3 class="text-primary mb-0"><?php echo e($warehouseStats['total_warehouses']); ?></h3>
                            <p class="text-muted mb-0"><?php echo e(trans('messages.total_warehouses')); ?></p>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="text-center">
                            <h3 class="text-success mb-0"><?php echo e(format_currency($warehouseStats['total_stock_value'])); ?></h3>
                            <p class="text-muted mb-0"><?php echo e(trans('messages.total_stock_value')); ?></p>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="text-center">
                            <h3 class="text-info mb-0"><?php echo e(number_format($warehouseStats['total_products'])); ?></h3>
                            <p class="text-muted mb-0"><?php echo e(trans('messages.total_products')); ?></p>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="text-center">
                            <a href="<?php echo e(route('reports.warehouses')); ?>" class="btn btn-primary">
                                <i class="bi bi-graph-up"></i> <?php echo e(trans('messages.view_warehouses_report')); ?>

                            </a>
                        </div>
                    </div>
                </div>
                
                <?php if($warehouseStats['warehouses']->count() > 0): ?>
                <hr>
                <h6 class="mb-3"><?php echo e(trans('messages.warehouses_overview')); ?></h6>
                <div class="table-responsive">
                    <table class="table table-sm">
                        <thead>
                            <tr>
                                <th><?php echo e(trans('messages.warehouse')); ?></th>
                                <th class="text-end"><?php echo e(trans('messages.products_count')); ?></th>
                                <th class="text-end"><?php echo e(trans('messages.stock_value')); ?></th>
                                <th class="text-center"><?php echo e(trans('messages.status')); ?></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $warehouseStats['warehouses']->take(5); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $warehouse): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr class="<?php echo e($warehouse->is_default ? 'table-primary' : ''); ?>">
                                <td>
                                    <a href="<?php echo e(route('warehouses.show', $warehouse)); ?>">
                                        <?php echo e(app()->getLocale() === 'ar' && $warehouse->name_ar ? $warehouse->name_ar : $warehouse->name); ?>

                                    </a>
                                    <?php if($warehouse->is_default): ?>
                                        <span class="badge bg-info ms-2"><?php echo e(trans('messages.default')); ?></span>
                                    <?php endif; ?>
                                </td>
                                <td class="text-end"><?php echo e(number_format($warehouse->total_products_count)); ?></td>
                                <td class="text-end"><?php echo e(format_currency($warehouse->total_stock_value)); ?></td>
                                <td class="text-center">
                                    <?php if($warehouse->is_active): ?>
                                        <span class="badge bg-success"><?php echo e(trans('messages.active')); ?></span>
                                    <?php else: ?>
                                        <span class="badge bg-secondary"><?php echo e(trans('messages.inactive')); ?></span>
                                    <?php endif; ?>
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
                <?php if($warehouseStats['warehouses']->count() > 5): ?>
                    <div class="text-center mt-2">
                        <a href="<?php echo e(route('reports.warehouses')); ?>" class="btn btn-sm btn-outline-primary">
                            <?php echo e(trans('messages.view_all_warehouses')); ?>

                        </a>
                    </div>
                <?php endif; ?>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>
<?php endif; ?>

<!-- Notifications Section -->
<?php if(isset($notifications) && $notifications->count() > 0): ?>
<div class="row g-3 mb-4">
    <div class="col-12">
        <div class="card">
            <div class="card-header d-flex justify-content-between align-items-center">
                <h5 class="mb-0">
                    <i class="bi bi-bell"></i> <?php echo e(trans('messages.notifications')); ?>

                    <?php if(isset($unreadCount) && $unreadCount > 0): ?>
                        <span class="badge bg-danger ms-2"><?php echo e($unreadCount); ?></span>
                    <?php endif; ?>
                </h5>
                <div>
                    <button type="button" class="btn btn-sm btn-outline-primary" onclick="markAllNotificationsAsRead()">
                        <i class="bi bi-check-all"></i> <?php echo e(trans('messages.mark_all_as_read')); ?>

                    </button>
                </div>
            </div>
            <div class="card-body">
                <div class="list-group">
                    <?php $__currentLoopData = $notifications; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $notification): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="list-group-item list-group-item-action <?php echo e(!$notification->is_read ? 'list-group-item-warning' : ''); ?>" 
                         data-notification-id="<?php echo e($notification->id); ?>"
                         onclick="handleNotificationClick(<?php echo e($notification->id); ?>, '<?php echo e($notification->url); ?>')"
                         style="cursor: pointer;">
                        <div class="d-flex w-100 justify-content-between align-items-start">
                            <div class="flex-grow-1">
                                <div class="d-flex align-items-center mb-1">
                                    <i class="bi <?php echo e($notification->icon); ?> text-<?php echo e($notification->severity_badge); ?> me-2"></i>
                                    <h6 class="mb-0 <?php echo e(!$notification->is_read ? 'fw-bold' : ''); ?>">
                                        <?php echo e($notification->title); ?>

                                    </h6>
                                    <?php if(!$notification->is_read): ?>
                                        <span class="badge bg-primary ms-2"><?php echo e(trans('messages.new')); ?></span>
                                    <?php endif; ?>
                                </div>
                                <p class="mb-1 text-muted"><?php echo e($notification->message); ?></p>
                                <small class="text-muted"><?php echo e($notification->created_at->diffForHumans()); ?></small>
                            </div>
                            <div class="ms-3">
                                <button type="button" class="btn btn-sm btn-outline-danger" 
                                        onclick="event.stopPropagation(); deleteNotification(<?php echo e($notification->id); ?>)"
                                        title="<?php echo e(trans('messages.delete')); ?>">
                                    <i class="bi bi-trash"></i>
                                </button>
                            </div>
                        </div>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </div>
    </div>
</div>
<?php endif; ?>

<?php if(isset($showRecentInvoices) && $showRecentInvoices || isset($showLowStock) && $showLowStock): ?>
<div class="row g-3 mb-4">
    <?php if(isset($showRecentInvoices) && $showRecentInvoices): ?>
    <div class="col-md-6">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0"><?php echo e(trans('messages.recent_invoices')); ?></h5>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-sm">
                        <thead>
                            <tr>
                                <th><?php echo e(trans('messages.invoice_number')); ?></th>
                                <th><?php echo e(trans('messages.customer')); ?></th>
                                <th><?php echo e(trans('messages.total')); ?></th>
                                <th><?php echo e(trans('messages.status')); ?></th>
                                <th><?php echo e(trans('messages.date')); ?></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__empty_1 = true; $__currentLoopData = $recentInvoices; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $invoice): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td><a href="<?php echo e(route('invoices.show', $invoice)); ?>"><?php echo e($invoice->invoice_number); ?></a></td>
                                <td><?php echo e($invoice->customer?->name ?? $invoice->customer_name); ?></td>
                                <td><?php echo e(format_currency($invoice->total)); ?></td>
                                <td>
                                    <?php
                                        $badgeClass = match($invoice->status) {
                                            'paid' => 'success',
                                            'partially_paid' => 'warning',
                                            'draft' => 'secondary',
                                            'returned' => 'danger',
                                            default => 'info'
                                        };
                                    ?>
                                    <span class="badge bg-<?php echo e($badgeClass); ?>"><?php echo e(trans('messages.' . $invoice->status)); ?></span>
                                </td>
                                <td><?php echo e($invoice->created_at->format('Y-m-d')); ?></td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="5" class="text-center"><?php echo e(trans('messages.no_invoices_found')); ?></td>
                            </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
    <?php endif; ?>
    <?php if(isset($showLowStock) && $showLowStock): ?>
    <div class="col-md-6">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0"><?php echo e(trans('messages.low_stock_products')); ?></h5>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-sm">
                        <thead>
                            <tr>
                                <th><?php echo e(trans('messages.name')); ?></th>
                                <th><?php echo e(trans('messages.stock')); ?></th>
                                <th><?php echo e(trans('messages.reorder_level')); ?></th>
                                <th><?php echo e(trans('messages.category')); ?></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__empty_1 = true; $__currentLoopData = $lowStockItems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td><a href="<?php echo e(route('products.show', $product)); ?>"><?php echo e($product->name); ?></a></td>
                                <td><span class="badge bg-danger"><?php echo e($product->stock_quantity); ?></span></td>
                                <td><?php echo e($product->reorder_level); ?></td>
                                <td><?php echo e($product->category?->name ?? 'N/A'); ?></td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="4" class="text-center"><?php echo e(trans('messages.no_products_found')); ?></td>
                            </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
    <?php endif; ?>
</div>
<?php endif; ?>

<!-- Quality Management Statistics -->
<?php if(isset($qualityStats) && $qualityStats): ?>
<div class="row g-3 mb-4">
    <div class="col-12">
        <div class="card border-info">
            <div class="card-header bg-info text-white">
                <h5 class="mb-0">
                    <i class="bi bi-shield-check"></i> <?php echo e(trans('messages.quality_management')); ?>

                </h5>
            </div>
            <div class="card-body">
                <div class="row g-3">
                    <div class="col-md-2">
                        <div class="text-center">
                            <h3 class="text-danger mb-0"><?php echo e($qualityStats['total_defects']); ?></h3>
                            <p class="text-muted mb-0"><?php echo e(trans('messages.total_defects')); ?></p>
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="text-center">
                            <h3 class="text-success mb-0"><?php echo e($qualityStats['resolved_defects']); ?></h3>
                            <p class="text-muted mb-0"><?php echo e(trans('messages.resolved_defects')); ?></p>
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="text-center">
                            <h3 class="text-warning mb-0"><?php echo e($qualityStats['critical_defects']); ?></h3>
                            <p class="text-muted mb-0"><?php echo e(trans('messages.critical_defects')); ?></p>
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="text-center">
                            <h3 class="text-danger mb-0"><?php echo e($qualityStats['total_complaints']); ?></h3>
                            <p class="text-muted mb-0"><?php echo e(trans('messages.total_complaints')); ?></p>
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="text-center">
                            <h3 class="text-success mb-0"><?php echo e($qualityStats['resolved_complaints']); ?></h3>
                            <p class="text-muted mb-0"><?php echo e(trans('messages.resolved_complaints')); ?></p>
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="text-center">
                            <h3 class="text-warning mb-0"><?php echo e($qualityStats['critical_complaints']); ?></h3>
                            <p class="text-muted mb-0"><?php echo e(trans('messages.critical_complaints')); ?></p>
                        </div>
                    </div>
                </div>
                <hr>
                <div class="text-center">
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('quality.reports.view')): ?>
                        <a href="<?php echo e(route('quality.reports.index')); ?>" class="btn btn-primary">
                            <i class="bi bi-file-earmark-bar-graph"></i> <?php echo e(trans('messages.quality_reports')); ?>

                        </a>
                    <?php endif; ?>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('quality.defects.view')): ?>
                        <a href="<?php echo e(route('quality.defects.index')); ?>" class="btn btn-outline-danger">
                            <i class="bi bi-exclamation-triangle"></i> <?php echo e(trans('messages.product_defects')); ?>

                        </a>
                    <?php endif; ?>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('quality.complaints.view')): ?>
                        <a href="<?php echo e(route('quality.complaints.index')); ?>" class="btn btn-outline-warning">
                            <i class="bi bi-chat-left-text"></i> <?php echo e(trans('messages.quality_complaints')); ?>

                        </a>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>
<?php endif; ?>

<?php $__env->startPush('scripts'); ?>
<script>
function handleNotificationClick(notificationId, url) {
    // Mark as read
    fetch(`/notifications/${notificationId}/read`, {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content
        }
    }).then(() => {
        // Redirect to URL if available
        if (url) {
            window.location.href = url;
        } else {
            // Reload page to update notification status
            location.reload();
        }
    });
}

function markAllNotificationsAsRead() {
    if (!confirm('<?php echo e(trans('messages.confirm_mark_all_as_read')); ?>')) {
        return;
    }

    fetch('/notifications/read-all', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content
        }
    }).then(response => response.json())
      .then(data => {
          if (data.success) {
              location.reload();
          }
      });
}

function deleteNotification(notificationId) {
    if (!confirm('<?php echo e(trans('messages.confirm_delete_notification')); ?>')) {
        return;
    }

    fetch(`/notifications/${notificationId}`, {
        method: 'DELETE',
        headers: {
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content
        }
    }).then(response => response.json())
      .then(data => {
          if (data.success) {
              location.reload();
          }
      });
}

// Auto-refresh notifications every 5 minutes
setInterval(function() {
    fetch('/notifications/unread-count')
        .then(response => response.json())
        .then(data => {
            // Update badge if count changed
            const badge = document.querySelector('.badge.bg-danger');
            if (badge && parseInt(badge.textContent) !== data.count) {
                if (data.count > 0) {
                    badge.textContent = data.count;
                    badge.style.display = 'inline-block';
                } else {
                    badge.style.display = 'none';
                }
            }
        });
}, 300000); // 5 minutes
</script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\GestionStock\resources\views/dashboard.blade.php ENDPATH**/ ?>